USE [master]
GO
/****** Object:  Database [FleetManagement]    Script Date: 02/03/2009 09:27:45 ******/
IF  EXISTS (SELECT name FROM sys.databases WHERE name = N'FleetManagement')
DROP DATABASE [FleetManagement]
GO
USE [master]
GO
/****** Object:  Database [FleetManagement]    Script Date: 02/03/2009 09:27:45 ******/
CREATE DATABASE [FleetManagement]
GO
Use FleetManagement
Go
/****** Object:  View [dbo].[View_BatteryForQuery]    Script Date: 04/11/2013 17:29:00 ******/
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[View_BatteryForQuery]'))
DROP VIEW [dbo].[View_BatteryForQuery]
GO
/****** Object:  ForeignKey [Company_Battery]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[Company_Battery]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [Company_Battery]
GO
/****** Object:  ForeignKey [FK_Battery_AlertInfo]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Battery_AlertInfo]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [FK_Battery_AlertInfo]
GO
/****** Object:  ForeignKey [FK_Battery_Battery]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Battery_Battery]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [FK_Battery_Battery]
GO
/****** Object:  StoredProcedure [dbo].[BatteryUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryUpdateCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[BatteryUpdateCommand]
GO
/****** Object:  StoredProcedure [dbo].[BatteryInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryInsertCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[BatteryInsertCommand]
GO
/****** Object:  StoredProcedure [dbo].[CompanyUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CompanyUpdateCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[CompanyUpdateCommand]
GO
/****** Object:  StoredProcedure [dbo].[Calculate]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Calculate]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[Calculate]
GO
/****** Object:  StoredProcedure [dbo].[RadioFamilyKitNumberUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioFamilyKitNumberUpdateCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioFamilyKitNumberUpdateCommand]
GO
/****** Object:  StoredProcedure [dbo].[RadioFamilyKitNumberInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioFamilyKitNumberInsertCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioFamilyKitNumberInsertCommand]
GO
/****** Object:  StoredProcedure [dbo].[BatteryDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryDeleteCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[BatteryDeleteCommand]
GO
/****** Object:  StoredProcedure [dbo].[FindBatteryBySerialNumber]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FindBatteryBySerialNumber]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[FindBatteryBySerialNumber]
GO
/****** Object:  StoredProcedure [dbo].[BatterySelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatterySelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[BatterySelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[BatterySelectBySerialNumber]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatterySelectBySerialNumber]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[BatterySelectBySerialNumber]
GO
/****** Object:  StoredProcedure [dbo].[FindBySerialNumber]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FindBySerialNumber]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[FindBySerialNumber]
GO
/****** Object:  StoredProcedure [dbo].[RawBatterySelectBySerialNumber]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RawBatterySelectBySerialNumber]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RawBatterySelectBySerialNumber]
GO
/****** Object:  StoredProcedure [dbo].[ErrorBatteriesReprot]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ErrorBatteriesReprot]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ErrorBatteriesReprot]
GO
/****** Object:  StoredProcedure [dbo].[MarkableDataSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MarkableDataSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[MarkableDataSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[ViewChartSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewChartSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ViewChartSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[ChartInformationSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ChartInformationSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ChartInformationSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[BatteryChargeStateTypeSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryChargeStateTypeSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[BatteryChargeStateTypeSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[BatteryChargeStatusTypeSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryChargeStatusTypeSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[BatteryChargeStatusTypeSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[ThresholdExpressSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ThresholdExpressSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ThresholdExpressSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[ColumnInformationSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ColumnInformationSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ColumnInformationSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[ColumnInformationDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ColumnInformationDeleteCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ColumnInformationDeleteCommand]
GO
/****** Object:  StoredProcedure [dbo].[ColumnInformationInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ColumnInformationInsertCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ColumnInformationInsertCommand]
GO
/****** Object:  StoredProcedure [dbo].[ColumnInformationUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ColumnInformationUpdateCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ColumnInformationUpdateCommand]
GO
/****** Object:  StoredProcedure [dbo].[BatteryLEDStatusTypeSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryLEDStatusTypeSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[BatteryLEDStatusTypeSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[BatteryChemistryTypeSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryChemistryTypeSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[BatteryChemistryTypeSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[LanguageSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[LanguageSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[LanguageSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[RecommendationTypeSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RecommendationTypeSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RecommendationTypeSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[PermissionDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PermissionDeleteCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[PermissionDeleteCommand]
GO
/****** Object:  StoredProcedure [dbo].[PermissionInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PermissionInsertCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[PermissionInsertCommand]
GO
/****** Object:  StoredProcedure [dbo].[PermissionSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PermissionSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[PermissionSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[PermissionUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PermissionUpdateCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[PermissionUpdateCommand]
GO
/****** Object:  StoredProcedure [dbo].[ViewSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ViewSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[ViewInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewInsertCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ViewInsertCommand]
GO
/****** Object:  StoredProcedure [dbo].[ViewUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewUpdateCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ViewUpdateCommand]
GO
/****** Object:  StoredProcedure [dbo].[ViewDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewDeleteCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ViewDeleteCommand]
GO
/****** Object:  StoredProcedure [dbo].[BatteryStatusTypeSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryStatusTypeSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[BatteryStatusTypeSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[RadioFamilyDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioFamilyDeleteCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioFamilyDeleteCommand]
GO
/****** Object:  StoredProcedure [dbo].[RadioFamilyInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioFamilyInsertCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioFamilyInsertCommand]
GO
/****** Object:  StoredProcedure [dbo].[RadioFamilySelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioFamilySelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioFamilySelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[RadioFamilyUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioFamilyUpdateCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioFamilyUpdateCommand]
GO
/****** Object:  StoredProcedure [dbo].[ViewColumnDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewColumnDeleteCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ViewColumnDeleteCommand]
GO
/****** Object:  StoredProcedure [dbo].[ViewColumnUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewColumnUpdateCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ViewColumnUpdateCommand]
GO
/****** Object:  StoredProcedure [dbo].[ViewColumnInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewColumnInsertCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ViewColumnInsertCommand]
GO
/****** Object:  StoredProcedure [dbo].[ViewColumnSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewColumnSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ViewColumnSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[UserInfoSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UserInfoSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[UserInfoSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[UserInfoInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UserInfoInsertCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[UserInfoInsertCommand]
GO
/****** Object:  StoredProcedure [dbo].[UserInfoUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UserInfoUpdateCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[UserInfoUpdateCommand]
GO
/****** Object:  StoredProcedure [dbo].[UserInfoDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UserInfoDeleteCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[UserInfoDeleteCommand]
GO
/****** Object:  StoredProcedure [dbo].[LocationUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[LocationUpdateCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[LocationUpdateCommand]
GO
/****** Object:  StoredProcedure [dbo].[LocationInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[LocationInsertCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[LocationInsertCommand]
GO
/****** Object:  StoredProcedure [dbo].[LocationSelectByName]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[LocationSelectByName]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[LocationSelectByName]
GO
/****** Object:  StoredProcedure [dbo].[LocationSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[LocationSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[LocationSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[LocationDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[LocationDeleteCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[LocationDeleteCommand]
GO
/****** Object:  StoredProcedure [dbo].[PurchaseReport]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PurchaseReport]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[PurchaseReport]
GO
/****** Object:  UserDefinedFunction [dbo].[RecommendationExented]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RecommendationExented]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[RecommendationExented]
GO
/****** Object:  UserDefinedFunction [dbo].[RecommendationDetails]    Script Date: 08/03/2012 18:05:25 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RecommendationDetails]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[RecommendationDetails]
GO
/****** Object:  UserDefinedFunction [dbo].[GetOverdueThreshold]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetOverdueThreshold]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[GetOverdueThreshold]
GO
/****** Object:  StoredProcedure [dbo].[CompanySelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CompanySelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[CompanySelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[CompanyInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CompanyInsertCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[CompanyInsertCommand]
GO
/****** Object:  StoredProcedure [dbo].[CompanyDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CompanyDeleteCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[CompanyDeleteCommand]
GO
/****** Object:  StoredProcedure [dbo].[ComputerDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ComputerDeleteCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ComputerDeleteCommand]
GO
/****** Object:  StoredProcedure [dbo].[ComputerInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ComputerInsertCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ComputerInsertCommand]
GO
/****** Object:  StoredProcedure [dbo].[ComputerSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ComputerSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ComputerSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[ComputerUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ComputerUpdateCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ComputerUpdateCommand]
GO
/****** Object:  StoredProcedure [dbo].[AlertInfoSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AlertInfoSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[AlertInfoSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[BatteryHistoryInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryHistoryInsertCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[BatteryHistoryInsertCommand]
GO
/****** Object:  StoredProcedure [dbo].[FindBatteryHistoryBySerialNumber]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FindBatteryHistoryBySerialNumber]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[FindBatteryHistoryBySerialNumber]
GO
/****** Object:  StoredProcedure [dbo].[BatteryHistoryDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryHistoryDeleteCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[BatteryHistoryDeleteCommand]
GO
/****** Object:  StoredProcedure [dbo].[BatteryHistorySelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryHistorySelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[BatteryHistorySelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[BatteryDeleteAll]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryDeleteAll]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[BatteryDeleteAll]
GO
/****** Object:  StoredProcedure [dbo].[PocketUtilizationReport]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PocketUtilizationReport]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[PocketUtilizationReport]
GO
/****** Object:  StoredProcedure [dbo].[DeviceInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceInsertCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[DeviceInsertCommand]
GO
/****** Object:  StoredProcedure [dbo].[DeviceDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceDeleteCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[DeviceDeleteCommand]
GO
/****** Object:  StoredProcedure [dbo].[DeviceUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceUpdateCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[DeviceUpdateCommand]
GO
/****** Object:  StoredProcedure [dbo].[DeviceSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[DeviceSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[BatteryGroupDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryGroupDeleteCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[BatteryGroupDeleteCommand]
GO
/****** Object:  StoredProcedure [dbo].[BatteryGroupUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryGroupUpdateCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[BatteryGroupUpdateCommand]
GO
/****** Object:  StoredProcedure [dbo].[BatteryGroupSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryGroupSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[BatteryGroupSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[BatteryGroupInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryGroupInsertCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[BatteryGroupInsertCommand]
GO
/****** Object:  Table [dbo].[Battery]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Battery]') AND type in (N'U'))
DROP TABLE [dbo].[Battery]
GO
/****** Object:  StoredProcedure [dbo].[DeviceChargeDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceChargeDeleteCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[DeviceChargeDeleteCommand]
GO
/****** Object:  StoredProcedure [dbo].[DeviceChargeSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceChargeSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[DeviceChargeSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[DeviceLogSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceLogSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[DeviceLogSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[DeviceLogUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceLogUpdateCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[DeviceLogUpdateCommand]
GO
/****** Object:  StoredProcedure [dbo].[EOSLReport]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EOSLReport]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[EOSLReport]
GO
/****** Object:  StoredProcedure [dbo].[ManullyUpdateRadioFamily]    Script Date: 10/31/2012 11:32:39 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ManullyUpdateRadioFamily]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ManullyUpdateRadioFamily]
GO
/****** Object:  StoredProcedure [dbo].[RadioFamilyKitNumberSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioFamilyKitNumberSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioFamilyKitNumberSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[RadioFamilyKitNumberDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioFamilyKitNumberDeleteCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioFamilyKitNumberDeleteCommand]
GO
/****** Object:  Table [dbo].[RadioFamilyKitNumber]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioFamilyKitNumber]') AND type in (N'U'))
DROP TABLE [dbo].[RadioFamilyKitNumber]
GO
/****** Object:  StoredProcedure [dbo].[DeviceChargeUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceChargeUpdateCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[DeviceChargeUpdateCommand]
GO
/****** Object:  Table [dbo].[Device]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Device]') AND type in (N'U'))
DROP TABLE [dbo].[Device]
GO
/****** Object:  StoredProcedure [dbo].[BatterySelectDynamic]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatterySelectDynamic]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[BatterySelectDynamic]
GO
/****** Object:  UserDefinedFunction [dbo].[EstimatedDays]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EstimatedDays]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[EstimatedDays]
GO
/****** Object:  Table [dbo].[BatteryGroup]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryGroup]') AND type in (N'U'))
DROP TABLE [dbo].[BatteryGroup]
GO
/****** Object:  Table [dbo].[BatteryLastKnownRadio]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryLastKnownRadio]') AND type in (N'U'))
DROP TABLE [dbo].[BatteryLastKnownRadio]
GO
/****** Object:  Table [dbo].[Filter]    Script Date: 04/14/2014 15:41:17 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Filter]') AND type in (N'U'))
DROP TABLE [dbo].[Filter]
GO
/****** Object:  StoredProcedure [dbo].[AllLostBatteries]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AllLostBatteries]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[AllLostBatteries]
GO
/****** Object:  StoredProcedure [dbo].[AllLostRadios]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AllLostRadios]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[AllLostRadios]
GO
/****** Object:  StoredProcedure [dbo].[AllNonImpres]    Script Date: 06/03/2014 22:22:29 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AllNonImpres]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[AllNonImpres]
GO
/****** Object:  StoredProcedure [dbo].[AllRadioHistory]    Script Date: 06/03/2014 22:22:29 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AllRadioHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[AllRadioHistory]
GO
/****** Object:  StoredProcedure [dbo].[AllBatteryHistory]    Script Date: 06/03/2014 22:22:29 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AllBatteryHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[AllBatteryHistory]
GO
/****** Object:  StoredProcedure [dbo].[AllRadioBatteryInformation]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AllRadioBatteryInformation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[AllRadioBatteryInformation]
GO
/****** Object:  StoredProcedure [dbo].[AllRadioBatteryInformation_Computer]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AllRadioBatteryInformation_Computer]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[AllRadioBatteryInformation_Computer]
GO
/****** Object:  StoredProcedure [dbo].[DeviceLogDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceLogDeleteCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[DeviceLogDeleteCommand]
GO
/****** Object:  StoredProcedure [dbo].[DeviceBatteryLogUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceBatteryLogUpdateCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[DeviceBatteryLogUpdateCommand]
GO
/****** Object:  UserDefinedFunction [dbo].[CreateRecommendation]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CreateRecommendation]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[CreateRecommendation]
GO
/****** Object:  StoredProcedure [dbo].[OverdueBatteries]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[OverdueBatteries]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[OverdueBatteries]
GO
/****** Object:  Table [dbo].[ViewChart]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewChart]') AND type in (N'U'))
DROP TABLE [dbo].[ViewChart]
GO
/****** Object:  Table [dbo].[Translation]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Translation]') AND type in (N'U'))
DROP TABLE [dbo].[Translation]
GO
/****** Object:  Table [dbo].[ChartInformation]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ChartInformation]') AND type in (N'U'))
DROP TABLE [dbo].[ChartInformation]
GO
/****** Object:  Table [dbo].[BatteryChargeStateType]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryChargeStateType]') AND type in (N'U'))
DROP TABLE [dbo].[BatteryChargeStateType]
GO
/****** Object:  Table [dbo].[BatteryChargeStatusType]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryChargeStatusType]') AND type in (N'U'))
DROP TABLE [dbo].[BatteryChargeStatusType]
GO
/****** Object:  Table [dbo].[ThresholdExpress]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ThresholdExpress]') AND type in (N'U'))
DROP TABLE [dbo].[ThresholdExpress]
GO
/****** Object:  Table [dbo].[ColumnInformation]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ColumnInformation]') AND type in (N'U'))
DROP TABLE [dbo].[ColumnInformation]
GO
/****** Object:  Table [dbo].[BatteryLEDStatusType]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryLEDStatusType]') AND type in (N'U'))
DROP TABLE [dbo].[BatteryLEDStatusType]
GO
/****** Object:  Table [dbo].[BatteryChemistryType]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryChemistryType]') AND type in (N'U'))
DROP TABLE [dbo].[BatteryChemistryType]
GO
/****** Object:  Table [dbo].[Language]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Language]') AND type in (N'U'))
DROP TABLE [dbo].[Language]
GO
/****** Object:  Table [dbo].[RecommendationType]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RecommendationType]') AND type in (N'U'))
DROP TABLE [dbo].[RecommendationType]
GO
/****** Object:  Table [dbo].[Permission]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Permission]') AND type in (N'U'))
DROP TABLE [dbo].[Permission]
GO
/****** Object:  Table [dbo].[View]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[View]') AND type in (N'U'))
DROP TABLE [dbo].[View]
GO
/****** Object:  Table [dbo].[BatteryStatusType]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryStatusType]') AND type in (N'U'))
DROP TABLE [dbo].[BatteryStatusType]
GO
/****** Object:  Table [dbo].[RadioFamily]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioFamily]') AND type in (N'U'))
DROP TABLE [dbo].[RadioFamily]
GO
/****** Object:  Table [dbo].[ViewColumn]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewColumn]') AND type in (N'U'))
DROP TABLE [dbo].[ViewColumn]
GO
/****** Object:  Table [dbo].[UserInfo]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UserInfo]') AND type in (N'U'))
DROP TABLE [dbo].[UserInfo]
GO
/****** Object:  Table [dbo].[Version]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Version]') AND type in (N'U'))
DROP TABLE [dbo].[Version]
GO
/****** Object:  Table [dbo].[KitNumAndRadioFamilyReleaseVesion]    Script Date: 18/07/2025 08:37.00 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[KitNumAndRadioFamilyReleaseVesion]') AND type in (N'U'))
DROP TABLE [dbo].[KitNumAndRadioFamilyReleaseVesion]
GO
/****** Object:  Table [dbo].[Location]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Location]') AND type in (N'U'))
DROP TABLE [dbo].[Location]
GO
/****** Object:  Table [dbo].[Company]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Company]') AND type in (N'U'))
DROP TABLE [dbo].[Company]
GO
/****** Object:  StoredProcedure [dbo].[DeviceChargeInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceChargeInsertCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[DeviceChargeInsertCommand]
GO
/****** Object:  StoredProcedure [dbo].[DeviceBatteryLogDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceBatteryLogDeleteCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[DeviceBatteryLogDeleteCommand]
GO
/****** Object:  Table [dbo].[Computer]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Computer]') AND type in (N'U'))
DROP TABLE [dbo].[Computer]
GO
/****** Object:  StoredProcedure [dbo].[DeviceBatteryLogInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceBatteryLogInsertCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[DeviceBatteryLogInsertCommand]
GO
/****** Object:  StoredProcedure [dbo].[DeviceBatteryLogSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceBatteryLogSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[DeviceBatteryLogSelectCommand]
GO
/****** Object:  Table [dbo].[AlertInfo]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AlertInfo]') AND type in (N'U'))
DROP TABLE [dbo].[AlertInfo]
GO
/****** Object:  StoredProcedure [dbo].[DeviceLogInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceLogInsertCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[DeviceLogInsertCommand]
GO
/****** Object:  Table [dbo].[BatteryHistory]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryHistory]') AND type in (N'U'))
DROP TABLE [dbo].[BatteryHistory]
GO
/****** Object:  Table [dbo].[TaskResultType]    Script Date: 04/14/2014 15:41:17 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskResultType]') AND type in (N'U'))
DROP TABLE [dbo].[TaskResultType]
GO
/****** Object:  Table [dbo].[TaskType]    Script Date: 04/14/2014 15:41:17 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskType]') AND type in (N'U'))
DROP TABLE [dbo].[TaskType]
GO
/****** Object:  Table [dbo].[BatteryType]    Script Date: 04/14/2014 15:41:17 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryType]') AND type in (N'U'))
DROP TABLE [dbo].[BatteryType]
GO

/****** Object:  StoredProcedure [dbo].[ActiveBatteryReport]    Script Date: 08/03/2012 15:12:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ActiveBatteryReport]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ActiveBatteryReport]
GO

/****** Object:  StoredProcedure [dbo].[RadioHistoryDeleteCommand]    Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioHistoryDeleteCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioHistoryDeleteCommand]
GO
/****** Object:  StoredProcedure [dbo].[RadioHistoryUpdateCommand]    Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioHistoryUpdateCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioHistoryUpdateCommand]
GO
/****** Object:  StoredProcedure [dbo].[RadioHistoryInsertCommand]    Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioHistoryInsertCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioHistoryInsertCommand]
GO
/****** Object:  StoredProcedure [dbo].[RadioHistorySelectCommand]    Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioHistorySelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioHistorySelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[RadioHistorySelectByRadioID]    Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioHistorySelectByRadioID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioHistorySelectByRadioID]
GO
/****** Object:  StoredProcedure [dbo].[RadioHistorySelectByBatterySerialNumber]    Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioHistorySelectByBatterySerialNumber]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioHistorySelectByBatterySerialNumber]
GO
/****** Object:  Table [dbo].[RadioHistory]    Script Date: 04/14/2014 15:42:47 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioHistory]') AND type in (N'U'))
DROP TABLE [dbo].[RadioHistory]
GO
/****** Object:  StoredProcedure [dbo].[TaskVerifyResponeTimer]    Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskVerifyResponeTimer]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[TaskVerifyResponeTimer]
GO
/****** Object:  StoredProcedure [dbo].[TaskVerifyResponseTimer]    Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskVerifyResponseTimer]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[TaskVerifyResponseTimer]
GO
/****** Object:  StoredProcedure [dbo].[TaskSelectReadRequest]    Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskSelectReadRequest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[TaskSelectReadRequest]
GO
/****** Object:  StoredProcedure [dbo].[TaskSelectByRequestID]    Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskSelectByRequestID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[TaskSelectByRequestID]
GO
/****** Object:  StoredProcedure [dbo].[TaskSelectByRadioID]    Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskSelectByRadioID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[TaskSelectByRadioID]
GO
/****** Object:  StoredProcedure [dbo].[TaskDeleteCommand]    Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskDeleteCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[TaskDeleteCommand]
GO
/****** Object:  StoredProcedure [dbo].[TaskUpdateCommand]    Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskUpdateCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[TaskUpdateCommand]
GO
/****** Object:  StoredProcedure [dbo].[TaskInsertCommand]    Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskInsertCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[TaskInsertCommand]
GO
/****** Object:  StoredProcedure [dbo].[TaskSelectCommand]    Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[TaskSelectCommand]
GO
/****** Object:  Table [dbo].[Task]    Script Date: 04/14/2014 15:41:51 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Task]') AND type in (N'U'))
DROP TABLE [dbo].[Task]
GO
/****** Object:  StoredProcedure [dbo].[RadioSelectByRadioID]    Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioSelectByRadioID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioSelectByRadioID]
GO
/****** Object:  StoredProcedure [dbo].[RadioSelectRHOTByRadioID]    Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioSelectRHOTByRadioID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioSelectRHOTByRadioID]
GO
/****** Object:  StoredProcedure [dbo].[RadioDeleteCommand]    Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioDeleteCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioDeleteCommand]
GO
/****** Object:  StoredProcedure [dbo].[RadioUpdateCommand]    Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioUpdateCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioUpdateCommand]
GO
/****** Object:  StoredProcedure [dbo].[RadioInsertCommand]    Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioInsertCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioInsertCommand]
GO
/****** Object:  StoredProcedure [dbo].[RadioSelectCommand]    Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[RadioDeregistrationBySerialNumber]  Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioDeregistrationBySerialNumber]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioDeregistrationBySerialNumber]
GO
/****** Object:  StoredProcedure [dbo].[RadioSelectRadioIDChanged]  Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioSelectRadioIDChanged]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].RadioSelectRadioIDChanged
GO
/****** Object:  StoredProcedure [dbo].[RadioRemoveDuplicateRecord]  Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioRemoveDuplicateRecord]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioRemoveDuplicateRecord]
GO
/****** Object:  StoredProcedure [dbo].[RadioHistoryByRadioIP]  Script Date: 05/22/2014 17:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioHistoryByRadioIP]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RadioHistoryByRadioIP]
GO
/****** Object:  StoredProcedure [dbo].[FilterDeleteCommand]    Script Date: 9/10/2024 10:26:16 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FilterDeleteCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[FilterDeleteCommand]
GO
/****** Object:  StoredProcedure [dbo].[FilterInsertCommand]    Script Date: 9/10/2024 10:26:16 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FilterInsertCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[FilterInsertCommand]
GO
/****** Object:  StoredProcedure [dbo].[FilterSelectCommand]    Script Date: 9/10/2024 10:26:16 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FilterSelectCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[FilterSelectCommand]
GO
/****** Object:  StoredProcedure [dbo].[FilterUpdateCommand]    Script Date: 9/10/2024 10:26:16 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FilterUpdateCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[FilterUpdateCommand]
GO
/****** Object:  Table [dbo].[Radio]    Script Date: 04/14/2014 15:42:18 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Radio]') AND type in (N'U'))
DROP TABLE [dbo].[Radio]
GO
/****** Object:  Default [DF_Radio_NeedToRead]    Script Date: 04/14/2014 15:42:18 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Radio_NeedToRead]') AND parent_object_id = OBJECT_ID(N'[dbo].[Radio]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Radio_NeedToRead]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Radio] DROP CONSTRAINT [DF_Radio_NeedToRead]
End

End
GO
/****** Object:  Default [DF_Radio_ManualReadRequest]    Script Date: 04/14/2014 15:42:18 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Radio_ManualReadRequest]') AND parent_object_id = OBJECT_ID(N'[dbo].[Radio]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Radio_ManualReadRequest]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Radio] DROP CONSTRAINT [DF_Radio_ManualReadRequest]
END

End
GO
/****** Object:  Default [DF_Radio_DuplicateID]    Script Date: 04/14/2014 15:42:18 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Radio_DuplicateID]') AND parent_object_id = OBJECT_ID(N'[dbo].[Radio]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Radio_DuplicateID]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Radio] DROP CONSTRAINT [DF_Radio_DuplicateID]
END

End
GO

/****** Object:  Default [DF_AlertInfoTable_AlertId]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_AlertInfoTable_AlertId]') AND parent_object_id = OBJECT_ID(N'[dbo].[AlertInfo]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_AlertInfoTable_AlertId]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[AlertInfo] DROP CONSTRAINT [DF_AlertInfoTable_AlertId]
END


End
GO
/****** Object:  Default [DF_Battery1_CompanyId]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CompanyId]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CompanyId]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CompanyId]
END


End
GO
/****** Object:  Default [DF_Battery1_Alias]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_Alias]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_Alias]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_Alias]
END


End
GO
/****** Object:  Default [DF_Battery1_KITn]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_KITn]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_KITn]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_KITn]
END


End
GO
/****** Object:  Default [DF_Battery1_CHEM]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CHEM]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CHEM]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CHEM]
END


End
GO
/****** Object:  Default [DF_Battery1_BatteryStatusTypeId]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_BatteryStatusTypeId]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_BatteryStatusTypeId]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_BatteryStatusTypeId]
END


End
GO
/****** Object:  Default [DF_Battery1_BatteryGroupId]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_BatteryGroupId]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_BatteryGroupId]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_BatteryGroupId]
END


End
GO
/****** Object:  Default [DF_Battery1_BatteryChargeStateId]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_BatteryChargeStateId]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_BatteryChargeStateId]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_BatteryChargeStateId]
END


End
GO
/****** Object:  Default [DF_Battery1_RadioFamilyId]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_RadioFamilyId]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_RadioFamilyId]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_RadioFamilyId]
END


End
GO
/****** Object:  Default [DF_Battery1_CurrentCharge]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CurrentCharge]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CurrentCharge]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CurrentCharge]
END


End
GO
/****** Object:  Default [DF_Battery1_PotentialCapacity]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_PotentialCapacity]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_PotentialCapacity]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_PotentialCapacity]
END


End
GO
/****** Object:  Default [DF_Battery1_RatedCapacity]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_RatedCapacity]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_RatedCapacity]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_RatedCapacity]
END


End
GO
/****** Object:  Default [DF_Battery1_CapacityRatio]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CapacityRatio]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CapacityRatio]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CapacityRatio]
END


End
GO
/****** Object:  Default [DF_Battery_RemainingCapacityRatio]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_RemainingCapacityRatio]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_RemainingCapacityRatio]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_RemainingCapacityRatio]
END


End
GO
/****** Object:  Default [DF_Table_1_DOM]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Table_1_DOM]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Table_1_DOM]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Table_1_DOM]
END


End
GO
/****** Object:  Default [DF_Battery1_AgeInDays]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_AgeInDays]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_AgeInDays]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_AgeInDays]
END


End
GO
/****** Object:  Default [DF_Battery1_DateOfInitialUse]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_DateOfInitialUse]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_DateOfInitialUse]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_DateOfInitialUse]
END


End
GO
/****** Object:  Default [DF_Battery1_DaysSinceLastReconditioning]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_DaysSinceLastReconditioning]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_DaysSinceLastReconditioning]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_DaysSinceLastReconditioning]
END


End
GO
/****** Object:  Default [DF_Battery1_DaysSinceRemovalFromCharger]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_DaysSinceRemovalFromCharger]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_DaysSinceRemovalFromCharger]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_DaysSinceRemovalFromCharger]
END


End
GO
/****** Object:  Default [DF_Battery1_TotalIMPRESChargeCycles]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_TotalIMPRESChargeCycles]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_TotalIMPRESChargeCycles]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_TotalIMPRESChargeCycles]
END


End
GO
/****** Object:  Default [DF_Battery1_TotalEstimatedNonIMPRESChargeCycles]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_TotalEstimatedNonIMPRESChargeCycles]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_TotalEstimatedNonIMPRESChargeCycles]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_TotalEstimatedNonIMPRESChargeCycles]
END


End
GO
/****** Object:  Default [DF_Battery1_TotalEstimatedNonIMPRESChargeCyclesPrior]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_TotalEstimatedNonIMPRESChargeCyclesPrior]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_TotalEstimatedNonIMPRESChargeCyclesPrior]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_TotalEstimatedNonIMPRESChargeCyclesPrior]
END


End
GO
/****** Object:  Default [DF_Battery1_TotalReconditioningCycles]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_TotalReconditioningCycles]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_TotalReconditioningCycles]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_TotalReconditioningCycles]
END


End
GO
/****** Object:  Default [DF_Battery1_SoftwareVersion]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_SoftwareVersion]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_SoftwareVersion]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_SoftwareVersion]
END


End
GO
/****** Object:  Default [DF_Battery1_TemperatureC]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_TemperatureC]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_TemperatureC]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_TemperatureC]
END


End
GO
/****** Object:  Default [DF_Battery1_Voltage]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_Voltage]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_Voltage]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_Voltage]
END


End
GO
/****** Object:  Default [DF_Battery1_LED]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_LED]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_LED]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_LED]
END


End
GO
/****** Object:  Default [DF_Battery1_DateOfRead]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_DateOfRead]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_DateOfRead]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_DateOfRead]
END


End
GO
/****** Object:  Default [DF_Battery_RichTextRecommendations]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_RichTextRecommendations]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_RichTextRecommendations]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_RichTextRecommendations]
END


End
GO
/****** Object:  Default [DF_Battery1_CA00]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CA00]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CA00]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CA00]
END


End
GO
/****** Object:  Default [DF_Battery1_CA10]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CA10]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CA10]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CA10]
END


End
GO
/****** Object:  Default [DF_Battery1_CA20]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CA20]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CA20]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CA20]
END


End
GO
/****** Object:  Default [DF_Battery1_CA30]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CA30]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CA30]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CA30]
END


End
GO
/****** Object:  Default [DF_Battery1_CA40]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CA40]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CA40]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CA40]
END


End
GO
/****** Object:  Default [DF_Battery1_CA50]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CA50]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CA50]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CA50]
END


End
GO
/****** Object:  Default [DF_Battery1_CA60]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CA60]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CA60]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CA60]
END


End
GO
/****** Object:  Default [DF_Battery1_CA70]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CA70]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CA70]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CA70]
END


End
GO
/****** Object:  Default [DF_Battery1_CA80]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CA80]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CA80]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CA80]
END


End
GO
/****** Object:  Default [DF_Battery1_CA90]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CA90]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CA90]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CA90]
END


End
GO
/****** Object:  Default [DF_Battery1_CR00]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CR00]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CR00]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CR00]
END


End
GO
/****** Object:  Default [DF_Battery1_CR10]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CR10]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CR10]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CR10]
END


End
GO
/****** Object:  Default [DF_Battery1_CR20]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CR20]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CR20]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CR20]
END


End
GO
/****** Object:  Default [DF_Battery1_CR30]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CR30]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CR30]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CR30]
END


End
GO
/****** Object:  Default [DF_Battery1_CR40]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CR40]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CR40]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CR40]
END


End
GO
/****** Object:  Default [DF_Battery1_CR50]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CR50]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CR50]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CR50]
END


End
GO
/****** Object:  Default [DF_Battery1_CR60]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CR60]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CR60]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CR60]
END


End
GO
/****** Object:  Default [DF_Battery1_CR70]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CR70]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CR70]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CR70]
END


End
GO
/****** Object:  Default [DF_Battery1_CR80]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CR80]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CR80]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CR80]
END


End
GO
/****** Object:  Default [DF_Battery1_CR90]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CR90]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CR90]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery1_CR90]
END


End
GO
/****** Object:  Default [DF_Battery_DaysSinceLastRead]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_DaysSinceLastRead]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_DaysSinceLastRead]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_DaysSinceLastRead]
END


End
GO
/****** Object:  Default [DF_Battery_DaysSinceInitialUse]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_DaysSinceInitialUse]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_DaysSinceInitialUse]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_DaysSinceInitialUse]
END


End
GO
/****** Object:  Default [DF_Battery_SNSR]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_SNSR]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_SNSR]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_SNSR]
END


End
GO
/****** Object:  Default [DF_Battery_ICA]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_ICA]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_ICA]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_ICA]
END


End
GO
/****** Object:  Default [DF_Battery_CTS]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_CTS]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_CTS]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_CTS]
END


End
GO
/****** Object:  Default [DF_Battery_DOIU]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_DOIU]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_DOIU]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_DOIU]
END


End
GO
/****** Object:  Default [DF_Battery_WF00]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_WF00]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_WF00]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_WF00]
END


End
GO
/****** Object:  Default [DF_Battery_WF10]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_WF10]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_WF10]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_WF10]
END


End
GO
/****** Object:  Default [DF_Battery_WF20]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_WF20]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_WF20]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_WF20]
END


End
GO
/****** Object:  Default [DF_Battery_WF30]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_WF30]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_WF30]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_WF30]
END


End
GO
/****** Object:  Default [DF_Battery_WF40]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_WF40]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_WF40]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_WF40]
END


End
GO
/****** Object:  Default [DF_Battery_WF50]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_WF50]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_WF50]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_WF50]
END


End
GO
/****** Object:  Default [DF_Battery_WF60]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_WF60]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_WF60]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_WF60]
END


End
GO
/****** Object:  Default [DF_Battery_WF70]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_WF70]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_WF70]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_WF70]
END


End
GO
/****** Object:  Default [DF_Battery_WF80]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_WF80]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_WF80]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_WF80]
END


End
GO
/****** Object:  Default [DF_Battery_WF90]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_WF90]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_WF90]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_WF90]
END


End
GO
/****** Object:  Default [DF_Battery_ETM]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_ETM]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_ETM]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_ETM]
END


End
GO
/****** Object:  Default [DF_Battery_LDAY]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_LDAY]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_LDAY]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_LDAY]
END


End
GO
/****** Object:  Default [DF_Battery_LHR]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_LHR]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_LHR]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_LHR]
END


End
GO
/****** Object:  Default [DF_Battery_LMIN]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_LMIN]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_LMIN]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_LMIN]
END


End
GO
/****** Object:  Default [DF_Battery_FDDp]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_FDDp]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_FDDp]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_FDDp]
END


End
GO
/****** Object:  Default [DF_Battery_DISp]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_DISp]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_DISp]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_DISp]
END


End
GO
/****** Object:  Default [DF_Battery_TRIG]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_TRIG]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_TRIG]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_TRIG]
END


End
GO
/****** Object:  Default [DF_Battery_DOIC]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_DOIC]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_DOIC]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_DOIC]
END


End
GO
/****** Object:  Default [DF_Battery_ALERTID]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_ALERTID]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_ALERTID]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_ALERTID]
END


End
GO
/****** Object:  Default [DF_Battery_NeedToRead]    Script Date: 04/14/2014 15:48:39 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_NeedToRead]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_NeedToRead]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] DROP CONSTRAINT [DF_Battery_NeedToRead]
End

End
GO
/****** Object:  Default [DF_Company_Name]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Company_Name]') AND parent_object_id = OBJECT_ID(N'[dbo].[Company]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Company_Name]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Company] DROP CONSTRAINT [DF_Company_Name]
END


End
GO
/****** Object:  Default [DF_Company_EOSLCapacityPercent]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Company_EOSLCapacityPercent]') AND parent_object_id = OBJECT_ID(N'[dbo].[Company]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Company_EOSLCapacityPercent]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Company] DROP CONSTRAINT [DF_Company_EOSLCapacityPercent]
END


End
GO
/****** Object:  Default [DF_Company_EOSLAgeInDays]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Company_EOSLAgeInDays]') AND parent_object_id = OBJECT_ID(N'[dbo].[Company]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Company_EOSLAgeInDays]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Company] DROP CONSTRAINT [DF_Company_EOSLAgeInDays]
END


End
GO
/****** Object:  Default [DF_Company_MissingDaysThreshold]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Company_MissingDaysThreshold]') AND parent_object_id = OBJECT_ID(N'[dbo].[Company]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Company_MissingDaysThreshold]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Company] DROP CONSTRAINT [DF_Company_MissingDaysThreshold]
END


End
GO
/****** Object:  Default [DF_Company_OverdueThreshold]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Company_OverdueThreshold]') AND parent_object_id = OBJECT_ID(N'[dbo].[Company]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Company_OverdueThreshold]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Company] DROP CONSTRAINT [DF_Company_OverdueThreshold]
END


End
GO
/****** Object:  Default [DF_Company_PurgeThreshold]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Company_PurgeThreshold]') AND parent_object_id = OBJECT_ID(N'[dbo].[Company]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Company_PurgeThreshold]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Company] DROP CONSTRAINT [DF_Company_PurgeThreshold]
END



End
GO

/****** Object:  Default [DF_Company_OTAThreshold]    Script Date: 04/14/2014 15:18:07 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Company_OTAThreshold]') AND parent_object_id = OBJECT_ID(N'[dbo].[Company]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Company_OTAThreshold]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Company] DROP CONSTRAINT [DF_Company_OTAThreshold]
END

End
GO
/****** Object:  Default [DF_Company_RHOT]    Script Date: 04/14/2014 15:18:07 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Company_RHOT]') AND parent_object_id = OBJECT_ID(N'[dbo].[Company]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Company_RHOT]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Company] DROP CONSTRAINT [DF_Company_RHOT]
End

End
GO
/****** Object:  Default [DF_Company_HistoryPurgeThreshold]    Script Date: 04/14/2014 15:18:07 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Company_HistoryPurgeThreshold]') AND parent_object_id = OBJECT_ID(N'[dbo].[Company]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Company_HistoryPurgeThreshold]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Company] DROP CONSTRAINT [DF_Company_HistoryPurgeThreshold]
End

End
GO
/****** Object:  Default [DF_Company_RadioMissingDaysThreshold]    Script Date: 04/14/2014 15:18:07 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Company_RadioMissingDaysThreshold]') AND parent_object_id = OBJECT_ID(N'[dbo].[Company]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Company_RadioMissingDaysThreshold]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Company] DROP CONSTRAINT [DF_Company_RadioMissingDaysThreshold]
End

End
GO
/****** Object:  Default [DF_Device_IsConnected]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Device_IsConnected]') AND parent_object_id = OBJECT_ID(N'[dbo].[Device]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Device_IsConnected]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Device] DROP CONSTRAINT [DF_Device_IsConnected]
END


End
GO
/****** Object:  Default [DF_Device_NumberOfPockets]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Device_NumberOfPockets]') AND parent_object_id = OBJECT_ID(N'[dbo].[Device]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Device_NumberOfPockets]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Device] DROP CONSTRAINT [DF_Device_NumberOfPockets]
END


End
GO
/****** Object:  Default [DF_Location_IsConnected]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Location_IsConnected]') AND parent_object_id = OBJECT_ID(N'[dbo].[Location]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Location_IsConnected]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Location] DROP CONSTRAINT [DF_Location_IsConnected]
END


End
GO
/****** Object:  Default [DF_View_IsShowParaDialog]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_View_IsShowParaDialog]') AND parent_object_id = OBJECT_ID(N'[dbo].[View]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_View_IsShowParaDialog]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[View] DROP CONSTRAINT [DF_View_IsShowParaDialog]
END


End
GO
/****** Object:  Default [DF_View_IsUseRowfilter]    Script Date: 08/03/2012 15:12:53 ******/
IF  EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_View_IsUseRowfilter]') AND parent_object_id = OBJECT_ID(N'[dbo].[View]'))
Begin
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_View_IsUseRowfilter]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[View] DROP CONSTRAINT [DF_View_IsUseRowfilter]
END


End
GO
/****** Object:  Role [fleet]    Script Date: 08/03/2012 15:12:54 ******/
DECLARE @RoleName sysname
set @RoleName = N'fleet'
IF  EXISTS (SELECT * FROM sys.database_principals WHERE name = @RoleName AND type = 'R')
Begin
	DECLARE @RoleMemberName sysname
	DECLARE Member_Cursor CURSOR FOR
	select [name]
	from dbo.sysusers 
	where uid in ( 
		select member_principal_id 
		from sys.database_role_members 
		where role_principal_id in (
			select principal_id
			FROM sys.database_principals where [name] = @RoleName  AND type = 'R' ))

	OPEN Member_Cursor;

	FETCH NEXT FROM Member_Cursor
	into @RoleMemberName

	WHILE @@FETCH_STATUS = 0
	BEGIN

		exec sp_droprolemember @rolename=@RoleName, @membername= @RoleMemberName

		FETCH NEXT FROM Member_Cursor
		into @RoleMemberName
	END;

	CLOSE Member_Cursor;
	DEALLOCATE Member_Cursor;
End
GO
IF  EXISTS (SELECT * FROM sys.database_principals WHERE name = N'fleet' AND type = 'R')
DROP ROLE [fleet]
GO
/****** Object:  Role [fleetmgt]    Script Date: 08/03/2012 15:12:54 ******/
DECLARE @RoleName sysname
set @RoleName = N'fleetmgt'
IF  EXISTS (SELECT * FROM sys.database_principals WHERE name = @RoleName AND type = 'R')
Begin
	DECLARE @RoleMemberName sysname
	DECLARE Member_Cursor CURSOR FOR
	select [name]
	from dbo.sysusers 
	where uid in ( 
		select member_principal_id 
		from sys.database_role_members 
		where role_principal_id in (
			select principal_id
			FROM sys.database_principals where [name] = @RoleName  AND type = 'R' ))

	OPEN Member_Cursor;

	FETCH NEXT FROM Member_Cursor
	into @RoleMemberName

	WHILE @@FETCH_STATUS = 0
	BEGIN

		exec sp_droprolemember @rolename=@RoleName, @membername= @RoleMemberName

		FETCH NEXT FROM Member_Cursor
		into @RoleMemberName
	END;

	CLOSE Member_Cursor;
	DEALLOCATE Member_Cursor;
End
GO
IF  EXISTS (SELECT * FROM sys.database_principals WHERE name = N'fleetmgt' AND type = 'R')
DROP ROLE [fleetmgt]
GO
/****** Object:  Role [fleet]    Script Date: 08/03/2012 15:12:54 ******/
IF NOT EXISTS (SELECT * FROM sys.database_principals WHERE name = N'fleet')
BEGIN
IF NOT EXISTS (SELECT * FROM sys.database_principals WHERE name = N'fleet' AND type = 'R')
CREATE ROLE [fleet] AUTHORIZATION [dbo]

END
GO
/****** Object:  Role [fleetmgt]    Script Date: 08/03/2012 15:12:54 ******/
IF NOT EXISTS (SELECT * FROM sys.database_principals WHERE name = N'fleetmgt')
BEGIN
IF NOT EXISTS (SELECT * FROM sys.database_principals WHERE name = N'fleetmgt' AND type = 'R')
CREATE ROLE [fleetmgt] AUTHORIZATION [dbo]

END
GO
/****** Object:  StoredProcedure [dbo].[ActiveBatteryReport]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ActiveBatteryReport]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[ActiveBatteryReport] 
	-- Add the parameters for the stored procedure here
	@parameter nvarchar(max),
    @rowstart int,
    @rowcount int
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	exec(''Select Top(''+@rowcount+'') * from Battery where serialnumber not in (select top(''+@rowstart+'') serialnumber from battery where BatteryStatusTypeId<>0) and BatteryStatusTypeId<>0'')
END
' 
END
GO
/****** Object:  Table [dbo].[BatteryHistory]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[BatteryHistory](
	[BatteryHistoryId] [int] IDENTITY(1,1) NOT NULL,
	[SerialNumber] [varchar](50) COLLATE database_default NULL,
	[DateOfRead] [datetime] NULL,
	[CapacityRatio] [int] NULL,
	[ComputerName] [nvarchar](max) COLLATE database_default NULL,
	[DeviceName] [nvarchar](max) COLLATE database_default NULL,
	[PocketNumber] [int] NULL
)
END
GO
/****** Object:  StoredProcedure [dbo].[DeviceLogInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceLogInsertCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[DeviceLogInsertCommand]
(
	@LocationName varchar(250),
	@DeviceName varchar(250),
	@BatterySerialNumber varchar(50),
	@IsConnected bit,
	@PocketNumber int,
	@ConnectDateTime datetime,
	@DisconnectDateTime datetime
)
AS
	SET NOCOUNT OFF;
INSERT INTO [devicelog] ([LocationName], [DeviceName], [BatterySerialNumber], [IsConnected], [PocketNumber], [ConnectDateTime], [DisconnectDateTime]) VALUES (@LocationName, @DeviceName, @BatterySerialNumber, @IsConnected, @PocketNumber, @ConnectDateTime, @DisconnectDateTime);
	
SELECT DeviceLogId, LocationName, DeviceName, BatterySerialNumber, IsConnected, PocketNumber, ConnectDateTime, DisconnectDateTime FROM DeviceLog WHERE (DeviceLogId = SCOPE_IDENTITY())
' 
END
GO
/****** Object:  Table [dbo].[AlertInfo]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AlertInfo]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[AlertInfo](
	[AlertId] [int] NOT NULL,
	[Name] [nvarchar](50) COLLATE database_default NULL,
 CONSTRAINT [PK_AlertInfoTable] PRIMARY KEY CLUSTERED 
(
	[AlertId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
INSERT [dbo].[AlertInfo] ([AlertId], [Name]) VALUES (0, N'Off')
INSERT [dbo].[AlertInfo] ([AlertId], [Name]) VALUES (1, N'On')
/****** Object:  StoredProcedure [dbo].[DeviceBatteryLogSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceBatteryLogSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[DeviceBatteryLogSelectCommand]
AS
	SET NOCOUNT ON;
select * from DeviceBatteryLog
' 
END
GO
/****** Object:  StoredProcedure [dbo].[DeviceBatteryLogInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceBatteryLogInsertCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[DeviceBatteryLogInsertCommand]
(
	@DeviceId int,
	@BattrySerialNumber varchar(50),
	@DateTimeOfBatteryRead datetime
)
AS
	SET NOCOUNT OFF;
INSERT INTO [DeviceBatteryLog] ([DeviceId], [BattrySerialNumber], [DateTimeOfBatteryRead]) VALUES (@DeviceId, @BattrySerialNumber, @DateTimeOfBatteryRead);
	
SELECT DeviceBatteryLogId, DeviceId, BattrySerialNumber, DateTimeOfBatteryRead FROM DeviceBatteryLog WHERE (DeviceBatteryLogId = SCOPE_IDENTITY())
' 
END
GO
/****** Object:  Table [dbo].[Computer]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Computer]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[Computer](
	[ComputerId] [int] IDENTITY(1,1) NOT NULL,
	[ComputerName] [varchar](250) COLLATE database_default NULL,
	[DisplayName] [varchar](250) COLLATE database_default NULL,
	[IsConnected] [bit] NULL,
	[DateOfLastHeartbeat] [datetime] NULL,
 CONSTRAINT [PK_Computer] PRIMARY KEY CLUSTERED 
(
	[ComputerId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
/****** Object:  StoredProcedure [dbo].[DeviceBatteryLogDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceBatteryLogDeleteCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[DeviceBatteryLogDeleteCommand]
(
	@Original_DeviceBatteryLogId int,
	@IsNull_DeviceId Int,
	@Original_DeviceId int,
	@IsNull_BattrySerialNumber Int,
	@Original_BattrySerialNumber varchar(50),
	@Original_DateTimeOfBatteryRead datetime
)
AS
	SET NOCOUNT OFF;
DELETE FROM [DeviceBatteryLog] WHERE (([DeviceBatteryLogId] = @Original_DeviceBatteryLogId) AND ((@IsNull_DeviceId = 1 AND [DeviceId] IS NULL) OR ([DeviceId] = @Original_DeviceId)) AND ((@IsNull_BattrySerialNumber = 1 AND [BattrySerialNumber] IS NULL) OR ([BattrySerialNumber] = @Original_BattrySerialNumber)) AND ([DateTimeOfBatteryRead] = @Original_DateTimeOfBatteryRead))
' 
END
GO
/****** Object:  StoredProcedure [dbo].[DeviceChargeInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceChargeInsertCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[DeviceChargeInsertCommand]
(
	@DeviceId int,
	@SerialNumber varchar(50),
	@DateTimeOfChargeStart datetime,
	@DateTimeOfChargeEnd datetime
)
AS
	SET NOCOUNT OFF;
INSERT INTO [devicecharge] ([DeviceId], [SerialNumber], [DateTimeOfChargeStart], [DateTimeOfChargeEnd]) VALUES (@DeviceId, @SerialNumber, @DateTimeOfChargeStart, @DateTimeOfChargeEnd);
	
SELECT DeviceChargeId, DeviceId, SerialNumber, DateTimeOfChargeStart, DateTimeOfChargeEnd FROM DeviceCharge WHERE (DeviceChargeId = SCOPE_IDENTITY())
' 
END
GO
/****** Object:  Table [dbo].[Company]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Company]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[Company](
	[CompanyId] [int] NOT NULL,
	[Name] [text] COLLATE database_default NULL,
	[EOSLCapacityPercent] [float] NULL,
	[EOSLAgeInDays] [int] NULL,
	[MissingDaysThreshold] [int] NULL,
	[WarrantyDaysThreshold] [int] NULL,
	[OverdueThreshold] [int] NULL,
	[PurgeThreshold] [int] NULL,
	[OTAThreshold] [int] NULL,
	[RHOT] [int] NULL,
	[HistoryPurgeThreshold] [int] NULL,
	[RadioMissingDaysThreshold] [int] NULL,
 CONSTRAINT [PK_Company] PRIMARY KEY CLUSTERED 
(
	[CompanyId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'Company', N'COLUMN',N'Name'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Company name' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Company', @level2type=N'COLUMN',@level2name=N'Name'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'Company', N'COLUMN',N'EOSLCapacityPercent'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The user configurable ratio of battery CurrentCapacity to PotentialCapacity which represents the cut-off percentage at which batteries achieve End of Service Life.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Company', @level2type=N'COLUMN',@level2name=N'EOSLCapacityPercent'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'Company', N'COLUMN',N'EOSLAgeInDays'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The user configurable number of days which when added to the DateOfManufacture represents the cut-off date at which batteries have achieved End of Service Life' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Company', @level2type=N'COLUMN',@level2name=N'EOSLAgeInDays'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'Company', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Company'
GO
INSERT [dbo].[Company] ([CompanyId], [Name], [EOSLCapacityPercent], [EOSLAgeInDays], [MissingDaysThreshold], [WarrantyDaysThreshold], [OverdueThreshold], [PurgeThreshold], [OTAThreshold], [RHOT], [HistoryPurgeThreshold], [RadioMissingDaysThreshold]) VALUES (1, N'Company', 60, 1460, 31, 133, 504, 60, 21, 2, 3, 21)
/****** Object:  Table [dbo].[Location]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Location]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[Location](
	[Name] [varchar](50) COLLATE database_default NOT NULL,
	[IsConnected] [bit] NULL,
 CONSTRAINT [PK_Location_1] PRIMARY KEY CLUSTERED 
(
	[Name] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'Location', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of the location' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Location'
GO
/****** Object:  Table [dbo].[Version]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Version]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[Version](
	[BuildVersion] [nvarchar](15) COLLATE database_default NULL
)
END
GO
INSERT [dbo].[Version] ([BuildVersion]) VALUES (N'4.05')
GO
/****** Object:  Table [dbo].[KitNumAndRadioFamilyReleaseVesion]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[KitNumAndRadioFamilyReleaseVesion]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[KitNumAndRadioFamilyReleaseVesion](
	[ReleaseVersion] [nvarchar](15) COLLATE database_default NULL,
	[DateOfLastCheck] [varchar](255) COLLATE database_default NOT NULL,
)
END
GO
INSERT [dbo].[KitNumAndRadioFamilyReleaseVesion] ([ReleaseVersion], [DateOfLastCheck]) VALUES (N'0.0', N'2025-07-16T12:16:22.182Z')
/****** Object:  Table [dbo].[ViewColumn]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewColumn]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[ViewColumn](
	[ColumnName] [varchar](250) COLLATE database_default NOT NULL,
	[ViewId] [int] NOT NULL,
	[SortOrder] [int] NULL,
 CONSTRAINT [PK_ViewColumn] PRIMARY KEY CLUSTERED 
(
	[ColumnName] ASC,
	[ViewId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO

INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'SerialNumber', 1, 0)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'Alias', 1, 1)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RadioID', 1, 2)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RadioAlias', 1, 3)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'LastKnownRadioID', 1, 4)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'LastKnownRadioAlias', 1, 5)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'BatteryGroupId', 1, 6)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RadioFamilyId', 1, 7)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'KITn', 1, 8)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'CHEM', 1, 9)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'FM', 1, 10)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'TIA4950', 1, 11)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RatedCapacity', 1, 12)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'PotentialCapacity', 1, 13)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'DateOfInitialUse', 1, 14)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'TotalIMPRESChargeCycles', 1, 15)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'TotalEstimatedNonIMPRESChargeCycles', 1, 16)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'DateOfRead', 1, 17)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'UL2504Div2', 1, 18)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'CSA157', 1,19)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'ATEX', 1, 20)

INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'SerialNumber', 2, 0)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'Alias', 2, 1)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RadioID', 2, 2)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RadioAlias', 2, 3)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'LastKnownRadioID', 2, 4)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'LastKnownRadioAlias', 2, 5)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'BatteryGroupId', 2, 6)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RadioFamilyId', 2, 7)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'KITn', 2, 8)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'CHEM', 2, 9)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'FM', 2, 10)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'TIA4950', 2, 11)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RatedCapacity', 2, 12)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'PotentialCapacity', 2, 13)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'DateOfInitialUse', 2, 14)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RecommendationId', 2, 15)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'TotalIMPRESChargeCycles', 2, 16)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'TotalEstimatedNonIMPRESChargeCycles', 2, 17)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'TotalReconditioningCycles', 2, 18)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'AgeInDays', 2, 19)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'CapacityRatio', 2, 20)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'DateOfRead', 2, 21)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'UL2504Div2', 2, 22)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'CSA157', 2, 23)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'ATEX', 2, 24)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RichTextRecommendations', 2, 10000)

INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'SerialNumber', 3, 0)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'KITn', 3, 3)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RadioFamilyId', 3, 4)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'CHEM', 3, 5)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'FM', 3, 6)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'TIA4950', 3, 7)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RatedCapacity', 3, 8)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'PotentialCapacity', 3, 9)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'DateOfInitialUse', 3, 10)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'AgeInDays', 3, 15)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'CapacityRatio', 3, 16)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'UL2504Div2', 3, 17)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'CSA157', 3, 18)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'ATEX', 3, 19)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RichTextRecommendations', 3, 10000)

INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'SerialNumber', 4, 0)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'Alias', 4, 1)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RadioID', 4, 2)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RadioAlias', 4, 3)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'BatteryGroupId', 4, 4)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'KITn', 4, 5)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RadioFamilyId', 4, 6)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'CHEM', 4, 7)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'FM', 4, 8)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'TIA4950', 4, 9)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RatedCapacity', 4, 10)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'PotentialCapacity', 4, 11)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'DateOfInitialUse', 4, 12)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RecommendationId', 4, 13)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'DaysSinceLastRead', 4, 15)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'CapacityRatio', 4, 16)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'DateOfRead', 4, 17)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'UL2504Div2', 4, 18)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'CSA157', 4, 19)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'ATEX', 4, 20)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RichTextRecommendations', 4, 10000)

INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RadioID', 5, 1)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RadioAlias', 5, 2)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'ComputerName', 5, 3)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'DateOfRegistration', 5, 4)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'BatteryTypeID', 5, 5)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'BatterySerialNumber', 5, 6)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'DaysSinceLastRegistration', 5, 7)

INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'SerialNumber', 6, 0)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'Alias', 6, 1)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RadioID', 6, 2)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RadioAlias', 6, 3)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'BatteryGroupId', 6, 4)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'KITn', 6, 5)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RadioFamilyId', 6, 6)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'OverdueHours', 6, 7)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RichTextRecommendations', 6, 10000)

INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RadioID', 7, 1)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RadioAlias', 7, 2)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'DateOfRegistration', 7, 3)

INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'KITn', 8, 1)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RadioFamilyId', 8, 2)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'CHEM', 8, 3)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'FM', 8, 4)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'TIA4950', 8, 5)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RatedCapacity', 8, 6)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'CountOfKITn', 8, 7)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'UL2504Div2', 8, 8)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'CSA157', 8, 9)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'ATEX', 8, 10)

INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'ComputerName', 9, 0)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'ComputerAlias', 9, 1)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'DeviceName', 9, 2)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'DisplayName', 9, 3)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'PocketNumber', 9, 4)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'CountOfUse', 9, 5)

INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'SerialNumber', 10, 0)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'BatteryGroupId', 10, 2)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'KITn', 10, 3)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RadioFamilyId', 10, 4)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'CHEM', 10, 5)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'FM', 10, 6)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'TIA4950', 10, 7)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RatedCapacity', 10, 8)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'PotentialCapacity', 10, 9)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'DateOfInitialUse', 10, 10)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'UL2504Div2', 10, 11)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'CSA157', 10, 12)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'ATEX', 10, 13)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'CapacityRatio', 10, 14)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RichTextRecommendations', 10, 10000)

INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'DeviceName', 11, 0)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'DisplayName', 11, 1)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'ComputerName', 11, 2)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'ComputerAlias', 11, 3)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'DisconnectedTime', 11, 4)

INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'ComputerName', 12, 1)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'BatteryTypeID', 12, 2)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'BatterySerialNumber', 12, 3)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'DateOfRegistration', 12, 4)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'DuplicateID', 12, 5)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RadioIDChanged', 12, 6)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'Proxy', 12, 7)

INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'RadioID', 13, 1)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'ComputerName', 13, 2)
INSERT [dbo].[ViewColumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (N'DateOfRegistration', 13, 3)

/****** Object:  Table [dbo].[RadioFamily]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioFamily]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[RadioFamily](
	[RadioFamilyId] [int] NOT NULL,
	[Name] [varchar](250) COLLATE database_default NULL,
 CONSTRAINT [PK_RadioFamily] PRIMARY KEY CLUSTERED 
(
	[RadioFamilyId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (0, N'Unknown')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (1, N'XTS 3500, 5000')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (2, N'XTS 1500, 2500')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (4, N'Saber')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (5, N'MOTOTRBO Pro Series')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (6, N'HT/GP/PRO Series')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (7, N'APX 5000, 6000, 7000')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (14, N'APX 3000')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (16, N'APX 2000, 4000, MOTOTRBO Pro Series (UL)')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (17, N'APX 2000, 3000, 4000, MOTOTRBO Pro Series (FM)')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (19, N'MOTOTRBO Pro Series (CSA)')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (22, N'MOTOTRBO Pro Series (ATEX)')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (23, N'APX 4000XH (CSA)')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (25, N'APX 6000/XE (UL)')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (26, N'APX 5000, 6000, 7000, 8000')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (28, N'MOTOTRBO Pro Series (UL)')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (29, N'APX 8000/XE (UL)')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (30, N'LEX M20')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (32, N'MTP8000Ex Series (ATEX)')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (33, N'MTP6000 Series')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (34, N'Si500, Si700')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (35, N'ST7000, ST7500, TPG2200')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (36, N'APX 6000/XE, 7000/XE, 8000H/8000HXE (UL)')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (37, N'LEX L11')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (39, N'MXP600')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (40, N'MOTOTRBO ION')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (41, N'MOTOTRBO ION (UL)')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (42, N'APX NEXT')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (43, N'APX NEXT (UL)')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (44, N'APX 2000, 4000')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (45, N'APX 2000, 4000, MOTOTRBO Pro Series')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (46, N'APX 900, 1000i, MOTOTRBO Pro Series (UL)')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (47, N'APX 900, 1000i, MOTOTRBO Pro Series')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (48, N'APX4000XH')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (49, N'MOTOTRBO R7')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (50, N'MOTOTRBO R7 (UL)')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (51, N'APX NEXT XN')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (52, N'APX N30, N50')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (53, N'APX N70')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (54, N'MXP7000')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (56, N'SRX 2200')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (57, N'APX N70 (UL)')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (58, N'APX N30, N50 (UL)')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (59, N'HT/GP/PRO Series (FM)')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (60, N'TPG2200')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (61, N'MOTOTRBO Pro Series (M1)')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (62, N'XTS 1500, 2500 (FM)')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (63, N'XTS 3500, 5000 (FM)')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (64, N'MOTOTRBO R2')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (65, N'MOTOTRBO R7Ex')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (66, N'MOTOTRBO R5')
INSERT [dbo].[RadioFamily] ([RadioFamilyId], [Name]) VALUES (67, N'SVX')

/****** Object:  Table [dbo].[BatteryStatusType]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryStatusType]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[BatteryStatusType](
	[BatteryStatusTypeId] [int] NOT NULL,
	[Name] [nvarchar](max) COLLATE database_default NULL,
 CONSTRAINT [PK_BatteryStatusType] PRIMARY KEY CLUSTERED 
(
	[BatteryStatusTypeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
INSERT [dbo].[BatteryStatusType] ([BatteryStatusTypeId], [Name]) VALUES (0, N'Inactive')
INSERT [dbo].[BatteryStatusType] ([BatteryStatusTypeId], [Name]) VALUES (1, N'Active')
INSERT [dbo].[BatteryStatusType] ([BatteryStatusTypeId], [Name]) VALUES (2, N'Error')
/****** Object:  Table [dbo].[View]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[View]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[View](
	[ViewId] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](max) COLLATE database_default NOT NULL,
	[ViewType] [nvarchar](max) COLLATE database_default NULL,
	[Description] [nvarchar](max) COLLATE database_default NULL,
	[QueryRowFilter] [nvarchar](max) COLLATE database_default NULL,
	[QuerySort] [nvarchar](max) COLLATE database_default NULL,
	[QueryAllowUserToEdit] [bit] NULL,
	[QueryInformation] [nvarchar](max) COLLATE database_default NULL,
	[ThresholdExpress] [nvarchar](max) COLLATE database_default NULL,
	[Statistic] [bit] NULL,
	[ChartYAxisTitle] [nvarchar](max) COLLATE database_default NULL,
	[IsShowParaDialog] [bit] NULL,
	[IsUseRowfilter] [bit] NULL,
	[ParameterName] [nvarchar](max) COLLATE database_default NULL,
 CONSTRAINT [PK_ViewDefinition] PRIMARY KEY CLUSTERED 
(
	[ViewId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
SET IDENTITY_INSERT [dbo].[View] ON
INSERT [dbo].[View] ([ViewId], [Name], [ViewType], [Description], [QueryRowFilter], [QuerySort], [QueryAllowUserToEdit], [QueryInformation], [ThresholdExpress], [Statistic], [ChartYAxisTitle], [IsShowParaDialog], [IsUseRowfilter], [ParameterName]) VALUES (1, N'Active Batteries-Simplified', N'Query', N'All active batteries', N'BatteryStatusTypeId<>0', N'SerialNumber', 0, NULL, NULL, 0, NULL, 0, 1, NULL)
INSERT [dbo].[View] ([ViewId], [Name], [ViewType], [Description], [QueryRowFilter], [QuerySort], [QueryAllowUserToEdit], [QueryInformation], [ThresholdExpress], [Statistic], [ChartYAxisTitle], [IsShowParaDialog], [IsUseRowfilter], [ParameterName]) VALUES (2, N'Active Batteries-Expanded', N'Query', N'All active batteries', N'BatteryStatusTypeId<>0', N'SerialNumber', 0, NULL, NULL, 0, NULL, 0, 1, NULL)
INSERT [dbo].[View] ([ViewId], [Name], [ViewType], [Description], [QueryRowFilter], [QuerySort], [QueryAllowUserToEdit], [QueryInformation], [ThresholdExpress], [Statistic], [ChartYAxisTitle], [IsShowParaDialog], [IsUseRowfilter], [ParameterName]) VALUES (3, N'Battery Service Life', N'Query', N'Report about end of Service life', NULL, N'CapacityRatio', 0, NULL, NULL, 0, NULL, 1, 0, N'EOSL (%)[Health (%)],Age[Age],Both[Both]//EOSLReport')
INSERT [dbo].[View] ([ViewId], [Name], [ViewType], [Description], [QueryRowFilter], [QuerySort], [QueryAllowUserToEdit], [QueryInformation], [ThresholdExpress], [Statistic], [ChartYAxisTitle], [IsShowParaDialog], [IsUseRowfilter], [ParameterName]) VALUES (4, N'Lost Batteries', N'Query', N'All Lost batteries', NULL, N'SerialNumber', 0, NULL, NULL, 0, NULL, 0, 0, N'Lost[Lost]//AllLostBatteries')
INSERT [dbo].[View] ([ViewId], [Name], [ViewType], [Description], [QueryRowFilter], [QuerySort], [QueryAllowUserToEdit], [QueryInformation], [ThresholdExpress], [Statistic], [ChartYAxisTitle], [IsShowParaDialog], [IsUseRowfilter], [ParameterName]) VALUES (5, N'Lost Radios', N'Query', N'All Lost radios', NULL, N'RadioID', 0, NULL, NULL, 0, NULL, 0, 0, N'Lost[Lost]//AllLostRadios')
INSERT [dbo].[View] ([ViewId], [Name], [ViewType], [Description], [QueryRowFilter], [QuerySort], [QueryAllowUserToEdit], [QueryInformation], [ThresholdExpress], [Statistic], [ChartYAxisTitle], [IsShowParaDialog], [IsUseRowfilter], [ParameterName]) VALUES (6, N'Battery Data Refresh Overdue', N'Query', N'All overdue batteries', NULL, N'SerialNumber', 0, NULL, NULL, 1, NULL, 0, 0, N'OverdueHours[OverdueHours]//OverdueBatteries')
INSERT [dbo].[View] ([ViewId], [Name], [ViewType], [Description], [QueryRowFilter], [QuerySort], [QueryAllowUserToEdit], [QueryInformation], [ThresholdExpress], [Statistic], [ChartYAxisTitle], [IsShowParaDialog], [IsUseRowfilter], [ParameterName]) VALUES (7, N'Radios with Non-IMPRES Batteries', N'Query', N'Add some description', NULL, N'RadioID', 0, NULL, NULL, 0, NULL, 0, 0, N'NONIMPRES[NONIMPRES]//AllNonImpres')
INSERT [dbo].[View] ([ViewId], [Name], [ViewType], [Description], [QueryRowFilter], [QuerySort], [QueryAllowUserToEdit], [QueryInformation], [ThresholdExpress], [Statistic], [ChartYAxisTitle], [IsShowParaDialog], [IsUseRowfilter], [ParameterName]) VALUES (8, N'Battery Purchase Recommendations', N'Query', N'Add some description', NULL, N'', 0, NULL, NULL, 1, NULL, 0, 0, N'Purchase[Purchase]//PurchaseReport')
INSERT [dbo].[View] ([ViewId], [Name], [ViewType], [Description], [QueryRowFilter], [QuerySort], [QueryAllowUserToEdit], [QueryInformation], [ThresholdExpress], [Statistic], [ChartYAxisTitle], [IsShowParaDialog], [IsUseRowfilter], [ParameterName]) VALUES (9, N'Pocket Utilization', N'Query', N'Add some description', NULL, N'', 0, NULL, NULL, 1, NULL, 0, 0, N'Month[Month]//PocketUtilizationReport')
INSERT [dbo].[View] ([ViewId], [Name], [ViewType], [Description], [QueryRowFilter], [QuerySort], [QueryAllowUserToEdit], [QueryInformation], [ThresholdExpress], [Statistic], [ChartYAxisTitle], [IsShowParaDialog], [IsUseRowfilter], [ParameterName]) VALUES (10, N'Inactive Batteries', N'Query', N'All inactive batteries', N'BatteryStatusTypeId=0', N'SerialNumber', 0, NULL, NULL, 0, NULL, 0, 1, NULL)
INSERT [dbo].[View] ([ViewId], [Name], [ViewType], [Description], [QueryRowFilter], [QuerySort], [QueryAllowUserToEdit], [QueryInformation], [ThresholdExpress], [Statistic], [ChartYAxisTitle], [IsShowParaDialog], [IsUseRowfilter], [ParameterName]) VALUES (11, N'Disconnected Devices', N'Query', N'All Disconnected Devices', NULL, N'', 0, NULL, NULL, 0, NULL, 0, 0, N'Disconnected[Disconnected]//DisconnectedReport')
INSERT [dbo].[View] ([ViewId], [Name], [ViewType], [Description], [QueryRowFilter], [QuerySort], [QueryAllowUserToEdit], [QueryInformation], [ThresholdExpress], [Statistic], [ChartYAxisTitle], [IsShowParaDialog], [IsUseRowfilter], [ParameterName]) VALUES (12, N'Radio History Report', N'ReportQuery', N'Add some description', NULL, N'RadioID', 0, NULL, NULL, 0, NULL, 0, 1, N'RADIOHISTORY[RADIOHISTORY]//AllRadioHistory')
INSERT [dbo].[View] ([ViewId], [Name], [ViewType], [Description], [QueryRowFilter], [QuerySort], [QueryAllowUserToEdit], [QueryInformation], [ThresholdExpress], [Statistic], [ChartYAxisTitle], [IsShowParaDialog], [IsUseRowfilter], [ParameterName]) VALUES (13, N'Battery History Report', N'ReportQuery', N'Add some description', NULL, N'BatterySerialNumber', 0, NULL, NULL, 0, NULL, 0, 1, N'BATTERYHISTORY[BATTERYHISTORY]//AllBatteryHistory')
SET IDENTITY_INSERT [dbo].[View] OFF
/****** Object:  Table [dbo].[RecommendationType]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RecommendationType]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[RecommendationType](
	[RecommendationId] [int] NOT NULL,
	[Text] [nvarchar](max) COLLATE database_default NULL,
 CONSTRAINT [PK_RecommendationType] PRIMARY KEY CLUSTERED 
(
	[RecommendationId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
INSERT [dbo].[RecommendationType] ([RecommendationId], [Text]) VALUES (0, N'No Recommendations')
INSERT [dbo].[RecommendationType] ([RecommendationId], [Text]) VALUES (1, N'Recondition / Calibrate Battery')
INSERT [dbo].[RecommendationType] ([RecommendationId], [Text]) VALUES (2, N'Cool battery before charging')
INSERT [dbo].[RecommendationType] ([RecommendationId], [Text]) VALUES (3, N'Warm battery before charging')
INSERT [dbo].[RecommendationType] ([RecommendationId], [Text]) VALUES (4, N'Out of Service Life - Health')
INSERT [dbo].[RecommendationType] ([RecommendationId], [Text]) VALUES (5, N'Out of Service Life - Age')
INSERT [dbo].[RecommendationType] ([RecommendationId], [Text]) VALUES (6, N'Lost Battery')
/****** Object:  Table [dbo].[Language]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Language]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[Language](
	[ID] [nvarchar](50) COLLATE database_default NOT NULL,
	[Name] [nvarchar](max) COLLATE database_default NULL,
 CONSTRAINT [PK_Language] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
INSERT [dbo].[Language] ([ID], [Name]) VALUES (N'en-US', N'United States (English)')
/****** Object:  Table [dbo].[BatteryChemistryType]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryChemistryType]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[BatteryChemistryType](
	[ChemistryTypeId] [int] NOT NULL,
	[Name] [nvarchar](max) COLLATE database_default NULL,
 CONSTRAINT [PK_ChemistryType] PRIMARY KEY CLUSTERED 
(
	[ChemistryTypeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
INSERT [dbo].[BatteryChemistryType] ([ChemistryTypeId], [Name]) VALUES (1, N'NiCd')
INSERT [dbo].[BatteryChemistryType] ([ChemistryTypeId], [Name]) VALUES (2, N'NiMH')
INSERT [dbo].[BatteryChemistryType] ([ChemistryTypeId], [Name]) VALUES (3, N'Li-Ion')
INSERT [dbo].[BatteryChemistryType] ([ChemistryTypeId], [Name]) VALUES (4, N'Li-Po')
/****** Object:  Table [dbo].[BatteryLEDStatusType]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryLEDStatusType]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[BatteryLEDStatusType](
	[LEDStatusTypeId] [int] NOT NULL,
	[Name] [nvarchar](max) COLLATE database_default NULL,
 CONSTRAINT [PK_LEDStatusType] PRIMARY KEY CLUSTERED 
(
	[LEDStatusTypeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
INSERT [dbo].[BatteryLEDStatusType] ([LEDStatusTypeId], [Name]) VALUES (0, N'Off')
INSERT [dbo].[BatteryLEDStatusType] ([LEDStatusTypeId], [Name]) VALUES (1, N'Flashing Red')
INSERT [dbo].[BatteryLEDStatusType] ([LEDStatusTypeId], [Name]) VALUES (2, N'Flashing Yellow')
INSERT [dbo].[BatteryLEDStatusType] ([LEDStatusTypeId], [Name]) VALUES (3, N'')
INSERT [dbo].[BatteryLEDStatusType] ([LEDStatusTypeId], [Name]) VALUES (4, N'Steady Green')
INSERT [dbo].[BatteryLEDStatusType] ([LEDStatusTypeId], [Name]) VALUES (8, N'Flashing Green')
INSERT [dbo].[BatteryLEDStatusType] ([LEDStatusTypeId], [Name]) VALUES (16, N'Steady Red')
INSERT [dbo].[BatteryLEDStatusType] ([LEDStatusTypeId], [Name]) VALUES (32, N'Steady Yellow')
INSERT [dbo].[BatteryLEDStatusType] ([LEDStatusTypeId], [Name]) VALUES (64, N'Alternating Red/Green')
INSERT [dbo].[BatteryLEDStatusType] ([LEDStatusTypeId], [Name]) VALUES (128, N'Alternating Yellow/Green')
/****** Object:  Table [dbo].[ColumnInformation]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ColumnInformation]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[ColumnInformation](
	[ColumnName] [nvarchar](max) COLLATE database_default NOT NULL,
	[DataType] [varchar](50) COLLATE database_default NULL,
	[HeaderText] [nvarchar](max) COLLATE database_default NULL,
	[Description] [nvarchar](max) COLLATE database_default NULL,
	[GridColumnType] [varchar](50) COLLATE database_default NULL,
	[GridWidth] [int] NULL,
	[GridComboBoxDataSource] [varchar](50) COLLATE database_default NULL,
	[GridComboBoxDisplayMember] [varchar](50) COLLATE database_default NULL,
	[GridComboBoxValueMember] [varchar](50) COLLATE database_default NULL,
	[ChartPietSliceColor] [int] NULL
)
END
GO
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'AgeInDays', N'System.Int32', N'Age (Days)', N'Age (Days)', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'Alias', N'System.String', N'Battery Alias', N'Battery Alias', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'BatteryGroupId', N'System.Int32', N'User Group', N'User Group', N'DataGridViewComboBoxColumn', 0, N'BatteryGroup', N'GroupName', N'BatteryGroupId', NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'BatteryStatusTypeId', N'System.Int32', N'Status', N'Status', N'DataGridViewComboBoxColumn', 0, N'BatteryStatusType', N'Name', N'BatteryStatusTypeId', NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'CapacityRatio', N'System.Int32', N'Health (%)', N'Health (%)', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'CHEM', N'System.Int32', N'Chemistry', N'Chemistry', N'DataGridViewComboBoxColumn', 0, N'BatteryChemistryType', N'Name', N'ChemistryTypeId', NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'Comment', N'System.String', N'Comments', N'Comments', N'DataGridViewTextBoxColumn', 150, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'ComputerName', N'System.String', N'Computer Name', N'Computer Name', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'CountOfKITn', N'System.Int32', N'Quantity', N'Quantity', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'CountOfUse', N'System.Int32', N'Number of Insertions', N'Number of Insertions', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'CurrentCharge', N'System.Int32', N'Present Charge (mAh)', N'Present Charge (mAh)', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'DateOfManufacture', N'System.DateTime', N'Manufacture Date', N'Manufacture Date', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'DateOfRead', N'System.DateTime', N'Date of Last Read', N'Date of 
Last Read', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'DaysSinceLastRead', N'System.Int32', N'Days since Last Read', N'Days since 
Last Read', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'DeviceName', N'System.String', N'Device Name', N'Device Name', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'FM', N'System.Boolean', N'FM', N'FM', N'DataGridCheckBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'TIA4950', N'System.Boolean', N'TIA4950', N'TIA4950', N'DataGridCheckBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'KITn', N'System.String', N'Kit Number', N'Kit Number', N'DataGridViewComboBoxColumn', 0, N'RadioFamilyKitNumber', N'KITn', N'KITnId', NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'LED', N'System.Int32', N'LED', N'LED', N'DataGridViewComboBoxColumn', 0, N'BatteryLEDStatusType', N'Name', N'LEDStatusTypeId', NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'PocketNumber', N'System.Int32', N'Pocket Number', N'Pocket Number', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'UL2504Div2', N'System.Boolean', N'UL2504Div2', N'UL2504Div2', N'DataGridCheckBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'CSA157', N'System.Boolean', N'CSA157', N'CSA157', N'DataGridCheckBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'ATEX', N'System.Boolean', N'ATEX', N'ATEX', N'DataGridCheckBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'PotentialCapacity', N'System.Double', N'Potential Capacity (mAh)', N'Potential
Capacity
(mAh)', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'RadioFamilyDescription', N'System.String', N'Radio Family Description', N'Radio Family Description', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'RadioFamilyId', N'System.Int32', N'Radio Family', N'Radio Family', N'DataGridViewComboBoxColumn', 150, N'RadioFamily', N'Name', N'RadioFamilyId', NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'RatedCapacity', N'System.Int32', N'Rated Capacity (mAh)', N'Rated
Capacity
(mAh)', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'SerialNumber', N'System.String', N'Battery Serial Number ', N'Battery
Serial Number', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'TotalEstimatedNonIMPRESChargeCycles', N'System.Int32', N'Total Estimated Non-IMPRES Charge Cycles', N'Total Estimated
Non-IMPRES
Charge Cycles', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'TotalIMPRESChargeCycles', N'System.Int32', N'Total IMPRES Charge Cycles', N'Total IMPRES 
Charge Cycles', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'DateOfInitialUse', N'System.DateTime', N'Date of First Use', N'Date of 
First Use', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'TotalReconditioningCycles', N'System.Int32', N'Total Reconditioning/Calibration Cycles', N'Total Reconditioning/
Calibration Cycles', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'OverdueHours', N'System.Int32', N'Battery Data Refresh Overdue Days', N'Battery
Data Refresh
Overdue Days', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'OverdueThreshold', N'System.Int32', N'Battery Data Refresh Overdue (Days)', N'Battery
Data Refresh
Overdue (Days)', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) 
VALUES (N'LastKnownRadioAlias', N'System.String', N'Last Known Radio Alias', N'Last Known
Radio Alias', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'Charging', N'System.Boolean', N'Charging', N'Charging', N'DataGridCheckBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'RichTextRecommendations', N'System.String', N'Recommendations', N'Recommendations', N'DataGridViewTextBoxColumn', 0, N'RecommendationType', N'Text', N'RecommendationId', NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'DisconnectedTime', N'System.DateTime', N'Disconnected Time', N'Disconnected Time', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'DisplayName', N'System.String', N'Device Alias', N'Device Alias', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'ComputerAlias', N'System.String', N'Computer Alias', N'Computer Alias', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'DateOfLastRemove', N'System.DateTime', N'Date of Last Remove', N'Date of Last Remove', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'RecommendationId', N'System.String', N'Recommendations', N'Recommendations', N'DataGridViewTextBoxColumn', 0, N'RecommendationType', N'Text', N'RecommendationId', NULL)

INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) 
VALUES (N'RadioIP', N'System.String', N'Radio IP', N'Radio IP', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) 
VALUES (N'RadioID', N'System.String', N'Current Radio ID', N'Current
Radio ID', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) 
VALUES (N'RadioAlias', N'System.String', N'Current Radio Alias', N'Current
Radio Alias', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) 
VALUES (N'LastKnownRadioPresentity', N'System.String', N'Last Known Radio Presentity', N'Last Known Radio Presentity', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) 
VALUES (N'LastKnownRadioID', N'System.String', N'Last Known Radio ID', N'Last Known
Radio ID', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) 
VALUES (N'BatteryTypeID', N'System.Int32', N'Battery Type', N'Battery Type', N'DataGridViewComboBoxColumn', 0, N'BatteryType', N'Name', N'BatteryTypeId', NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) 
VALUES (N'BatterySerialNumber', N'System.String', N'Battery Serial Number', N'Battery
Serial Number', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) 
VALUES (N'TaskID', N'System.Int32', N'Task ID', N'Task ID', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) 
VALUES (N'DateOfRegistration', N'System.DateTime', N'Date of Registration', N'Date of Registration', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) 
VALUES (N'NeedToRead', N'System.Boolean', N'Need To Read', N'Need To Read', N'DataGridCheckBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) 
VALUES (N'ManualReadRequest', N'System.Boolean', N'Manual Read Request', N'Manual Read Request', N'DataGridCheckBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) 
VALUES (N'RHOT', N'System.Int32', N'RHOT', N'Random Holdoff Timer', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) 
VALUES (N'DuplicateID', N'System.Boolean', N'Duplicate Radio ID', N'Duplicate Radio ID', N'DataGridCheckBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) 
VALUES (N'RadioIDChanged', N'System.String', N'Previous Radio ID', N'Previous Radio ID', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)

INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) 
VALUES (N'RequestID', N'System.Int32', N'Request ID', N'RequestID', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) 
VALUES (N'TaskTypeID', N'System.Int32', N'Task Type', N'Task Type', N'DataGridViewComboBoxColumn', 0, N'TaskType', N'Name', N'TaskTypeId', NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) 
VALUES (N'TaskResultTypeID', N'System.Int32', N'Task Result', N'Task Result', N'DataGridViewComboBoxColumn', 0, N'TaskResultType', N'Name', N'TaskResultTypeId', NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) 
VALUES (N'TaskDateTime', N'System.DateTime', N'Date of Task', N'Date of Task', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) 
VALUES (N'ResponseDateTime', N'System.DateTime', N'Date of Task Response', N'Date of Task Response', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'DaysSinceLastRegistration', N'System.Int32', N'Days since Last Registration', N'Days since 
Last Registration', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) 
VALUES (N'RemainingCapacityRatio', N'System.Int32', N'Remaining Capacity (%)', N'Remaining
Capacity (%)', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)
INSERT [dbo].[ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (N'Proxy', N'System.String', N'Proxy', N'Proxy', N'DataGridViewTextBoxColumn', 0, NULL, NULL, NULL, NULL)

/****** Object:  Table [dbo].[ThresholdExpress]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ThresholdExpress]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[ThresholdExpress](
	[ViewId] [int] NOT NULL,
	[ParameterName] [varchar](50) COLLATE database_default NOT NULL,
	[Threshold] [nvarchar](max) COLLATE database_default NULL,
	[Expression] [nvarchar](max) COLLATE database_default NOT NULL,
 CONSTRAINT [PK_ThresholdExpress] PRIMARY KEY CLUSTERED 
(
	[ViewId] ASC,
	[ParameterName] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
INSERT [dbo].[ThresholdExpress] ([ViewId], [ParameterName], [Threshold], [Expression]) VALUES (3, N'Age', N'EOSLAgeInDays', N'Service Life Age (Days)')
INSERT [dbo].[ThresholdExpress] ([ViewId], [ParameterName], [Threshold], [Expression]) VALUES (3, N'Both', N'EOSLCapacityPercent||EOSLAgeInDays', N'Service Life Health (%)||Service Life Age (Days)')
INSERT [dbo].[ThresholdExpress] ([ViewId], [ParameterName], [Threshold], [Expression]) VALUES (3, N'EOSL (%)', N'EOSLCapacityPercent', N'Service Life Health (%)')
INSERT [dbo].[ThresholdExpress] ([ViewId], [ParameterName], [Threshold], [Expression]) VALUES (4, N'Lost', N'MissingDaysThreshold', N'Lost Battery (Days)')
/****** Object:  Table [dbo].[BatteryChargeStatusType]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryChargeStatusType]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[BatteryChargeStatusType](
	[ChargeStatusTypeId] [int] NOT NULL,
	[Name] [nvarchar](max) COLLATE database_default NULL,
 CONSTRAINT [PK_ChargeStatusType] PRIMARY KEY CLUSTERED 
(
	[ChargeStatusTypeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
INSERT [dbo].[BatteryChargeStatusType] ([ChargeStatusTypeId], [Name]) VALUES (0, N'Hot')
INSERT [dbo].[BatteryChargeStatusType] ([ChargeStatusTypeId], [Name]) VALUES (1, N'Cold')
INSERT [dbo].[BatteryChargeStatusType] ([ChargeStatusTypeId], [Name]) VALUES (2, N'Low Voltage')
/****** Object:  Table [dbo].[BatteryChargeStateType]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryChargeStateType]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[BatteryChargeStateType](
	[ChargeStateTypeId] [int] NOT NULL,
	[Name] [nvarchar](max) COLLATE database_default NULL,
 CONSTRAINT [PK_ChargeStateType] PRIMARY KEY CLUSTERED 
(
	[ChargeStateTypeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
INSERT [dbo].[BatteryChargeStateType] ([ChargeStateTypeId], [Name]) VALUES (0, N'None')
INSERT [dbo].[BatteryChargeStateType] ([ChargeStateTypeId], [Name]) VALUES (1, N'Battery Temperature Too Hot')
INSERT [dbo].[BatteryChargeStateType] ([ChargeStateTypeId], [Name]) VALUES (2, N'Battery Temperature Too Cold')
INSERT [dbo].[BatteryChargeStateType] ([ChargeStateTypeId], [Name]) VALUES (4, N'Battery Voltage Too Low')
INSERT [dbo].[BatteryChargeStateType] ([ChargeStateTypeId], [Name]) VALUES (8, N'Discharging')
INSERT [dbo].[BatteryChargeStateType] ([ChargeStateTypeId], [Name]) VALUES (16, N'Standby')
INSERT [dbo].[BatteryChargeStateType] ([ChargeStateTypeId], [Name]) VALUES (32, N'Rapid')
INSERT [dbo].[BatteryChargeStateType] ([ChargeStateTypeId], [Name]) VALUES (33, N'Constant Current')
INSERT [dbo].[BatteryChargeStateType] ([ChargeStateTypeId], [Name]) VALUES (64, N'Trickle')
INSERT [dbo].[BatteryChargeStateType] ([ChargeStateTypeId], [Name]) VALUES (65, N'Constant Voltage')
INSERT [dbo].[BatteryChargeStateType] ([ChargeStateTypeId], [Name]) VALUES (128, N'Maintenance')
INSERT [dbo].[BatteryChargeStateType] ([ChargeStateTypeId], [Name]) VALUES (129, N'Completed')
INSERT [dbo].[BatteryChargeStateType] ([ChargeStateTypeId], [Name]) VALUES (600, N'Invalid Status')
INSERT [dbo].[BatteryChargeStateType] ([ChargeStateTypeId], [Name]) VALUES (601, N'Hot ')
INSERT [dbo].[BatteryChargeStateType] ([ChargeStateTypeId], [Name]) VALUES (602, N'Cold')
INSERT [dbo].[BatteryChargeStateType] ([ChargeStateTypeId], [Name]) VALUES (604, N'Low Voltage')
INSERT [dbo].[BatteryChargeStateType] ([ChargeStateTypeId], [Name]) VALUES (605, N'Hot & Low Voltage')
INSERT [dbo].[BatteryChargeStateType] ([ChargeStateTypeId], [Name]) VALUES (606, N'Cold & Low Voltage')
/****** Object:  Table [dbo].[ChartInformation]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ChartInformation]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[ChartInformation](
	[ChartId] [int] IDENTITY(1,1) NOT NULL,
	[ChartName] [nvarchar](max) COLLATE database_default NULL,
	[ChartTitle] [nvarchar](max) COLLATE database_default NULL,
	[ChartType] [nvarchar](max) COLLATE database_default NULL,
	[XColumnTitle] [nvarchar](max) COLLATE database_default NULL,
	[YColumnTitle] [nvarchar](max) COLLATE database_default NULL,
	[XColumnName] [nvarchar](max) COLLATE database_default NULL,
	[YColumnName] [nvarchar](max) COLLATE database_default NULL,
	[BinSize] [int] NULL,
 CONSTRAINT [PK_ChartInformation] PRIMARY KEY CLUSTERED 
(
	[ChartId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
SET IDENTITY_INSERT [dbo].[ChartInformation] ON
INSERT [dbo].[ChartInformation] ([ChartId], [ChartName], [ChartTitle], [ChartType], [XColumnTitle], [YColumnTitle], [XColumnName], [YColumnName], [BinSize]) VALUES (1, N'Age in Days', N'Age in Days', N'Bar', N'Age (Days)', N'Number of Batteries', N'', N'AgeInDays', 365)
INSERT [dbo].[ChartInformation] ([ChartId], [ChartName], [ChartTitle], [ChartType], [XColumnTitle], [YColumnTitle], [XColumnName], [YColumnName], [BinSize]) VALUES (2, N'Pocket Utilization', N'Pocket Utilization', N'Bar', N'Charger Name', N'Number of Insertions', N'', N'', 0)
INSERT [dbo].[ChartInformation] ([ChartId], [ChartName], [ChartTitle], [ChartType], [XColumnTitle], [YColumnTitle], [XColumnName], [YColumnName], [BinSize]) VALUES (3, N'Chemistry', N'Chemistry', N'Pie', N'', N'Number of Batteries', N'', N'CHEM', 1)
INSERT [dbo].[ChartInformation] ([ChartId], [ChartName], [ChartTitle], [ChartType], [XColumnTitle], [YColumnTitle], [XColumnName], [YColumnName], [BinSize]) VALUES (4, N'Health (%)', N'Health (%)', N'Bar', N'Health (%)', N'Number of Batteries', N'', N'CapacityRatio', 10)
INSERT [dbo].[ChartInformation] ([ChartId], [ChartName], [ChartTitle], [ChartType], [XColumnTitle], [YColumnTitle], [XColumnName], [YColumnName], [BinSize]) VALUES (5, N'Radio Family', N'Radio Family', N'Bar', N'', N'Number of Batteries', N'', N'RadioFamilyId', 1)
INSERT [dbo].[ChartInformation] ([ChartId], [ChartName], [ChartTitle], [ChartType], [XColumnTitle], [YColumnTitle], [XColumnName], [YColumnName], [BinSize]) VALUES (6, N'Chemistry by Recommendations', N'Chemistry by Recommendations', N'AdvancedBar', N'Recommendations', N'Number of Batteries', N'RecommendationId', N'CHEM', 1)
INSERT [dbo].[ChartInformation] ([ChartId], [ChartName], [ChartTitle], [ChartType], [XColumnTitle], [YColumnTitle], [XColumnName], [YColumnName], [BinSize]) VALUES (7, N'Chemistry by Health (%)', N'Chemistry by Health (%)', N'AdvancedBar', N'Health (%)', N'Number of Batteries', N'CapacityRatio', N'CHEM', 10)
INSERT [dbo].[ChartInformation] ([ChartId], [ChartName], [ChartTitle], [ChartType], [XColumnTitle], [YColumnTitle], [XColumnName], [YColumnName], [BinSize]) VALUES (8, N'Radio Family by Age (Days)', N'Radio Family by Age (Days)', N'AdvancedBar', N'Age (Days)', N'Number of Batteries', N'AgeInDays', N'RadioFamilyId', 365)
INSERT [dbo].[ChartInformation] ([ChartId], [ChartName], [ChartTitle], [ChartType], [XColumnTitle], [YColumnTitle], [XColumnName], [YColumnName], [BinSize]) VALUES (9, N'Radio Family by Health (%)', N'Radio Family by Health (%)', N'AdvancedBar', N'Health (%)', N'Number of Batteries', N'CapacityRatio', N'RadioFamilyId', 10)
INSERT [dbo].[ChartInformation] ([ChartId], [ChartName], [ChartTitle], [ChartType], [XColumnTitle], [YColumnTitle], [XColumnName], [YColumnName], [BinSize]) VALUES (10, N'Chemistry by Date of Last Read', N'Chemistry by Date of Last Read', N'AdvancedBar', N'Date of Last Read', N'Number of Batteries', N'DateOfRead', N'CHEM', 365)
INSERT [dbo].[ChartInformation] ([ChartId], [ChartName], [ChartTitle], [ChartType], [XColumnTitle], [YColumnTitle], [XColumnName], [YColumnName], [BinSize]) VALUES (11, N'Radio Family by Date of Last Read', N'Radio Family by Date of Last Read', N'AdvancedBar', N'Date of Last Read', N'Number of Batteries', N'DateOfRead', N'RadioFamilyId', 365)
INSERT [dbo].[ChartInformation] ([ChartId], [ChartName], [ChartTitle], [ChartType], [XColumnTitle], [YColumnTitle], [XColumnName], [YColumnName], [BinSize]) VALUES (12, N'Quantity by Kit Number', N'Quantity by Kit Number', N'AdvancedBar', N'Kit Number', N'Number of Batteries', N'KITn', N'CountOfKITn', 1)
INSERT [dbo].[ChartInformation] ([ChartId], [ChartName], [ChartTitle], [ChartType], [XColumnTitle], [YColumnTitle], [XColumnName], [YColumnName], [BinSize]) VALUES (13, N'Count by Pocket', N'Count by Pocket', N'Bar', N'', N'Number of Batteries', N'', N'PocketNumber', 1)
INSERT [dbo].[ChartInformation] ([ChartId], [ChartName], [ChartTitle], [ChartType], [XColumnTitle], [YColumnTitle], [XColumnName], [YColumnName], [BinSize]) VALUES (14, N'Computer', N'Computer', N'Pie', N'', N'Number of Batteries', N'', N'ComputerName', 1)
INSERT [dbo].[ChartInformation] ([ChartId], [ChartName], [ChartTitle], [ChartType], [XColumnTitle], [YColumnTitle], [XColumnName], [YColumnName], [BinSize]) VALUES (15, N'Radio Family', N'Radio Family', N'Pie', N'', N'Number of Batteries', N'', N'RadioFamilyId', 1)
INSERT [dbo].[ChartInformation] ([ChartId], [ChartName], [ChartTitle], [ChartType], [XColumnTitle], [YColumnTitle], [XColumnName], [YColumnName], [BinSize]) VALUES (16, N'Quantity by Kit Number', N'Quantity by Kit Number', N'Pie', N'', N'Number of Batteries', N'', N'KITn', 1)
INSERT [dbo].[ChartInformation] ([ChartId], [ChartName], [ChartTitle], [ChartType], [XColumnTitle], [YColumnTitle], [XColumnName], [YColumnName], [BinSize]) VALUES (17, N'Kit Number', N'Kit Number', N'Bar', N'Kit Number', N'Number of Batteries', N'', N'KITn', 10)
INSERT [dbo].[ChartInformation] ([ChartId], [ChartName], [ChartTitle], [ChartType], [XColumnTitle], [YColumnTitle], [XColumnName], [YColumnName], [BinSize]) VALUES (18, N'Kit Number by Days Since Last Read', N'Kit Number by Days Since Last Read', N'AdvancedBar', N'Days Since Last Read', N'Number of Batteries', N'DaysSinceLastRead', N'KITn', 10)
INSERT [dbo].[ChartInformation] ([ChartId], [ChartName], [ChartTitle], [ChartType], [XColumnTitle], [YColumnTitle], [XColumnName], [YColumnName], [BinSize]) VALUES (19, N'Radio Family by Days Since Last Read', N'Radio Family by Days Since Last Read', N'AdvancedBar', N'Days Since Last Read', N'Number of Batteries', N'DaysSinceLastRead', N'RadioFamilyId', 10)
SET IDENTITY_INSERT [dbo].[ChartInformation] OFF
/****** Object:  Table [dbo].[Translation]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Translation]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[Translation](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[English] [nvarchar](max) COLLATE database_default NULL,
	[Value] [nvarchar](max) COLLATE database_default NULL,
	[Language] [nvarchar](max) COLLATE database_default NULL,
 CONSTRAINT [PK_Translation] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
SET IDENTITY_INSERT [dbo].[Translation] ON
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (1, N'Active', N'es_Active', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (2, N'Inactive', N'es_Inactive', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (3, N'None', N'es_None', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (4, N'Battery temperature too hot', N'es_Battery temperature too hot', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (5, N'Battery temperature too cold', N'es_Battery temperature too cold', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (6, N'Battery voltage too low', N'es_Battery voltage too low', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (7, N'Discharging', N'es_Discharging', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (8, N'Waiting to charge (Standby)', N'es_Waiting to charge (Standby)', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (9, N'Rapid', N'es_Rapid', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (10, N'Trickle', N'es_Trickle', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (11, N'Maintenance', N'es_Maintenance', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (12, N'Hot', N'es_Hot', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (13, N'Cold', N'es_Cold', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (14, N'Low Voltage', N'es_Low Voltage', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (15, N'NiCd', N'es_NiCd', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (16, N'NiMH', N'es_NiMh', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (17, N'Li-Ion', N'es_LiIon', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (18, N'LiPoly', N'es_LiPoly', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (19, N'Off', N'es_Off', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (20, N'Flashing Red', N'es_Flashing Red', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (21, N'Flashing Yellow', N'es_Flashing Yellow', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (22, N'Steady Green', N'es_Steady Green', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (23, N'Flashing Green', N'es_Flashing Green', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (24, N'Steady Red', N'es_Steady Red', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (25, N'Steady Yellow', N'es_Steady Yellow', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (26, N'Alternating Red Green', N'es_Alternating Red Green', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (27, N'Alternating Yellow Green', N'es_Alternating Yellow Green', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (28, N'Age (days)', N'es_Age (days)', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (29, N'Alias', N'es_Alias', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (30, N'Group', N'es_Group', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (31, N'Status', N'es_Status', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (32, N'Capacity (%)', N'es_Capacity (%)', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (33, N'Chemistry', N'es_Chemistry', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (34, N'Computer Name', N'es_Computer Name', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (35, N'Count Of Kit Number', N'es_Count Of Kit Number', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (36, N'Count Of Use', N'es_Count Of Use', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (37, N'Current Charge', N'es_Current Charge', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (38, N'Manufacture Date', N'es_Manufacture Date', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (39, N'Date Of Read', N'es_Date Of Read', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (40, N'Device Name', N'es_Device Name', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (41, N'FM', N'es_FM', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (42, N'Kit Number', N'es_Kit Number', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (43, N'LED', N'es_LED', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (44, N'Pocket Number', N'es_Pocket Number', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (45, N'Potential Capacity', N'es_Potential Capacity', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (46, N'Radio Family Description', N'es_Radio Family Description', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (47, N'Rated Capacity', N'es_Rated Capacity', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (48, N'Recommendations', N'es_Recommendations', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (49, N'RichText', N'es_RichText', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (50, N'Serial Number', N'es_Serial Number', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (51, N'Active Batteries', N'es_Active Batteries', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (52, N'End of Service Life', N'es_End of Service Life', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (53, N'Inactive Batteries', N'es_Inactive Batteries', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (54, N'Lost Batteries', N'es_Lost Batteries', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (55, N'Warranty Batteries', N'es_Warranty Batteries', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (56, N'Purchase', N'es_Purchase', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (57, N'Pocket Utilization', N'es_Pocket Utilization', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (58, N'EOSL (%)[Health (%)],Age[Age],Both[Both]//EOSLReport', N'EOSL (%)[es_EOSL (%)],Age[es_Age],Both[en_Both]//EOSLReport', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (59, N'Month[Month]//PocketUtilizationReport', N'Month[es_Month]//PocketUtilizationReport', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (60, N'RadioFamilyDescription', N'es_RadioFamilyDescription', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (61, N'Recondition / Calibrate Battery', N'es_Recondition / Recalibrate Battery', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (62, N'Update Charger Software', N'es_Update Charger Software', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (63, N'Recondition / Recalibrate Battery
Update Charger Software', N'es_Recondition / Recalibrate Battery
Update Charger Software', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (64, N'No Recommondation', N'es_No Recommondation', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (65, N'Error', N'es_Error', N'es-ES')
INSERT [dbo].[Translation] ([Id], [English], [Value], [Language]) VALUES (66, N'Off', N'es_Off', N'es-ES')
SET IDENTITY_INSERT [dbo].[Translation] OFF
/****** Object:  Table [dbo].[ViewChart]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewChart]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[ViewChart](
	[ViewChartId] [int] IDENTITY(1,1) NOT NULL,
	[ViewId] [int] NULL,
	[ChartId] [int] NULL,
	[Parameter] [nvarchar](max) COLLATE database_default NULL,
	[FriendlyText] [nvarchar](max) COLLATE database_default NULL,
 CONSTRAINT [PK_ViewChart] PRIMARY KEY CLUSTERED 
(
	[ViewChartId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
SET IDENTITY_INSERT [dbo].[ViewChart] ON
INSERT [dbo].[ViewChart] ([ViewChartId], [ViewId], [ChartId], [Parameter], [FriendlyText]) VALUES (1, 2, 1, N'', N'Shows all batteries grouped by Age (Days)')
INSERT [dbo].[ViewChart] ([ViewChartId], [ViewId], [ChartId], [Parameter], [FriendlyText]) VALUES (2, 9, 2, N'', N'Shows the number of battery insertions by device and pocket over the last 60 days')
INSERT [dbo].[ViewChart] ([ViewChartId], [ViewId], [ChartId], [Parameter], [FriendlyText]) VALUES (3, 3, 1, N'Age', N'Shows batteries nearing End of Service Life grouped by Age (Days)')
INSERT [dbo].[ViewChart] ([ViewChartId], [ViewId], [ChartId], [Parameter], [FriendlyText]) VALUES (4, 2, 4, N'', N'Shows all batteries grouped by Health (%)')
INSERT [dbo].[ViewChart] ([ViewChartId], [ViewId], [ChartId], [Parameter], [FriendlyText]) VALUES (5, 2, 15, N'', N'Shows all batteries grouped by Radio Family')
INSERT [dbo].[ViewChart] ([ViewChartId], [ViewId], [ChartId], [Parameter], [FriendlyText]) VALUES (7, 3, 7, N'EOSL (%)', N'Shows batteries nearing End of Service Life by Chemistry, grouped by Health (%)')
INSERT [dbo].[ViewChart] ([ViewChartId], [ViewId], [ChartId], [Parameter], [FriendlyText]) VALUES (8, 4, 18, N'', N'Shows lost batteries by Kit Number, grouped by Days Since Last Read')
INSERT [dbo].[ViewChart] ([ViewChartId], [ViewId], [ChartId], [Parameter], [FriendlyText]) VALUES (9, 4, 19, N'', N'Shows lost batteries by Radio Family, grouped by Days Since Last Read')
INSERT [dbo].[ViewChart] ([ViewChartId], [ViewId], [ChartId], [Parameter], [FriendlyText]) VALUES (15, 8, 16, N'', N'Shows batteries to be purchased by Kit Number')
INSERT [dbo].[ViewChart] ([ViewChartId], [ViewId], [ChartId], [Parameter], [FriendlyText]) VALUES (17, 9, 14, N'', N'Shows the number of battery insertions by computer')
INSERT [dbo].[ViewChart] ([ViewChartId], [ViewId], [ChartId], [Parameter], [FriendlyText]) VALUES (18, 3, 8, N'Age', N'Shows batteries nearing End of Service Life by Radio Family, grouped by Age (Days)')
INSERT [dbo].[ViewChart] ([ViewChartId], [ViewId], [ChartId], [Parameter], [FriendlyText]) VALUES (19, 2, 3, N'', N'Shows all batteries grouped by Chemistry')
INSERT [dbo].[ViewChart] ([ViewChartId], [ViewId], [ChartId], [Parameter], [FriendlyText]) VALUES (20, 3, 9, N'EOSL (%)', N'Shows batteries nearing End of Service Life by Radio Family, grouped by Health (%)')
INSERT [dbo].[ViewChart] ([ViewChartId], [ViewId], [ChartId], [Parameter], [FriendlyText]) VALUES (21, 2, 17, N'', N'Shows all batteries grouped by Kit Number')
SET IDENTITY_INSERT [dbo].[ViewChart] OFF
/****** Object:  StoredProcedure [dbo].[OverdueBatteries]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[OverdueBatteries]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[OverdueBatteries] 

  @parameter nvarchar(max),
  @rowcount int,
  @rowstart int

AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    
    -- Insert statements for procedure here
	exec (''SELECT top ( ''+ @rowcount+'') SerialNumber, CompanyId, Alias,RadioID=IsNull(RadioID,''''''''), RadioAlias=IsNull(RadioAlias,''''''''), KITn, CHEM, BatteryStatusTypeId, BatteryGroupId, BatteryChargeStateId, RadioFamilyId, CurrentCharge, 
                      PotentialCapacity, RatedCapacity, CapacityRatio, DateOfManufacture,AgeInDays, DateOfInitialUse, DaysSinceLastReconditioning, 
                      DaysSinceRemovalFromCharger, TotalIMPRESChargeCycles, TotalEstimatedNonIMPRESChargeCycles, TotalEstimatedNonIMPRESChargeCyclesPrior, 
                      TotalReconditioningCycles, EstimatedDaysUntilNextReconditioning, SoftwareVersion, TemperatureC, Voltage, LED, Battery.DateOfRead, RecommendationId, RichTextRecommendations,
                      CA00, CA10, CA20, CA30, CA40, CA50, CA60, CA70, CA80, CA90, RE00, RE10, RE20, RE30, RE40, RE50, RE60, RE70, RE80, RE90, Battery.ComputerName, 
                      Battery.DeviceName, PocketNumber, DATEDIFF(d, Battery.DateOfRead, CURRENT_TIMESTAMP) as DaysSinceLastRead, DaysSinceInitialUse, SNSR, ICA, CTS, DOIU, WF00, WF10, WF20, WF30, WF40, WF50, WF60, 
                      WF70, WF80, WF90, ETM, LDAY, LHR, LMIN, FDDp, DISp, TRIG, DOIC, FM, Comment, ChargerHighTemperature, ChargerLowTemperature, HID, ALERTID, UnsupportedFieldsList,ErrorFieldsList, DateofLastRemove, DATEDIFF(mi, Battery.DateOfRead, CURRENT_TIMESTAMP)/(60*24) as OverdueHours 
                      from Battery 
                      LEFT OUTER JOIN radio ON Battery.serialnumber=radio.batteryserialnumber
                      where serialnumber not in (select top ( ''+@rowstart+'') serialnumber from battery where Year(Battery.DateOfRead)<>1970 and DATEDIFF(mi, Battery.DateOfRead, CURRENT_TIMESTAMP)/60>=dbo.GetOverdueThreshold(OverdueThreshold,CompanyId) and  BatteryStatusTypeId <> 0 order by SerialNumber) and Year(Battery.DateOfRead)<>1970 and DATEDIFF(mi, Battery.DateOfRead, CURRENT_TIMESTAMP)/60>=dbo.GetOverdueThreshold(OverdueThreshold,CompanyId) and  BatteryStatusTypeId <> 0 order by SerialNumber'')
END
' 
END
GO
/****** Object:  UserDefinedFunction [dbo].[CreateRecommendation]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CreateRecommendation]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date, ,>
-- Description:	<Description, ,>
-- =============================================
CREATE FUNCTION [dbo].[CreateRecommendation] 
(
	-- Add the parameters for the function here
	@DaysSinceLastReconditioning int,
    @TRIG int,
    @TemperatureC float,
    @ChargerLowTemperature float,
    @ChargerHighTemperature float
)
RETURNS nvarchar(max)
AS
BEGIN
	-- Declare the return variable here
    DECLARE @Recommendation nvarchar(max)
    set @Recommendation=''0''
    Begin
    if(@DaysSinceLastReconditioning>30 or @TRIG<=0)
      set @Recommendation=''1''
    if(@TemperatureC>@ChargerHighTemperature)
      Begin
      if(@Recommendation=''0'')
      set @Recommendation=''2''
      else
      set @Recommendation=@Recommendation+''+2''
      End
    if(@TemperatureC<@ChargerLowTemperature)
      Begin
      if(@Recommendation=''0'')
       set @Recommendation=''3''
      else
       set @Recommendation=@Recommendation+''+3''
      End
    end
	RETURN @Recommendation
--Declare @Recommendation int
--    set @Recommendation=0
--    if(@DaysSinceLastReconditioning>30 or @TRIG<=0)
--      set @Recommendation=1
--    if(@TemperatureC>@ChargerHighTemperature)
--      
--      set @Recommendation=@Recommendation+@Recommendation*10
--      
--    if(@TemperatureC<@ChargerLowTemperature)
--      
--      set @Recommendation=@Recommendation+@Recommendation*100
--      
--    
--    RETURN @Recommendation
END
' 
END
GO
/****** Object:  StoredProcedure [dbo].[DeviceBatteryLogUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceBatteryLogUpdateCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[DeviceBatteryLogUpdateCommand]
(
	@DeviceId int,
	@BattrySerialNumber varchar(50),
	@DateTimeOfBatteryRead datetime,
	@Original_DeviceBatteryLogId int,
	@IsNull_DeviceId Int,
	@Original_DeviceId int,
	@IsNull_BattrySerialNumber Int,
	@Original_BattrySerialNumber varchar(50),
	@Original_DateTimeOfBatteryRead datetime,
	@DeviceBatteryLogId int
)
AS
	SET NOCOUNT OFF;
UPDATE [DeviceBatteryLog] SET [DeviceId] = @DeviceId, [BattrySerialNumber] = @BattrySerialNumber, [DateTimeOfBatteryRead] = @DateTimeOfBatteryRead WHERE (([DeviceBatteryLogId] = @Original_DeviceBatteryLogId) AND ((@IsNull_DeviceId = 1 AND [DeviceId] IS NULL) OR ([DeviceId] = @Original_DeviceId)) AND ((@IsNull_BattrySerialNumber = 1 AND [BattrySerialNumber] IS NULL) OR ([BattrySerialNumber] = @Original_BattrySerialNumber)) AND ([DateTimeOfBatteryRead] = @Original_DateTimeOfBatteryRead));
	
SELECT DeviceBatteryLogId, DeviceId, BattrySerialNumber, DateTimeOfBatteryRead FROM DeviceBatteryLog WHERE (DeviceBatteryLogId = @DeviceBatteryLogId)
' 
END
GO
/****** Object:  StoredProcedure [dbo].[DeviceLogDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceLogDeleteCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[DeviceLogDeleteCommand]
(
	@Original_DeviceLogId int,
	@Original_LocationName varchar(250),
	@Original_DeviceName varchar(250),
	@Original_BatterySerialNumber varchar(50),
	@IsNull_IsConnected Int,
	@Original_IsConnected bit,
	@IsNull_PocketNumber Int,
	@Original_PocketNumber int,
	@IsNull_ConnectDateTime Int,
	@Original_ConnectDateTime datetime,
	@IsNull_DisconnectDateTime Int,
	@Original_DisconnectDateTime datetime
)
AS
	SET NOCOUNT OFF;
DELETE FROM [devicelog] WHERE (([DeviceLogId] = @Original_DeviceLogId) AND ([LocationName] = @Original_LocationName) AND ([DeviceName] = @Original_DeviceName) AND ([BatterySerialNumber] = @Original_BatterySerialNumber) AND ((@IsNull_IsConnected = 1 AND [IsConnected] IS NULL) OR ([IsConnected] = @Original_IsConnected)) AND ((@IsNull_PocketNumber = 1 AND [PocketNumber] IS NULL) OR ([PocketNumber] = @Original_PocketNumber)) AND ((@IsNull_ConnectDateTime = 1 AND [ConnectDateTime] IS NULL) OR ([ConnectDateTime] = @Original_ConnectDateTime)) AND ((@IsNull_DisconnectDateTime = 1 AND [DisconnectDateTime] IS NULL) OR ([DisconnectDateTime] = @Original_DisconnectDateTime)))
' 
END
GO
/****** Object:  StoredProcedure [dbo].[AllLostBatteries]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AllLostBatteries]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[AllLostBatteries]
	-- Add the parameters for the stored procedure here
	@parameter nvarchar(max),
    @rowcount int,
    @rowstart int
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	
  exec (''
   select top ( ''+ @rowcount+'')  SerialNumber, CompanyId, Alias, KITn, CHEM, BatteryStatusTypeId, BatteryGroupId, BatteryChargeStateId, RadioFamilyId, CurrentCharge, 
                      PotentialCapacity, RatedCapacity, CapacityRatio, DateOfManufacture,DATEDIFF(d, DateofinitialUse, CURRENT_TIMESTAMP) as AgeInDays, DateOfInitialUse, DaysSinceLastReconditioning, 
                      DaysSinceRemovalFromCharger, TotalIMPRESChargeCycles, TotalEstimatedNonIMPRESChargeCycles, TotalEstimatedNonIMPRESChargeCyclesPrior, 
                      TotalReconditioningCycles, EstimatedDaysUntilNextReconditioning, SoftwareVersion, TemperatureC, Voltage, LED, battery.DateOfRead, RecommendationId,RichTextRecommendations, 
                      CA00, CA10, CA20, CA30, CA40, CA50, CA60, CA70, CA80, CA90, RE00, RE10, RE20, RE30, RE40, RE50, RE60, RE70, RE80, RE90, battery.ComputerName, 
                      Battery.DeviceName, PocketNumber, DATEDIFF(d, battery.DateOfRead, CURRENT_TIMESTAMP) as DaysSinceLastRead, DaysSinceInitialUse, SNSR, ICA, CTS, DOIU, WF00, WF10, WF20, WF30, WF40, WF50, WF60, 
                      WF70, WF80, WF90, ETM, LDAY, LHR, LMIN, FDDp, DISp, TRIG, DOIC, FM
                      , RadioID=IsNull(radio.RadioID,''''''''), RadioAlias=IsNull(radio.RadioAlias,'''''''') 
					  , TIA4950
					  , UL2504Div2
					  , CSA157
					  , ATEX
					  , NFPA
					  , NFPAContinuousOverTemp
					  , NFPACumulativeOverTemp
					  , NFPAOverTempCounter
					  , BatteryTypeID
                      from battery
					  LEFT OUTER JOIN radio ON battery.serialnumber=radio.batteryserialnumber
					  where serialnumber not in
   (select top ( ''+@rowstart+'') serialnumber from battery  where DATEDIFF(d, battery.DateOfRead, CURRENT_TIMESTAMP) > (SELECT MissingDaysThreshold FROM Company WHERE  CompanyId = 1 )  and  BatteryStatusTypeId <> 0 order by serialnumber )
    and DATEDIFF(d, battery.DateOfRead, CURRENT_TIMESTAMP) > (SELECT MissingDaysThreshold FROM Company WHERE  CompanyId = 1 )  and  BatteryStatusTypeId <> 0 order by serialnumber 
'')
END
' 
END
GO
/****** Object:  StoredProcedure [dbo].[AllLostRadios]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AllLostRadios]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[AllLostRadios]
	-- Add the parameters for the stored procedure here
	@parameter nvarchar(max),
    @rowcount int,
    @rowstart int
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	
  exec (''
   select RadioID, RadioAlias, DateOfRegistration, ComputerName, BatteryTypeID, BatterySerialNumber, DATEDIFF(d, DateOfRegistration, CURRENT_TIMESTAMP) as DaysSinceLastRegistration 
   from radio 
   where DATEDIFF(hh, DateOfRegistration, CURRENT_TIMESTAMP) > (SELECT RadioMissingDaysThreshold * 24 FROM Company WHERE  CompanyId = 1 ) 
   order by RadioID

'')
END
' 
END
GO
/****** Object:  StoredProcedure [dbo].[DeviceBatteryLogUpdateCommand]    Script Date: 08/03/2012 18:05:06 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceBatteryLogUpdateCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[DeviceBatteryLogUpdateCommand]
(
	@DeviceId int,
	@BattrySerialNumber varchar(50),
	@DateTimeOfBatteryRead datetime,
	@Original_DeviceBatteryLogId int,
	@IsNull_DeviceId Int,
	@Original_DeviceId int,
	@IsNull_BattrySerialNumber Int,
	@Original_BattrySerialNumber varchar(50),
	@Original_DateTimeOfBatteryRead datetime,
	@DeviceBatteryLogId int
)
AS
	SET NOCOUNT OFF;
UPDATE [DeviceBatteryLog] SET [DeviceId] = @DeviceId, [BattrySerialNumber] = @BattrySerialNumber, [DateTimeOfBatteryRead] = @DateTimeOfBatteryRead WHERE (([DeviceBatteryLogId] = @Original_DeviceBatteryLogId) AND ((@IsNull_DeviceId = 1 AND [DeviceId] IS NULL) OR ([DeviceId] = @Original_DeviceId)) AND ((@IsNull_BattrySerialNumber = 1 AND [BattrySerialNumber] IS NULL) OR ([BattrySerialNumber] = @Original_BattrySerialNumber)) AND ([DateTimeOfBatteryRead] = @Original_DateTimeOfBatteryRead));
	
SELECT DeviceBatteryLogId, DeviceId, BattrySerialNumber, DateTimeOfBatteryRead FROM DeviceBatteryLog WHERE (DeviceBatteryLogId = @DeviceBatteryLogId)
' 
END
GO
/****** Object:  StoredProcedure [dbo].[DeviceLogDeleteCommand]    Script Date: 08/03/2012 18:05:10 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceLogDeleteCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[DeviceLogDeleteCommand]
(
	@Original_DeviceLogId int,
	@Original_LocationName varchar(250),
	@Original_DeviceName varchar(250),
	@Original_BatterySerialNumber varchar(50),
	@IsNull_IsConnected Int,
	@Original_IsConnected bit,
	@IsNull_PocketNumber Int,
	@Original_PocketNumber int,
	@IsNull_ConnectDateTime Int,
	@Original_ConnectDateTime datetime,
	@IsNull_DisconnectDateTime Int,
	@Original_DisconnectDateTime datetime
)
AS
	SET NOCOUNT OFF;
DELETE FROM [devicelog] WHERE (([DeviceLogId] = @Original_DeviceLogId) AND ([LocationName] = @Original_LocationName) AND ([DeviceName] = @Original_DeviceName) AND ([BatterySerialNumber] = @Original_BatterySerialNumber) AND ((@IsNull_IsConnected = 1 AND [IsConnected] IS NULL) OR ([IsConnected] = @Original_IsConnected)) AND ((@IsNull_PocketNumber = 1 AND [PocketNumber] IS NULL) OR ([PocketNumber] = @Original_PocketNumber)) AND ((@IsNull_ConnectDateTime = 1 AND [ConnectDateTime] IS NULL) OR ([ConnectDateTime] = @Original_ConnectDateTime)) AND ((@IsNull_DisconnectDateTime = 1 AND [DisconnectDateTime] IS NULL) OR ([DisconnectDateTime] = @Original_DisconnectDateTime)))
' 
END
GO
/****** Object:  StoredProcedure [dbo].[AllLostBatteries]    Script Date: 08/03/2012 18:04:47 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AllLostBatteries]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[AllLostBatteries]
	-- Add the parameters for the stored procedure here
	@parameter nvarchar(max),
    @rowcount int,
    @rowstart int
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	
  exec (''
   select top ( ''+ @rowcount+'')  SerialNumber, CompanyId, Alias, KITn, CHEM, BatteryStatusTypeId, BatteryGroupId, BatteryChargeStateId, RadioFamilyId, CurrentCharge, 
                      PotentialCapacity, RatedCapacity, CapacityRatio, DateOfManufacture,DATEDIFF(d, DateofinitialUse, CURRENT_TIMESTAMP) as AgeInDays, DateOfInitialUse, DaysSinceLastReconditioning, 
                      DaysSinceRemovalFromCharger, TotalIMPRESChargeCycles, TotalEstimatedNonIMPRESChargeCycles, TotalEstimatedNonIMPRESChargeCyclesPrior, 
                      TotalReconditioningCycles, EstimatedDaysUntilNextReconditioning, SoftwareVersion, TemperatureC, Voltage, LED, battery.DateOfRead, RecommendationId,RichTextRecommendations, 
                      CA00, CA10, CA20, CA30, CA40, CA50, CA60, CA70, CA80, CA90, RE00, RE10, RE20, RE30, RE40, RE50, RE60, RE70, RE80, RE90, battery.ComputerName, 
                      Battery.DeviceName, PocketNumber, DATEDIFF(d, battery.DateOfRead, CURRENT_TIMESTAMP) as DaysSinceLastRead, DaysSinceInitialUse, SNSR, ICA, CTS, DOIU, WF00, WF10, WF20, WF30, WF40, WF50, WF60, 
                      WF70, WF80, WF90, ETM, LDAY, LHR, LMIN, FDDp, DISp, TRIG, DOIC, FM
                      , RadioID=IsNull(radio.RadioID,''''''''), RadioAlias=IsNull(radio.RadioAlias,'''''''') 
					  , TIA4950
					  , UL2504Div2
					  , CSA157
					  , ATEX
					  , NFPA
					  , NFPAContinuousOverTemp
					  , NFPACumulativeOverTemp
					  , NFPAOverTempCounter
					  , BatteryTypeID
                      from battery
					  LEFT OUTER JOIN radio ON battery.serialnumber=radio.batteryserialnumber
					  where serialnumber not in
   (select top ( ''+@rowstart+'') serialnumber from battery  where DATEDIFF(d, battery.DateOfRead, CURRENT_TIMESTAMP) > (SELECT MissingDaysThreshold FROM Company WHERE  CompanyId = 1 )  and  BatteryStatusTypeId <> 0 order by serialnumber )
    and DATEDIFF(d, battery.DateOfRead, CURRENT_TIMESTAMP) > (SELECT MissingDaysThreshold FROM Company WHERE  CompanyId = 1 )  and  BatteryStatusTypeId <> 0 order by serialnumber 
'')
END
' 
END
GO
/****** Object:  StoredProcedure [dbo].[AllLostRadios]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AllLostRadios]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[AllLostRadios]
	-- Add the parameters for the stored procedure here
	@parameter nvarchar(max),
    @rowcount int,
    @rowstart int
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	
  exec (''
   select RadioID, RadioAlias, DateOfRegistration, ComputerName, BatteryTypeID, BatterySerialNumber, DATEDIFF(d, DateOfRegistration, CURRENT_TIMESTAMP) as DaysSinceLastRegistration 
   from radio 
   where DATEDIFF(hh, DateOfRegistration, CURRENT_TIMESTAMP) > (SELECT RadioMissingDaysThreshold * 24 FROM Company WHERE  CompanyId = 1 ) 
   order by RadioID

'')
END
' 
END
GO
/****** Object:  StoredProcedure [dbo].[AllRadioBatteryInformation]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AllRadioBatteryInformation]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[AllRadioBatteryInformation]
	-- Add the parameters for the stored procedure here
	@parameter nvarchar(max), -- WHERE XXXX = XXX ORDER BY YYY
    @rowcount int, -- Record per Page
    @rowstart int, -- Current Page
	@RadioID varchar(50),
	@ComputerName nvarchar(250),
	@BatterySerialNumber nvarchar(50)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @TotalRecordCount int, @TotalPage int, @CurrentSequence int
    SET @CurrentSequence = 1

    -- Insert statements for procedure here
	IF OBJECT_ID(''tempdb..#TEMP_RadioBatteryInformation'') IS NOT NULL
		DROP TABLE #TEMP_RadioBatteryInformation
	    
          
      CREATE TABLE #TEMP_RadioBatteryInformation(
            [RadioID] [varchar](50) COLLATE database_default NULL,
            [RadioAlias] [varchar](250) COLLATE database_default NULL,
            [LastKnownRadioID] [varchar](50) COLLATE database_default NULL,
            [LastKnownRadioAlias] [varchar](250) COLLATE database_default NULL,
            [DateOfRegistration] [datetime] NULL,
            [ComputerName] [varchar](250) COLLATE database_default NULL,
            [Proxy] [varchar](250) COLLATE database_default NULL,
            [ProxyStatus] [bit] NULL,
            [ProxyDisconnectedTime] [datetime] NULL,
            [BatteryTypeID] [int] NULL,
            [SerialNumber] [varchar](50) COLLATE database_default NULL,
            [BatteryAlias] [varchar](50) COLLATE database_default NULL,
            [BatteryStatusTypeid] [int] NULL,
            [DateOfRead] [datetime] NULL,
            [CurrentCharge] [int] NULL,
            [PotentialCapacity] [int] NULL,
            [RatedCapacity] [int] NULL,
            [Health] [int] NULL,
            [HealthLevel] [int] NULL,
            [RadioCapacity] [int] NULL,
            [AgeInDay] [int] NULL,
            [TaskResultType] [int] NULL,
            [BatteryNeedToRead] [bit] NULL,
            [ManualReadRequest] [bit] NULL,
            [DuplicateID] [bit] NULL,
            [RadioIDChanged] [varchar](50) COLLATE database_default NULL,
			[DeviceName] [varchar](250) NOT NULL,
            [Notes] [varchar](50) COLLATE database_default NULL,
            [NotesVisibility] [bit] NULL,
            [RecommendationId] [nvarchar](50) COLLATE database_default NULL,
            [Recommendations] [nvarchar](MAX) COLLATE database_default NULL,
            [QueryType] [int] NULL
      )

      INSERT INTO #TEMP_RadioBatteryInformation
      --1. Radio with IMPRES Battery (Last Read PCR MOTOTRBO OTA and ASTRO UNS IMW)
      ----------------------------------------------
      select radio.RadioID, RadioAlias = ISNULL(radio.RadioAlias, '''')
      , LastKnownRadioID = '''', LastKnownRadioAlias = ''''
      , radio.DateOfRegistration
      , radio.ComputerName
      , Proxy = battery.DeviceName
      , ProxyStatus = ISNULL(Device.IsConnected, 0)
      , ProxyDisconnectedTime = Device.DisconnectedTime
      , BatteryTypeID = ISNULL(radio.BatteryTypeID, 999), battery.SerialNumber, BatteryAlias = ISNULL(battery.Alias,''''), battery.BatteryStatusTypeid, battery.DateOfRead, battery.CurrentCharge, battery.potentialcapacity, battery.RatedCapacity
      , Health = battery.CapacityRatio
      , HealthLevel = CASE WHEN battery.CapacityRatio < 60 THEN 3 ELSE CASE WHEN battery.CapacityRatio >= (SELECT EOSLCapacityPercent FROM COMPANY) THEN 1 ELSE 2 END END
      , RadioCapacity = battery.RemainingCapacityRatio
	  , AgeInDay = battery.AgeInDays 
      , TaskResultType = CASE isnull(radio.taskid, 0) WHEN 0 THEN CASE ManualReadRequest WHEN 1 THEN 101 ELSE null END ELSE CASE  isnull(taskresulttypeID, 999) WHEN 999 THEN 102 ELSE taskresulttypeID END END
      , BatteryNeedToRead = 0
      , ManualReadRequest = ISNULL(radio.ManualReadRequest, 0)
      , radio.DuplicateID, radio.RadioIDChanged, radio.DeviceName
      , Notes = CASE radio.DuplicateID WHEN 1 THEN CASE isnull(radio.RadioIDChanged,'''') WHEN '''' THEN ''Duplicate Radio ID'' ELSE ''Duplicate Radio ID, Previous Radio ID = '' + radio.RadioIDChanged END ELSE CASE isnull(radio.RadioIDChanged,'''') WHEN '''' THEN '''' ELSE ''Previous Radio ID = '' + radio.RadioIDChanged END END
      , NotesVisibility = CASE radio.DuplicateID WHEN 0 THEN CASE isnull(radio.RadioIDChanged,'''') WHEN '''' THEN 0 ELSE 1 END ELSE 1 END
      , RecommendationId = battery.RecommendationId
      , Recommendations = dbo.RecommendationDetails(battery.RecommendationId)
      , QueryType = 1
      FROM radio
      JOIN battery on (radio.batterySerialNumber = battery.SerialNumber) and (battery.DeviceName = ''Motorola IMPRES OTA'' or battery.DeviceName = ''Motorola IMPRES UNS'') and (battery.BatteryStatusTypeId <> 0)
      JOIN Device on (Device.ComputerName = battery.ComputerName) and (Device.DeviceName = battery.DeviceName)
      LEFT OUTER JOIN task ON radio.taskid = task.taskid
      WHERE ISNULL(radio.BatteryTypeID, 999) = 2
      
      UNION
      --2. Radio with Battery (Last Read CIU)
      ----------------------------------------
      select radio.RadioID, RadioAlias = ISNULL(radio.RadioAlias, '''')
      , LastKnownRadioID = '''', LastKnownRadioAlias = ''''
      , radio.DateOfRegistration
      , radio.ComputerName
      , Proxy = battery.DeviceName
      , ProxyStatus = ISNULL(Device.IsConnected, 0)
      , ProxyDisconnectedTime = Device.DisconnectedTime
      , BatteryTypeID = ISNULL(radio.BatteryTypeID, 999), battery.SerialNumber, BatteryAlias = ISNULL(battery.Alias,''''), battery.BatteryStatusTypeid, battery.DateOfRead, battery.CurrentCharge, battery.potentialcapacity, battery.RatedCapacity
      , Health = battery.CapacityRatio
      , HealthLevel = CASE WHEN battery.CapacityRatio < 60 THEN 3 ELSE CASE WHEN battery.CapacityRatio >= (SELECT EOSLCapacityPercent FROM COMPANY) THEN 1 ELSE 2 END END
      , RadioCapacity = battery.RemainingCapacityRatio
	  , AgeInDay = battery.AgeInDays 
      , TaskResultType = CASE WHEN (task.TaskDateTime >= battery.DateOfRead) THEN CASE isnull(radio.taskid, 0) WHEN 0 THEN CASE ManualReadRequest WHEN 1 THEN 101 ELSE null END ELSE CASE  isnull(taskresulttypeID, 999) WHEN 999 THEN 102 ELSE taskresulttypeID END END ELSE CASE isnull(battery.NeedToRead, 0) WHEN 1 THEN 101 ELSE CASE isnull(battery.batteryStatusTypeID, 2) WHEN 2 THEN 1 ELSE 0 END END END 
      , BatteryNeedToRead = 0
      , ManualReadRequest = ISNULL(radio.ManualReadRequest, 0)
      , radio.DuplicateID, radio.RadioIDChanged , radio.DeviceName
      , Notes = CASE radio.DuplicateID WHEN 1 THEN CASE isnull(radio.RadioIDChanged,'''') WHEN '''' THEN ''Duplicate Radio ID'' ELSE ''Duplicate Radio ID, Previous Radio ID = '' + radio.RadioIDChanged END ELSE CASE isnull(radio.RadioIDChanged,'''') WHEN '''' THEN '''' ELSE ''Previous Radio ID = '' + radio.RadioIDChanged END END
      , NotesVisibility = CASE radio.DuplicateID WHEN 0 THEN CASE isnull(radio.RadioIDChanged,'''') WHEN '''' THEN 0 ELSE 1 END ELSE 1 END
      , RecommendationId = battery.RecommendationId
      , Recommendations = dbo.RecommendationDetails(battery.RecommendationId)
      , QueryType = 2
      FROM radio
      JOIN battery on (radio.batterySerialNumber = battery.SerialNumber) and (battery.DeviceName <> ''Motorola IMPRES OTA'') and (battery.DeviceName <> ''Motorola IMPRES UNS'') and (battery.BatteryStatusTypeId <> 0)
      JOIN Device on (Device.ComputerName = battery.ComputerName) and (Device.DeviceName = battery.DeviceName)
      LEFT OUTER JOIN task ON radio.taskid = task.taskid
      WHERE ISNULL(radio.BatteryTypeID, 999) = 2

      UNION
      --3. Radio with Non-IMPRES Battery
      ----------------------------------------
      select radio.RadioID, RadioAlias = ISNULL(radio.RadioAlias, '''')
      , LastKnownRadioID = '''', LastKnownRadioAlias = ''''
      , radio.DateOfRegistration
      , radio.ComputerName
      , Proxy = radio.DeviceName
      , ProxyStatus = ISNULL(Device.IsConnected, 0)
      , ProxyDisconnectedTime = Device.DisconnectedTime
      , BatteryTypeID = ISNULL(radio.BatteryTypeID, 999), radio.BatterySerialNumber, BatteryAlias = '''', BatteryStatusTypeid = null, DateOfRead = null, CurrentCharge = null, potentialcapacity = null, RatedCapacity = null
      , Health = null, HealthLevel = null, RadioCapacity = null
      , AgeInDay = null
      , TaskResultType = CASE isnull(radio.taskid, 0) WHEN 0 THEN CASE ManualReadRequest WHEN 1 THEN 101 ELSE null END ELSE CASE  isnull(taskresulttypeID, 999) WHEN 999 THEN 102 ELSE taskresulttypeID END END
      , BatteryNeedToRead = 0
      , ManualReadRequest = ISNULL(radio.ManualReadRequest, 0)
      , radio.DuplicateID, radio.RadioIDChanged, radio.DeviceName 
      , Notes = CASE radio.DuplicateID WHEN 1 THEN CASE isnull(radio.RadioIDChanged,'''') WHEN '''' THEN ''Duplicate Radio ID'' ELSE ''Duplicate Radio ID, Previous Radio ID = '' + radio.RadioIDChanged END ELSE CASE isnull(radio.RadioIDChanged,'''') WHEN '''' THEN '''' ELSE ''Previous Radio ID = '' + radio.RadioIDChanged END END
      , NotesVisibility = CASE radio.DuplicateID WHEN 0 THEN CASE isnull(radio.RadioIDChanged,'''') WHEN '''' THEN 0 ELSE 1 END ELSE 1 END
      , RecommendationId = ''''
      , Recommendations = ''''
      , QueryType = 3
      FROM radio
      JOIN Device on (radio.ComputerName = Device.ComputerName) and (radio.DeviceName = ''Motorola IMPRES OTA'' or radio.DeviceName = ''Motorola IMPRES UNS'') and (radio.DeviceName = Device.DeviceName)
      LEFT OUTER JOIN task ON radio.taskid = task.taskid
      WHERE ISNULL(radio.BatteryTypeID, 999) <> 2

      UNION
      --4. Battery not attached to Radio (Battery Read from IMPRES 2 Chargers)
      --------------------------------------------------------
      select RadioID = '''', RadioAlias = ''''
      , LastKnownRadioID = '''', LastKnownRadioAlias = ''''
      , DateOfRegistration = NULL
      , battery.ComputerName
      , Proxy = battery.DeviceName
      , ProxyStatus = ISNULL(Device.IsConnected, 0)
      , ProxyDisconnectedTime = Device.DisconnectedTime
      , BatteryTypeID = 2, battery.SerialNumber, BatteryAlias = ISNULL(battery.Alias,''''), battery.BatteryStatusTypeid, battery.DateOfRead, battery.CurrentCharge, battery.potentialcapacity, battery.RatedCapacity
      , Health = battery.CapacityRatio
      , HealthLevel = CASE WHEN battery.CapacityRatio < 60 THEN 3 ELSE CASE WHEN battery.CapacityRatio >= (SELECT EOSLCapacityPercent FROM COMPANY) THEN 1 ELSE 2 END END
      , RadioCapacity = battery.RemainingCapacityRatio
	  , AgeInDay = battery.AgeInDays 
      , TaskResultType = CASE isnull(battery.NeedToRead, 0) WHEN 1 THEN 101 ELSE CASE isnull(battery.batteryStatusTypeID, 2) WHEN 2 THEN 1 ELSE 0 END END 
      , BatteryNeedToRead = ISNULL(battery.NeedToRead, 0)
      , ManualReadRequest = 1
      , DuplicateID = 0, RadioIDChanged  = '''', DeviceName=''''
      , Notes = ''''
      , NotesVisibility = 0
      , RecommendationId = battery.RecommendationId
      , Recommendations = dbo.RecommendationDetails(battery.RecommendationId)
      , QueryType = 4
      FROM battery
      JOIN Device on (battery.ComputerName = Device.ComputerName) and (battery.DeviceName = Device.DeviceName)
      WHERE NOT EXISTS
      (SELECT 1 FROM radio where radio.batterySerialNumber = battery.SerialNumber)
      AND NOT EXISTS
      (SELECT 1 FROM BatteryLastKnownRadio where BatteryLastKnownRadio.BatterySerialNumber = battery.SerialNumber)
      AND battery.BatteryStatusTypeID <>0

	  UNION
      --5. Radio with Battery (Radio is registered but the battery data is not yet read or couldn''be read)
      ----------------------------------------
      select radio.RadioID, RadioAlias = ISNULL(radio.RadioAlias, '''')
      , LastKnownRadioID = '''', LastKnownRadioAlias = ''''
      , radio.DateOfRegistration
      , radio.ComputerName
      , Proxy = Device.DeviceName
      , ProxyStatus = ISNULL(Device.IsConnected, 0)
      , ProxyDisconnectedTime = Device.DisconnectedTime
      , BatteryTypeID = ISNULL(radio.BatteryTypeID, 999), radio.BatterySerialNumber, BatteryAlias = '''', BatteryStatusTypeid = null, DateOfRead = null, CurrentCharge = null, potentialcapacity = null, RatedCapacity = null
      , Health = null, HealthLevel = null, RadioCapacity = null
      , AgeInDay = null
      , TaskResultType = CASE isnull(radio.taskid, 0) WHEN 0 THEN CASE ManualReadRequest WHEN 1 THEN 101 ELSE null END ELSE CASE  isnull(taskresulttypeID, 999) WHEN 999 THEN 102 ELSE taskresulttypeID END END
      , BatteryNeedToRead = 0
      , ManualReadRequest = ISNULL(radio.ManualReadRequest, 0)
      , radio.DuplicateID, radio.RadioIDChanged, radio.DeviceName
      , Notes = CASE radio.DuplicateID WHEN 1 THEN CASE isnull(radio.RadioIDChanged,'''') WHEN '''' THEN ''Duplicate Radio ID'' ELSE ''Duplicate Radio ID, Previous Radio ID = '' + radio.RadioIDChanged END ELSE CASE isnull(radio.RadioIDChanged,'''') WHEN '''' THEN '''' ELSE ''Previous Radio ID = '' + radio.RadioIDChanged END END
      , NotesVisibility = CASE radio.DuplicateID WHEN 0 THEN CASE isnull(radio.RadioIDChanged,'''') WHEN '''' THEN 0 ELSE 1 END ELSE 1 END
      , RecommendationId = ''''
      , Recommendations = ''''
      , QueryType = 5
      FROM radio
      JOIN Device on (Device.ComputerName = radio.ComputerName) and (Device.DeviceName = radio.DeviceName)
      LEFT OUTER JOIN task ON radio.taskid = task.taskid
	  WHERE NOT EXISTS 
		  (SELECT 1 FROM battery WHERE radio.batterySerialNumber = battery.SerialNumber)
		  AND ISNULL(radio.BatteryTypeID, 999) = 2

      UNION
      --6. Battery detached from Radio (contains last known radio information for batteries unplugged from PCR MOTOTRBO OTA and ASTRO UNS IMW)
      --------------------------------------------------------
      select RadioID = '''', RadioAlias = ''''
      , LastKnownRadioID = BatteryLastKnownRadio.RadioID, LastKnownRadioAlias = BatteryLastKnownRadio.RadioAlias
      , DateOfRegistration = BatteryLastKnownRadio.DateOfLastRadioRegistration
      , battery.ComputerName
      , Proxy = battery.DeviceName
      , ProxyStatus = ISNULL(Device.IsConnected, 0)
      , ProxyDisconnectedTime = Device.DisconnectedTime
      , BatteryTypeID = 2, battery.SerialNumber, BatteryAlias = ISNULL(battery.Alias,''''), battery.BatteryStatusTypeid, battery.DateOfRead, battery.CurrentCharge, battery.potentialcapacity, battery.RatedCapacity
      , Health = battery.CapacityRatio
      , HealthLevel = CASE WHEN battery.CapacityRatio < 60 THEN 3 ELSE CASE WHEN battery.CapacityRatio >= (SELECT EOSLCapacityPercent FROM COMPANY) THEN 1 ELSE 2 END END
      , RadioCapacity = battery.RemainingCapacityRatio
      , AgeInDay = battery.AgeInDays 
      , TaskResultType = CASE isnull(battery.NeedToRead, 0) WHEN 1 THEN 101 ELSE CASE isnull(battery.batteryStatusTypeID, 2) WHEN 2 THEN 1 ELSE 0 END END 
      , BatteryNeedToRead = ISNULL(battery.NeedToRead, 0)
      , ManualReadRequest = 1
      , DuplicateID = 0, RadioIDChanged  = '''', DeviceName=''''
      , Notes = ''''
      , NotesVisibility = 0
      , RecommendationId = battery.RecommendationId
      , Recommendations = dbo.RecommendationDetails(battery.RecommendationId)
      , QueryType = 6
      FROM battery
      JOIN Device on (battery.ComputerName = Device.ComputerName) and (battery.DeviceName = Device.DeviceName)
      JOIN BatteryLastKnownRadio on (battery.SerialNumber = BatteryLastKnownRadio.BatterySerialNumber)
      WHERE NOT EXISTS
      (SELECT 1 FROM radio where radio.batterySerialNumber = battery.SerialNumber)
      AND battery.BatteryStatusTypeID <>0

	  UPDATE #TEMP_RadioBatteryInformation
	  SET Recommendations = CASE Recommendations WHEN '''' THEN Recommendations + Notes ELSE CASE Notes WHEN '''' THEN Recommendations + Notes ELSE Recommendations + CHAR(13) + CHAR(10) + Notes END END

	  UPDATE #TEMP_RadioBatteryInformation
	  SET Recommendations = CASE Recommendations WHEN '''' THEN Recommendations + ''Lost Radio'' ELSE Recommendations + CHAR(13) + CHAR(10) + ''Lost Radio'' END
	  WHERE DATEDIFF(d, DateOfRegistration, CURRENT_TIMESTAMP) > (SELECT RadioMissingDaysThreshold FROM Company WHERE  CompanyId = 1 )

	  UPDATE #TEMP_RadioBatteryInformation
	  SET Recommendations = CASE Recommendations WHEN '''' THEN Recommendations + ''Battery Error'' ELSE Recommendations + CHAR(13) + CHAR(10) + ''Battery Error'' END
	  WHERE BatteryStatusTypeid = 2
	  
	  UPDATE #TEMP_RadioBatteryInformation
      SET NotesVisibility = 1
      WHERE Recommendations <> ''''

	  UPDATE #TEMP_RadioBatteryInformation
      SET NotesVisibility = 0
      WHERE Recommendations IS NULL

      UPDATE #TEMP_RadioBatteryInformation
      SET Recommendations = ''No Recommendations''
      WHERE Recommendations = ''''

	/*Perform paging calculation of Radio and Battery Information from #TEMP_RadioBatteryInformation*/
	IF OBJECT_ID(''tempdb..#TEMP_PagingResult'') IS NOT NULL
		DROP TABLE #TEMP_PagingResult

      CREATE TABLE #TEMP_PagingResult(
			[Sequence_no] int IDENTITY(1,1),
            [RadioID] [varchar](50) COLLATE database_default NULL,
            [RadioAlias] [varchar](250) COLLATE database_default NULL,
            [LastKnownRadioID] [varchar](50) COLLATE database_default NULL,
            [LastKnownRadioAlias] [varchar](250) COLLATE database_default NULL,
            [DateOfRegistration] [datetime] NULL,
            [ComputerName] [varchar](250) COLLATE database_default NULL,
            [Proxy] [varchar](250) COLLATE database_default NULL,
            [ProxyStatus] [bit] NULL,
            [ProxyDisconnectedTime] [datetime] NULL,
            [BatteryTypeID] [int] NULL,
            [SerialNumber] [varchar](50) COLLATE database_default NULL,
            [BatteryAlias] [varchar](50) COLLATE database_default NULL,
            [BatteryStatusTypeid] [int] NULL,
            [DateOfRead] [datetime] NULL,
            [CurrentCharge] [int] NULL,
            [PotentialCapacity] [int] NULL,
            [RatedCapacity] [int] NULL,
            [Health] [int] NULL,
            [HealthLevel] [int] NULL,
            [RadioCapacity] [int] NULL,
            [AgeInDay] [int] NULL,
            [TaskResultType] [int] NULL,
            [BatteryNeedToRead] [bit] NULL,
            [ManualReadRequest] [bit] NULL,
            [DuplicateID] [bit] NULL,
            [RadioIDChanged] [varchar](50) COLLATE database_default NULL,
            [DeviceName] [varchar](250) NOT NULL,
            [Notes] [varchar](50) COLLATE database_default NULL,
            [NotesVisibility] [bit] NULL,
            [RecommendationId] [nvarchar](50) COLLATE database_default NULL,
            [Recommendations] [nvarchar](MAX) COLLATE database_default NULL,
            [QueryType] [int] NULL,
            [TotalPage] [int] NULL,
            [CurrentPage] [int] NULL,
            [TotalRecords] [int] NULL
      )

	IF @parameter <> ''''
	BEGIN 
		exec (''
			INSERT INTO #TEMP_PagingResult
			SELECT *,TotalPage = 0, CurrentPage = 0, TotalRecords = 0
			FROM #TEMP_RadioBatteryInformation 
			''+@parameter+''
			'')
	END
	ELSE
	BEGIN 
		exec (''
			INSERT INTO #TEMP_PagingResult
			SELECT *,TotalPage = 0, CurrentPage = 0, TotalRecords = 0
			FROM #TEMP_RadioBatteryInformation 
			ORDER BY ProxyStatus desc, Case QueryType When 4 Then 1 Else 0 End, RadioID, SerialNumber
			'')
	END

	SELECT @TotalRecordCount = Count(1) FROM #TEMP_PagingResult
	
	/*Calculate the Total Page*/
	IF (@TotalRecordCount % @rowcount = 0)
	BEGIN 
		SET @TotalPage = (@TotalRecordCount / @rowcount)
	END
	ELSE
	BEGIN 
		SET @TotalPage = ((@TotalRecordCount / @rowcount) + 1)
	END

	UPDATE #TEMP_PagingResult SET TotalPage = @TotalPage, TotalRecords = @TotalRecordCount


	/*Check if highlighted record required*/
	IF (@RadioID = '''' AND @ComputerName = '''' AND @BatterySerialNumber = '''')
	BEGIN 
		/*If (Request Page > Total Page) OR (Request Page = Last Page) Then Set Request Page to Last Page available*/
		IF (@rowstart > @TotalPage) OR (@rowstart = -1)
			SET @rowstart = @TotalPage
	END
	ELSE
	BEGIN
		IF (@RadioID <> '''')
		BEGIN
			IF EXISTS (SELECT 1 FROM #TEMP_PagingResult WHERE RadioID = @RadioID AND ComputerName = @ComputerName) 
			BEGIN
				SELECT @CurrentSequence = Sequence_no FROM #TEMP_PagingResult WHERE RadioID = @RadioID AND ComputerName = @ComputerName
			END
		END
		ELSE IF EXISTS (SELECT 1 FROM #TEMP_PagingResult WHERE SerialNumber = @BatterySerialNumber) 
		BEGIN
			SELECT @CurrentSequence = Sequence_no FROM #TEMP_PagingResult WHERE SerialNumber = @BatterySerialNumber
		END
		ELSE
		BEGIN
			SET @CurrentSequence = 1
		END
		
		/*Calculate the Page of highlighted record*/
		IF (@CurrentSequence % @rowcount = 0)
		BEGIN 
			SET @rowstart = (@CurrentSequence / @rowcount)
		END
		ELSE
		BEGIN 
			SET @rowstart = ((@CurrentSequence / @rowcount) + 1)
		END
	END

	UPDATE #TEMP_PagingResult SET CurrentPage = @rowstart 
	SELECT * FROM #TEMP_PagingResult WHERE Sequence_no > ((@rowstart - 1) * @rowcount) AND Sequence_no <= ((@rowstart) * @rowcount)
END

' 
END
GO
/****** Object:  StoredProcedure [dbo].[AllRadioBatteryInformation_Computer]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AllRadioBatteryInformation_Computer]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[AllRadioBatteryInformation_Computer]
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	SELECT DISTINCT ComputerName FROM Battery WHERE BatteryStatusTypeID <>0
	UNION
	SELECT DISTINCT ComputerName FROM Radio

END

' 
END
GO
/****** Object:  Table [dbo].[BatteryGroup]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[BatteryGroup](
	[BatteryGroupId] [int] IDENTITY(1,1) NOT NULL,
	[GroupName] [varchar](250) COLLATE database_default NULL,
 CONSTRAINT [PK_BatteryGroup] PRIMARY KEY CLUSTERED 
(
	[BatteryGroupId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
SET IDENTITY_INSERT [dbo].[BatteryGroup] ON
INSERT [dbo].[BatteryGroup] ([BatteryGroupId], [GroupName]) VALUES (0, N'None')
SET IDENTITY_INSERT [dbo].[BatteryGroup] OFF
/****** Object:  UserDefinedFunction [dbo].[EstimatedDays]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EstimatedDays]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date, ,>
-- Description:	<Description, ,>
-- =============================================
CREATE FUNCTION [dbo].[EstimatedDays] 
(
	-- Add the parameters for the function here
	@RE00 int,
    @RE10 int,
    @RE20 int,
    @RE30 int,
    @RE40 int,
    @RE50 int,
    @RE60 int,
    @RE70 int,
    @RE80 int,
    @RE90 int,
    @WF00 int,
    @WF10 int,
    @WF20 int,
    @WF30 int,
    @WF40 int,
    @WF50 int,
    @WF60 int,
    @WF70 int,
    @WF80 int,
    @WF90 int,
    @DaysSinceLastReconditioning int,
    @TRIG int,
    @DateOfInitialUse Datetime,
    @TotalIMPRESChargeCycles int,
    @TotalEstimatedNonIMPRESChargeCycles int
)
RETURNS int
AS
BEGIN
	-- Declare the return variable here
DECLARE @EstimatedDays int
DECLARE @X float
DECLARE @total float
DECLARE @CyclesPerDay float
DECLARE @EstimatedCycles int
if(@DaysSinceLastReconditioning>30 or @TRIG <= 0)
     Begin       
      set @EstimatedDays=0
      return @EstimatedDays
     end
SET @total=@RE00+@RE10+@RE20+@RE30+@RE40+@RE50+@RE60+@RE70+@RE80+@RE90
SET @X=@RE00*5+@RE10*15+@RE20*25+@RE30*35+@RE40*45+@RE50*55+@RE60*65+@RE70*75+@RE80*85+@RE90*95
if @total=0
   set @X=95
Else
   set @X=@X/@total
Declare @j int
set @j=@X/10
set @EstimatedCycles=case 
 when @j=0 and @WF00<>0 then 
    @TRIG/@WF00
 when @j=1 and @WF10<>0 then
    @TRIG/@WF10
 when @j=2 and @WF20<>0 then
    @TRIG/@WF20
 when @j=3 and @WF30<>0 then
    @TRIG/@WF30
 when @j=4 and @WF40<>0 then
    @TRIG/@WF40
 when @j=5 and @WF50<>0 then
    @TRIG/@WF50
 when @j=6 and @WF60<>0 then
    @TRIG/@WF60
 when @j=7 and @WF70<>0 then
    @TRIG/@WF70
 when @j=8 and @WF80<>0 then
    @TRIG/@WF00
 when @j=9 and @WF90<>0 then
    @TRIG/@WF90
 Else 0
 End
 
Declare @DayInService int
set @DayInService=Datediff(Day,@DateOfInitialUse,Getdate())
--if(Datediff(Day,@DateOfInitialUse,Getdate())<=1)
-- set @DayInService=1
if(@DayInService>0)
 set @CyclesPerDay=(@TotalIMPRESChargeCycles+@TotalEstimatedNonIMPRESChargeCycles)*1.0/@DayInService
else
 set @CyclesPerDay=@TotalIMPRESChargeCycles+@TotalEstimatedNonIMPRESChargeCycles
if(@CyclesPerDay>0.001)
 set @EstimatedDays=@EstimatedCycles/@CyclesPerDay
else
 set @EstimatedDays = 1
Declare @Temp int
if(@DaysSinceLastReconditioning>=30)
 set @Temp=0
else
 set @Temp=30-@DaysSinceLastReconditioning
if (@EstimatedDays>=@Temp)
 set @EstimatedDays=@Temp
return (@EstimatedDays)
END
' 
END
GO

/****** Object:  StoredProcedure [dbo].[BatterySelectDynamic]    Script Date: 06/10/2014 13:27:31 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatterySelectDynamic]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[BatterySelectDynamic]
@rowfilter nvarchar(max),

@rowstart INT,

@rowcount INT

AS
	SET NOCOUNT ON;
Begin
	IF @rowfilter = ''''
	BEGIN 
		exec(''select top ( ''+ @rowcount+'')  SerialNumber, CompanyId, Alias, RadioID=IsNull(RadioID,''''''''), RadioAlias=IsNull(RadioAlias,''''''''), LastKnownRadioID=IsNull(LastKnownRadioID,''''''''), LastKnownRadioAlias=IsNull(LastKnownRadioAlias,''''''''), KITn, CHEM, BatteryStatusTypeId, BatteryGroupId, BatteryChargeStateId, RadioFamilyId, CurrentCharge, 
							  PotentialCapacity, RatedCapacity, CapacityRatio, DateOfManufacture,AgeInDays, DateOfInitialUse, DaysSinceLastReconditioning, 
							  DaysSinceRemovalFromCharger, TotalIMPRESChargeCycles, TotalEstimatedNonIMPRESChargeCycles, TotalEstimatedNonIMPRESChargeCyclesPrior, 
							  TotalReconditioningCycles, EstimatedDaysUntilNextReconditioning, SoftwareVersion, TemperatureC, Voltage, LED, DateOfRead, RecommendationId, RichTextRecommendations,
							  CA00, CA10, CA20, CA30, CA40, CA50, CA60, CA70, CA80, CA90, RE00, RE10, RE20, RE30, RE40, RE50, RE60, RE70, RE80, RE90, ComputerName, 
							  DeviceName, PocketNumber, DATEDIFF(d, DateOfRead, CURRENT_TIMESTAMP) as DaysSinceLastRead, DaysSinceInitialUse, SNSR, ICA, CTS, DOIU, WF00, WF10, WF20, WF30, WF40, WF50, WF60, 
							  WF70, WF80, WF90, ETM, LDAY, LHR, LMIN, FDDp, DISp, TRIG, DOIC, FM, Comment, ChargerHighTemperature, ChargerLowTemperature, HID, ALERTID, UnsupportedFieldsList,ErrorFieldsList, DateofLastRemove, OverdueThreshold,Charging,ComputerAlias,DisplayName
							  , RemainingCapacityRatio, TIA4950, UL2504Div2, CSA157, ATEX
							  , NFPA
							  , NFPAContinuousOverTemp
					  , NFPACumulativeOverTemp
					  , NFPAOverTempCounter
					  , BatteryTypeID
							  from dbo.View_BatteryForQuery where serialnumber not in
		(select top (''+@rowstart+'')serialnumber
		from dbo.View_BatteryForQuery where BatteryStatusTypeId<>0 order by serialnumber) and BatteryStatusTypeId<>0 order by serialnumber'')
	END
	ELSE
	BEGIN 
		exec(''select top ( ''+ @rowcount+'')  SerialNumber, CompanyId, Alias, RadioID=IsNull(RadioID,''''''''), RadioAlias=IsNull(RadioAlias,''''''''), LastKnownRadioID=IsNull(LastKnownRadioID,''''''''), LastKnownRadioAlias=IsNull(LastKnownRadioAlias,''''''''), KITn, CHEM, BatteryStatusTypeId, BatteryGroupId, BatteryChargeStateId, RadioFamilyId, CurrentCharge, 
							  PotentialCapacity, RatedCapacity, CapacityRatio, DateOfManufacture,AgeInDays, DateOfInitialUse, DaysSinceLastReconditioning, 
							  DaysSinceRemovalFromCharger, TotalIMPRESChargeCycles, TotalEstimatedNonIMPRESChargeCycles, TotalEstimatedNonIMPRESChargeCyclesPrior, 
							  TotalReconditioningCycles, EstimatedDaysUntilNextReconditioning, SoftwareVersion, TemperatureC, Voltage, LED, DateOfRead, RecommendationId, RichTextRecommendations,
							  CA00, CA10, CA20, CA30, CA40, CA50, CA60, CA70, CA80, CA90, RE00, RE10, RE20, RE30, RE40, RE50, RE60, RE70, RE80, RE90, ComputerName, 
							  DeviceName, PocketNumber, DATEDIFF(d, DateOfRead, CURRENT_TIMESTAMP) as DaysSinceLastRead, DaysSinceInitialUse, SNSR, ICA, CTS, DOIU, WF00, WF10, WF20, WF30, WF40, WF50, WF60, 
							  WF70, WF80, WF90, ETM, LDAY, LHR, LMIN, FDDp, DISp, TRIG, DOIC, FM, Comment, ChargerHighTemperature, ChargerLowTemperature, HID, ALERTID, UnsupportedFieldsList,ErrorFieldsList, DateofLastRemove, OverdueThreshold,Charging,ComputerAlias,DisplayName
							  , RemainingCapacityRatio, TIA4950, UL2504Div2, CSA157, ATEX
							  					  , NFPA
												  , NFPAContinuousOverTemp
					  , NFPACumulativeOverTemp
					  , NFPAOverTempCounter
					  , BatteryTypeID
							  from dbo.View_BatteryForQuery where serialnumber not in
		(select top (''+@rowstart+'')serialnumber
		from dbo.View_BatteryForQuery where (''+@rowfilter+'') order by serialnumber) and (''+@rowfilter+'') order by serialnumber'')
	END
end
' 
END
GO

/****** Object:  Table [dbo].[Device]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Device]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[Device](
	[DeviceId] [int] IDENTITY(1,1) NOT NULL,
	[DeviceName] [varchar](250) COLLATE database_default NOT NULL,
	[DisplayName] [varchar](250) COLLATE database_default NULL,
	[ComputerName] [varchar](250) COLLATE database_default NOT NULL,
	[IsConnected] [bit] NULL,
	[NumberOfPockets] [int] NULL,
	[Pocket1] [varchar](50) COLLATE database_default NULL,
	[Pocket2] [varchar](50) COLLATE database_default NULL,
	[Pocket3] [varchar](50) COLLATE database_default NULL,
	[Pocket4] [varchar](50) COLLATE database_default NULL,
	[Pocket5] [varchar](50) COLLATE database_default NULL,
	[Pocket6] [varchar](50) COLLATE database_default NULL,
	[Pocket7] [varchar](50) COLLATE database_default NULL,
	[Pocket8] [varchar](50) COLLATE database_default NULL,
	[Pocket9] [varchar](50) COLLATE database_default NULL,
	[Pocket10] [varchar](50) COLLATE database_default NULL,
	[Pocket11] [varchar](50) COLLATE database_default NULL,
	[Pocket12] [varchar](50) COLLATE database_default NULL,
	[Pocket13] [varchar](50) COLLATE database_default NULL,
	[Pocket14] [varchar](50) COLLATE database_default NULL,
	[Pocket15] [varchar](50) COLLATE database_default NULL,
	[Pocket16] [varchar](50) COLLATE database_default NULL,
	[Pocket17] [varchar](50) COLLATE database_default NULL,
	[Pocket18] [varchar](50) COLLATE database_default NULL,
	[Pocket19] [varchar](50) COLLATE database_default NULL,
	[Pocket20] [varchar](50) COLLATE database_default NULL,
	[Pocket21] [varchar](50) COLLATE database_default NULL,
	[Pocket22] [varchar](50) COLLATE database_default NULL,
	[Pocket23] [varchar](50) COLLATE database_default NULL,
	[Pocket24] [varchar](50) COLLATE database_default NULL,
	[Pocket25] [varchar](50) COLLATE database_default NULL,
	[Pocket26] [varchar](50) COLLATE database_default NULL,
	[Pocket27] [varchar](50) COLLATE database_default NULL,
	[Pocket28] [varchar](50) COLLATE database_default NULL,
	[Pocket29] [varchar](50) COLLATE database_default NULL,
	[Pocket30] [varchar](50) COLLATE database_default NULL,
	[Pocket31] [varchar](50) COLLATE database_default NULL,
	[DateOfLastHeartbeat] [datetime] NULL,
	[DeviceType] [nvarchar](max) COLLATE database_default NULL,
	[DeviceStatus] [int] NULL,
	[DeviceInfo] [varchar](max) COLLATE database_default NULL,
	[DisconnectedTime] [datetime] NULL,
	[ConnectedTime] [datetime] NULL,
	[ComputerAlias] [nvarchar](50) COLLATE database_default NULL,
 CONSTRAINT [PK_Device_1] PRIMARY KEY CLUSTERED 
(
	[DeviceId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
/****** Object:  StoredProcedure [dbo].[DeviceChargeUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceChargeUpdateCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[DeviceChargeUpdateCommand]
(
	@DeviceId int,
	@SerialNumber varchar(50),
	@DateTimeOfChargeStart datetime,
	@DateTimeOfChargeEnd datetime,
	@Original_DeviceChargeId int,
	@IsNull_DeviceId Int,
	@Original_DeviceId int,
	@IsNull_SerialNumber Int,
	@Original_SerialNumber varchar(50),
	@IsNull_DateTimeOfChargeStart Int,
	@Original_DateTimeOfChargeStart datetime,
	@IsNull_DateTimeOfChargeEnd Int,
	@Original_DateTimeOfChargeEnd datetime,
	@DeviceChargeId int
)
AS
	SET NOCOUNT OFF;
UPDATE [devicecharge] SET [DeviceId] = @DeviceId, [SerialNumber] = @SerialNumber, [DateTimeOfChargeStart] = @DateTimeOfChargeStart, [DateTimeOfChargeEnd] = @DateTimeOfChargeEnd WHERE (([DeviceChargeId] = @Original_DeviceChargeId) AND ((@IsNull_DeviceId = 1 AND [DeviceId] IS NULL) OR ([DeviceId] = @Original_DeviceId)) AND ((@IsNull_SerialNumber = 1 AND [SerialNumber] IS NULL) OR ([SerialNumber] = @Original_SerialNumber)) AND ((@IsNull_DateTimeOfChargeStart = 1 AND [DateTimeOfChargeStart] IS NULL) OR ([DateTimeOfChargeStart] = @Original_DateTimeOfChargeStart)) AND ((@IsNull_DateTimeOfChargeEnd = 1 AND [DateTimeOfChargeEnd] IS NULL) OR ([DateTimeOfChargeEnd] = @Original_DateTimeOfChargeEnd)));
	
SELECT DeviceChargeId, DeviceId, SerialNumber, DateTimeOfChargeStart, DateTimeOfChargeEnd FROM DeviceCharge WHERE (DeviceChargeId = @DeviceChargeId)
' 
END
GO
/****** Object:  Table [dbo].[RadioFamilyKitNumber]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioFamilyKitNumber]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[RadioFamilyKitNumber](
	[RadioFamilyId] [int] NOT NULL,
	[KITn] [varchar](50) COLLATE database_default NOT NULL,
	[FM] [bit] NULL,
	[CHEM] [int] NULL,
	[RatedCapacity] [int] NULL,
	[KITnId] [int] IDENTITY(1,1) NOT NULL,
	[TIA4950] [bit] NULL,
	[UL2504Div2] [bit] NULL,
	[CSA157] [bit] NULL,
	[ATEX] [bit] NULL,
	[NFPA] [bit] NULL,
	[BatteryTypeID] [int] NULL,
 CONSTRAINT [PK_RadioFamilyKitNumber] PRIMARY KEY CLUSTERED 
(
	[RadioFamilyId] ASC,
	[KITn] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
SET IDENTITY_INSERT [dbo].[RadioFamilyKitNumber] ON
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (1, N'HNN9031', 0, 1, 1525, 1, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (63, N'HNN9032', 1, 1, 1525, 2, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (1, N'NNTN4435', 0, 2, 1800, 3, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (63, N'NNTN4436', 1, 2, 1700, 4, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (63, N'NNTN4437', 1, 2, 1700, 5, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (1, N'NNTN6034', 0, 3, 4150, 6, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (63, N'NNTN7453', 1, 3, 3950, 7, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (1, N'NTN9862', 0, 3, 2750, 8, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (1, N'PMNN4093', 0, 2, 3000, 9, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (62, N'NNTN6263', 1, 2, 2000, 10, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (2, N'NNTN7335', 0, 3, 2700, 11, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (2, N'NNTN7554', 0, 3, 2050, 12, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (62, N'NTN9857', 1, 2, 2000, 13, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (2, N'NTN9858', 0, 2, 2100, 14, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (4, N'HNN9033', 0, 1, 2000, 15, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (4, N'HNN9034', 1, 1, 2000, 16, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (5, N'PMNN4066', 0, 3, 1500, 17, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (5, N'PMNN4069', 1, 3, 1400, 18, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (5, N'PMNN4077', 0, 3, 2150, 19, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (5, N'PMNN4101', 0, 3, 1500, 20, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (5, N'PMNN4102', 1, 3, 1400, 21, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (5, N'PMNN4103', 0, 3, 2150, 22, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (5, N'PMNN4262', 0, 3, 2850, 23, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (6, N'HNN4001', 0, 2, 1800, 24, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (59, N'HNN4002', 1, 2, 1690, 25, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (6, N'HNN4003', 0, 3, 2000, 26, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (6, N'HNN9028', 0, 1, 1500, 27, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (59, N'HNN9029', 1, 1, 1500, 28, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (6, N'PMNN4156', 0, 2, 2000, 29, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (59, N'PMNN4157', 1, 2, 1850, 30, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (6, N'PMNN4159', 0, 3, 2350, 31, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (7, N'NNTN7033', 1, 3, 4100, 32, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (7, N'NNTN7034', 0, 3, 4200, 33, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (7, N'NNTN7035', 1, 2, 2000, 34, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (7, N'NNTN7036', 1, 2, 2000, 35, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (7, N'NNTN7037', 0, 2, 2100, 36, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (7, N'NNTN7038', 0, 3, 2900, 37, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (7, N'NNTN7573', 0, 2, 2100, 38, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (7, N'NNTN8092', 1, 3, 2300, 39, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (7, N'PMNN4403', 0, 3, 2150, 40, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (5, N'PMNN4407', 0, 3, 1500, 41, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (5, N'PMNN4409', 0, 3, 2150, 42, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (5, N'PMNN4488', 0, 3, 3000, 43, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (47, N'PMNN4491', 0, 3, 2100, 44, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (47, N'PMNN4493', 0, 3, 3000, 45, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (5, N'PMNN4499', 0, 3, 3000, 46, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (44, N'NNTN8128', 0, 3, 1900, 47, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (14, N'NNTN8305', 0, 3, 1250, 48, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (44, N'PMNN4424', 0, 3, 2300, 49, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (16, N'NNTN8560', 0, 3, 2500, 50, 1, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (17, N'NNTN8129', 1, 3, 2300, 51, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (19, N'NNTN8386', 0, 3, 1800, 52, 0, 0, 1, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (19, N'NNTN7789', 0, 3, 1750, 53, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (19, N'NNTN8287', 0, 3, 1750, 54, 0, 0, 1, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (5, N'PMNN4417', 0, 3, 1500, 55, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (5, N'PMNN4418', 0, 3, 2150, 56, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (45, N'PMNN4448', 0, 3, 2800, 57, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (22, N'NNTN8359', 0, 3, 2075, 58, 0, 0, 0, 1, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (23, N'NNTN8750', 0, 3, 2050, 59, 0, 0, 1, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (61, N'NNTN8840', 0, 3, 2000, 60, 0, 0, 0, 1, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (25, N'NNTN8921', 0, 3, 4500, 61, 1, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (25, N'NNTN8930', 0, 3, 2650, 62, 1, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (26, N'PMNN4485', 0, 3, 2550, 63, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (26, N'PMNN4486', 0, 3, 3400, 64, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (26, N'PMNN4487', 0, 3, 4850, 65, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (26, N'PMNN4494', 0, 3, 5100, 66, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (46, N'PMNN4489', 0, 3, 2900, 67, 1, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (28, N'PMNN4490', 0, 3, 2900, 68, 1, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (29, N'PMNN4504', 0, 3, 3400, 69, 0, 1, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (29, N'PMNN4505', 0, 3, 4850, 70, 0, 1, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (30, N'PMNN4474', 0, 3, 2800, 71, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (34, N'PMNN4530', 0, 3, 3700, 72, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (32, N'NNTN8570', 0, 3, 1200, 73, 0, 0, 0, 1, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (33, N'PMNN4522', 0, 3, 3300, 74, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (34, N'PMNN4549', 0, 3, 2800, 75, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (35, N'PMNN4510', 0, 3, 2300, 76, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (36, N'PMNN4547', 0, 3, 3100, 77, 1, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (37, N'PMNN4546', 0, 3, 5000, 78, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (37, N'PMNN4545', 0, 3, 2500, 79, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (5, N'PMNN4543', 0, 3, 2450, 80, 0, 0, 0, 0, 0, 1)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (5, N'PMNN4544', 0, 3, 2450, 81, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (5, N'PMNN4548', 0, 3, 2450, 82, 0, 0, 0, 0, 0, 1)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (36, N'PMNN4573', 0, 3, 4600, 83, 1, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (7, N'NNTN8091', 1, 3, 2300, 84, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (39, N'PMNN4582', 0, 3, 2900, 85, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (39, N'PMNN4801', 0, 3, 1900, 86, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (39, N'PMNN4802', 0, 3, 3400, 87, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (40, N'PMNN4803', 0, 3, 2800, 88, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (41, N'PMNN4804', 0, 3, 2850, 89, 1, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (41, N'PMNN4805', 0, 3, 4000, 90, 1, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (42, N'NNTN9087', 0, 3, 3850, 91, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (43, N'NNTN9088', 0, 3, 3850, 92, 0, 1, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (42, N'NNTN9089', 0, 3, 5850, 93, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (43, N'NNTN9090', 0, 3, 5850, 94, 0, 1, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (42, N'NNTN9216', 0, 3, 4400, 95, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (43, N'NNTN9217', 0, 3, 4400, 96, 0, 1, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (36, N'PMNN4579', 0, 3, 3850, 97, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (5, N'PMNN4502', 0, 3, 3000, 98, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (5, N'PMNN4525', 0, 3, 1950, 99, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (48, N'NNTN4321', 0, 3, 2050, 100, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (49, N'PMNN4807', 0, 3, 2050, 101, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (49, N'PMNN4808', 0, 3, 2300, 102, 0, 0, 0, 0, 0, 1)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (49, N'PMNN4809', 0, 4, 2700, 103, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (50, N'PMNN4810', 0, 3, 3100, 104, 1, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (51, N'PMNN4812', 0, 3, 3400, 105, 0, 0, 0, 0, 1, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (52, N'PMNN4813', 0, 4, 2700, 106, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (53, N'PMNN4816', 0, 3, 3000, 107, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (54, N'PMNN4830', 0, 3, 5600, 108, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (58, N'PMNN4815', 0, 3, 3100, 109, 0, 1, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (53, N'PMNN4817', 0, 3, 4400, 110, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (57, N'PMNN4818', 0, 3, 3450, 111, 1, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (56, N'NNTN8182', 0, 3, 3100, 112, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (60, N'PMNN4586', 0, 3, 3500, 113, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (64, N'PMNN4598', 0, 3, 2300, 114, 0, 0, 0, 0, 0, 1)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (64, N'PMNN4600', 0, 3, 2100, 115, 0, 0, 0, 0, 0, 1)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (5, N'PMNN4406', 0, 3, 1500, 116, 0, 0, 0, 0, 0, 1)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (65, N'PMNN4848', 0, 3, 2100, 117, 0, 0, 0, 1, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (66, N'PMNN4888', 0, 3, 2200, 118, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (66, N'PMNN4878', 0, 3, 2400, 119, 0, 0, 0, 0, 0, 1)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (66, N'PMNN4889', 0, 3, 3200, 120, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (66, N'PMNN4890', 0, 3, 3200, 121, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (42, N'PMNN4895', 0, 3, 5400, 122, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (43, N'PMNN4896', 0, 3, 5400, 123, 0, 1, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (67, N'PMNN4893', 0, 3, 4100, 124, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (50, N'PMNN4603', 0, 3, 3100, 125, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (54, N'PMNN4877', 0, 3, 5600, 126, 0, 0, 0, 0, 0, 2)
INSERT [dbo].[RadioFamilyKitNumber] ([RadioFamilyId], [KITn], [FM], [CHEM], [RatedCapacity], [KITnId], [TIA4950], [UL2504Div2], [CSA157], [ATEX], [NFPA], [BatteryTypeID]) VALUES (67, N'PMNN4905', 0, 3, 4100, 127, 0, 1, 0, 0, 0, 2)

SET IDENTITY_INSERT [dbo].[RadioFamilyKitNumber] OFF
/****** Object:  StoredProcedure [dbo].[RadioFamilyKitNumberDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioFamilyKitNumberDeleteCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioFamilyKitNumberDeleteCommand]
(
	@Original_RadioFamilyId int,
	@Original_KITn varchar(50)
)
AS
	SET NOCOUNT OFF;
DELETE FROM [radiofamilyKitNumber] WHERE (([RadioFamilyId] = @Original_RadioFamilyId) AND ([KITn] = @Original_KITn))
' 
END
GO
/****** Object:  StoredProcedure [dbo].[RadioFamilyKitNumberSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioFamilyKitNumberSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioFamilyKitNumberSelectCommand]
AS
	SET NOCOUNT ON;
select * from radiofamilyKitNumber
' 
END
GO
/****** Object:  Table [dbo].[BatteryType]    Script Date: 04/14/2014 15:41:17 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryType]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[BatteryType](
	[BatteryTypeID] [int] NOT NULL,
	[Name] [nvarchar](max) COLLATE database_default NULL,
 CONSTRAINT [PK_BatteryType] PRIMARY KEY CLUSTERED 
(
	[BatteryTypeID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
INSERT [dbo].[BatteryType] ([BatteryTypeID], [Name]) VALUES (0, N'External Power Source')
INSERT [dbo].[BatteryType] ([BatteryTypeID], [Name]) VALUES (1, N'Non-IMPRES')
INSERT [dbo].[BatteryType] ([BatteryTypeID], [Name]) VALUES (2, N'IMPRES')
INSERT [dbo].[BatteryType] ([BatteryTypeID], [Name]) VALUES (999, N'Unknown')

/****** Object:  Table [dbo].[TaskType]    Script Date: 04/14/2014 15:41:17 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskType]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[TaskType](
	[TaskTypeID] [int] NOT NULL,
	[Name] [nvarchar](max) COLLATE database_default NULL,
 CONSTRAINT [PK_TaskType] PRIMARY KEY CLUSTERED 
(
	[TaskTypeID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
INSERT [dbo].[TaskType] ([TaskTypeID], [Name]) VALUES (0, N'Static + Dynamic')
INSERT [dbo].[TaskType] ([TaskTypeID], [Name]) VALUES (1, N'Static')
INSERT [dbo].[TaskType] ([TaskTypeID], [Name]) VALUES (2, N'Dynamic')
/****** Object:  Table [dbo].[TaskResultType]    Script Date: 04/14/2014 15:41:17 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskResultType]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[TaskResultType](
	[TaskResultTypeID] [int] NOT NULL,
	[Name] [nvarchar](max) COLLATE database_default NULL,
 CONSTRAINT [PK_TaskResultType] PRIMARY KEY CLUSTERED 
(
	[TaskResultTypeID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
INSERT [dbo].[TaskResultType] ([TaskResultTypeID], [Name]) VALUES (0, N'Success')
INSERT [dbo].[TaskResultType] ([TaskResultTypeID], [Name]) VALUES (1, N'Failure')
INSERT [dbo].[TaskResultType] ([TaskResultTypeID], [Name]) VALUES (2, N'In Charger')
INSERT [dbo].[TaskResultType] ([TaskResultTypeID], [Name]) VALUES (3, N'Pending Registration')
INSERT [dbo].[TaskResultType] ([TaskResultTypeID], [Name]) VALUES (4, N'Pending Enabled Personality')
INSERT [dbo].[TaskResultType] ([TaskResultTypeID], [Name]) VALUES (5, N'Source Not Registered')
INSERT [dbo].[TaskResultType] ([TaskResultTypeID], [Name]) VALUES (6, N'Target Not Registered')
INSERT [dbo].[TaskResultType] ([TaskResultTypeID], [Name]) VALUES (7, N'Non-IMPRES')
INSERT [dbo].[TaskResultType] ([TaskResultTypeID], [Name]) VALUES (8, N'Invalid Request Syntax')
INSERT [dbo].[TaskResultType] ([TaskResultTypeID], [Name]) VALUES (9, N'Index Out of Range')
INSERT [dbo].[TaskResultType] ([TaskResultTypeID], [Name]) VALUES (10, N'Response Time Out')
INSERT [dbo].[TaskResultType] ([TaskResultTypeID], [Name]) VALUES (11, N'Battery Data Error')
INSERT [dbo].[TaskResultType] ([TaskResultTypeID], [Name]) VALUES (12, N'Battery Not Match')
INSERT [dbo].[TaskResultType] ([TaskResultTypeID], [Name]) VALUES (101, N'Pending Battery Request')
INSERT [dbo].[TaskResultType] ([TaskResultTypeID], [Name]) VALUES (102, N'Pending Battery Response')
INSERT [dbo].[TaskResultType] ([TaskResultTypeID], [Name]) VALUES (103, N'Current Radio with Battery Health Data')
INSERT [dbo].[TaskResultType] ([TaskResultTypeID], [Name]) VALUES (105, N'Last Known Radio with Battery Health Data')

/****** Object:  Table [dbo].[Task]    Script Date: 04/14/2014 15:41:51 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Task]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[Task](
	[TaskID] [int] IDENTITY(1,1) NOT NULL,
	[RequestID] [int] NULL,
	[TaskTypeID] [int] NULL,
	[TaskResultTypeID] [int] NULL,
	[RadioIP] [varchar](50) COLLATE database_default NULL,
	[RadioID] [varchar](50) COLLATE database_default NULL,
	[RadioESN] [nvarchar](50) COLLATE database_default NULL,
	[ComputerName] [varchar](250) COLLATE database_default NULL,
	[BatteryTypeID] [int] NULL,
	[BatterySerialNumber] [varchar](50) COLLATE database_default NULL,
	[TaskDateTime] [datetime] NULL,
	[ResponseDateTime] [datetime] NULL,
 CONSTRAINT [PK_Task] PRIMARY KEY CLUSTERED 
(
	[TaskID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO

/****** Object:  Table [dbo].[BatteryLastKnownRadio]    Script Date: 04/14/2014 15:42:18 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryLastKnownRadio]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[BatteryLastKnownRadio](
    [BatterySerialNumber] [varchar](50) NOT NULL,
    [RadioPresentity] [varchar](250) NOT NULL,
    [RadioID] [varchar](50) NOT NULL,
    [RadioAlias] [varchar](250) NOT NULL,
    [RadioESN] [nvarchar](50) NOT NULL,
    [DeviceName] [varchar](250) NOT NULL,
    [ComputerName] [varchar](250) NOT NULL,
    [DateOfLastRadioRegistration] [datetime] NULL,
    [DateOfLastBatteryRead] [datetime] NULL,
CONSTRAINT [PK_BatteryLastKnownRadio] PRIMARY KEY CLUSTERED 
(
        [BatterySerialNumber] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO

/****** Object:  Table [dbo].[Filter]    Script Date: 1/10/2024 4:12:34 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Filter]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[Filter](
	[FilterName] [nchar](100) NOT NULL,
	[FieldName] [nchar](1000) NULL,
	[Operator] [nchar](1000) NULL,
	[Value] [nchar](1000) NULL,
	[DateCreated] [datetime] NULL,
 CONSTRAINT [PK_Filter] PRIMARY KEY CLUSTERED 
(
	[FilterName] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO

/****** Object:  Table [dbo].[Radio]    Script Date: 04/14/2014 15:42:18 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Radio]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[Radio](
	[RadioIP] [varchar](50) COLLATE database_default NOT NULL,
	[RadioID] [varchar](50) COLLATE database_default NOT NULL,
	[RadioESN] [nvarchar](50) COLLATE database_default NOT NULL,
	[RadioAlias] [varchar](250) COLLATE database_default NULL,
	[ComputerName] [varchar](250) COLLATE database_default NOT NULL,
	[BatteryTypeID] [int] NULL,
	[BatterySerialNumber] [varchar](50) COLLATE database_default NULL,
	[TaskID] [int] NULL,
	[DateOfRegistration] [datetime] NULL,
	[DateOfRead] [datetime] NULL,
	[NeedToRead] [bit] NULL,
	[ManualReadRequest] [bit] NULL,
	[RHOT] [int] NULL,
	[DuplicateID] [bit] NULL,
	[RadioIDChanged] [varchar](50) COLLATE database_default NULL,
	[DeviceName] [varchar](250) NOT NULL,
CONSTRAINT [PK_Radio] PRIMARY KEY CLUSTERED 
(	[RadioID] ASC, [ComputerName] ASC, [DeviceName] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO

/****** Object:  Default [DF_Radio_NeedToRead]    Script Date: 04/14/2014 15:42:18 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Radio_NeedToRead]') AND parent_object_id = OBJECT_ID(N'[dbo].[Radio]'))
Begin
IF Not EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Radio_NeedToRead]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Radio] ADD  CONSTRAINT [DF_Radio_NeedToRead]  DEFAULT ((0)) FOR [NeedToRead]
END

End
GO
/****** Object:  Default [DF_Radio_ManualReadRequest]    Script Date: 04/14/2014 15:42:18 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Radio_ManualReadRequest]') AND parent_object_id = OBJECT_ID(N'[dbo].[Radio]'))
Begin
IF Not EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Radio_ManualReadRequest]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Radio] ADD  CONSTRAINT [DF_Radio_ManualReadRequest]  DEFAULT ((0)) FOR [ManualReadRequest]
END

End
GO
/****** Object:  Default [DF_Radio_DuplicateID]    Script Date: 04/14/2014 15:42:18 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Radio_DuplicateID]') AND parent_object_id = OBJECT_ID(N'[dbo].[Radio]'))
Begin
IF Not EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Radio_DuplicateID]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Radio] ADD  CONSTRAINT [DF_Radio_DuplicateID]  DEFAULT ((0)) FOR [DuplicateID]
END

End
GO

/****** Object:  Table [dbo].[RadioHistory]    Script Date: 04/14/2014 15:42:47 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[RadioHistory](
	[RadioHistoryID] [int] IDENTITY(1,1) NOT NULL,
	[RadioIP] [varchar](50) COLLATE database_default NULL,
	[RadioID] [varchar](50) COLLATE database_default NULL,
	[RadioESN] [nvarchar](50) COLLATE database_default NULL,
	[BatteryTypeID] [int] NULL,
	[BatterySerialNumber] [varchar](50) COLLATE database_default NULL,
	[ComputerName] [varchar](250) COLLATE database_default NULL,
	[DateOfRegistration] [datetime] NULL,
	[DuplicateID] [bit] NULL,
	[RadioIDChanged] [varchar](50) COLLATE database_default NULL,
	[DeviceName] [varchar](250) NOT NULL,
 CONSTRAINT [PK_RadioHistory] PRIMARY KEY CLUSTERED 
(
	[RadioHistoryID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO

/****** Object:  StoredProcedure [dbo].[EOSLReport]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EOSLReport]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[EOSLReport] 
	-- Add the parameters for the stored procedure here
	@parameter nvarchar(max),
    @rowcount int,
    @rowstart int
AS
--declare @DateofManufacture datetime;
--Set @DateofManufacture=DateAdd(year,-@BatteryAge,GetDate())

if (@parameter = ''EOSL (%)'')
BEGIN
    SET NOCOUNT ON;

  exec (''
   select top ( ''+ @rowcount+'')  SerialNumber, CompanyId, Alias, KITn, CHEM, BatteryStatusTypeId, BatteryGroupId, BatteryChargeStateId, RadioFamilyId, CurrentCharge, 
                      PotentialCapacity, RatedCapacity, CapacityRatio, DateOfManufacture, AgeInDays, DateOfInitialUse, DaysSinceLastReconditioning, 
                      DaysSinceRemovalFromCharger, TotalIMPRESChargeCycles, TotalEstimatedNonIMPRESChargeCycles, TotalEstimatedNonIMPRESChargeCyclesPrior, 
                      TotalReconditioningCycles, EstimatedDaysUntilNextReconditioning, SoftwareVersion, TemperatureC, Voltage, LED, DateOfRead, RecommendationId,RichTextRecommendations, 
                      CA00, CA10, CA20, CA30, CA40, CA50, CA60, CA70, CA80, CA90, RE00, RE10, RE20, RE30, RE40, RE50, RE60, RE70, RE80, RE90, ComputerName, 
                      DeviceName, PocketNumber,DaysSinceLastRead, DaysSinceInitialUse, SNSR, ICA, CTS, DOIU, WF00, WF10, WF20, WF30, WF40, WF50, WF60, 
                      WF70, WF80, WF90, ETM, LDAY, LHR, LMIN, FDDp, DISp, TRIG, DOIC, FM, TIA4950, UL2504Div2, CSA157, ATEX from battery where serialnumber not in 
   (select top ( ''+@rowstart+'') serialnumber from battery  where CapacityRatio < (SELECT EOSLCapacityPercent FROM Company WHERE  CompanyId = 1 )  and  BatteryStatusTypeId <> 0 order by serialnumber )
    and CapacityRatio < (SELECT EOSLCapacityPercent FROM Company WHERE  CompanyId = 1 )  and  BatteryStatusTypeId <> 0 order by SerialNumber 
'')
    
END
else if (@parameter = ''Age'')
BEGIN
    SET NOCOUNT ON;
exec (''
    select top ( ''+ @rowcount+'')  SerialNumber, CompanyId, Alias, KITn, CHEM, BatteryStatusTypeId, BatteryGroupId, BatteryChargeStateId, RadioFamilyId, CurrentCharge, 
                      PotentialCapacity, RatedCapacity, CapacityRatio, DateOfManufacture, AgeInDays, DateOfInitialUse, DaysSinceLastReconditioning, 
                      DaysSinceRemovalFromCharger, TotalIMPRESChargeCycles, TotalEstimatedNonIMPRESChargeCycles, TotalEstimatedNonIMPRESChargeCyclesPrior, 
                      TotalReconditioningCycles, EstimatedDaysUntilNextReconditioning, SoftwareVersion, TemperatureC, Voltage, LED, DateOfRead, RecommendationId,RichTextRecommendations, 
                      CA00, CA10, CA20, CA30, CA40, CA50, CA60, CA70, CA80, CA90, RE00, RE10, RE20, RE30, RE40, RE50, RE60, RE70, RE80, RE90, ComputerName, 
                      DeviceName, PocketNumber, DaysSinceLastRead, DaysSinceInitialUse, SNSR, ICA, CTS, DOIU, WF00, WF10, WF20, WF30, WF40, WF50, WF60, 
                      WF70, WF80, WF90, ETM, LDAY, LHR, LMIN, FDDp, DISp, TRIG, DOIC, FM, TIA4950, UL2504Div2, CSA157, ATEX from battery where serialnumber not in 
   (select top ( ''+@rowstart+'') serialnumber from battery  where AgeInDays  > (SELECT EOSLAgeInDays FROM Company WHERE  CompanyId = 1 ) and  BatteryStatusTypeId <> 0 order by serialnumber )
    and AgeInDays > (SELECT EOSLAgeInDays FROM Company WHERE  CompanyId = 1 ) and  BatteryStatusTypeId <> 0 order by SerialNumber 
'')

   
END
else if(@parameter = ''Both'')
BEGIN
    SET NOCOUNT ON;

exec (''
    select top ('' + @rowcount + '')  SerialNumber, CompanyId, Alias, KITn, CHEM, BatteryStatusTypeId, BatteryGroupId, BatteryChargeStateId, RadioFamilyId, CurrentCharge, 
                      PotentialCapacity, RatedCapacity, CapacityRatio, DateOfManufacture, AgeInDays, DateOfInitialUse, DaysSinceLastReconditioning, 
                      DaysSinceRemovalFromCharger, TotalIMPRESChargeCycles, TotalEstimatedNonIMPRESChargeCycles, TotalEstimatedNonIMPRESChargeCyclesPrior, 
                      TotalReconditioningCycles, EstimatedDaysUntilNextReconditioning, SoftwareVersion, TemperatureC, Voltage, LED, DateOfRead, RecommendationId,RichTextRecommendations, 
                      CA00, CA10, CA20, CA30, CA40, CA50, CA60, CA70, CA80, CA90, RE00, RE10, RE20, RE30, RE40, RE50, RE60, RE70, RE80, RE90, ComputerName, 
                      DeviceName, PocketNumber, DaysSinceLastRead, DaysSinceInitialUse, SNSR, ICA, CTS, DOIU, WF00, WF10, WF20, WF30, WF40, WF50, WF60, 
                      WF70, WF80, WF90, ETM, LDAY, LHR, LMIN, FDDp, DISp, TRIG, DOIC, FM, TIA4950, UL2504Div2, CSA157, ATEX from battery where 
    serialnumber not in 
   (
    select top ('' + @rowstart + '') serialnumber from battery  where 
    (CapacityRatio < (SELECT EOSLCapacityPercent FROM Company WHERE  CompanyId = 1 ) 
    or  AgeInDays  > (SELECT EOSLAgeInDays FROM Company WHERE  CompanyId = 1 ))  and  BatteryStatusTypeId <> 0 order by serialnumber  
    )

    and (CapacityRatio < (SELECT EOSLCapacityPercent FROM Company WHERE  CompanyId = 1 ) 
    or  AgeInDays > (SELECT EOSLAgeInDays FROM Company WHERE  CompanyId = 1 )) and  BatteryStatusTypeId <> 0

    order by SerialNumber 
'')

    
END
' 
END
GO
/****** Object:  StoredProcedure [dbo].[DeviceLogUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceLogUpdateCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[DeviceLogUpdateCommand]
(
	@LocationName varchar(250),
	@DeviceName varchar(250),
	@BatterySerialNumber varchar(50),
	@IsConnected bit,
	@PocketNumber int,
	@ConnectDateTime datetime,
	@DisconnectDateTime datetime,
	@Original_DeviceLogId int,
	@Original_LocationName varchar(250),
	@Original_DeviceName varchar(250),
	@Original_BatterySerialNumber varchar(50),
	@IsNull_IsConnected Int,
	@Original_IsConnected bit,
	@IsNull_PocketNumber Int,
	@Original_PocketNumber int,
	@IsNull_ConnectDateTime Int,
	@Original_ConnectDateTime datetime,
	@IsNull_DisconnectDateTime Int,
	@Original_DisconnectDateTime datetime,
	@DeviceLogId int
)
AS
	SET NOCOUNT OFF;
UPDATE [devicelog] SET [LocationName] = @LocationName, [DeviceName] = @DeviceName, [BatterySerialNumber] = @BatterySerialNumber, [IsConnected] = @IsConnected, [PocketNumber] = @PocketNumber, [ConnectDateTime] = @ConnectDateTime, [DisconnectDateTime] = @DisconnectDateTime WHERE (([DeviceLogId] = @Original_DeviceLogId) AND ([LocationName] = @Original_LocationName) AND ([DeviceName] = @Original_DeviceName) AND ([BatterySerialNumber] = @Original_BatterySerialNumber) AND ((@IsNull_IsConnected = 1 AND [IsConnected] IS NULL) OR ([IsConnected] = @Original_IsConnected)) AND ((@IsNull_PocketNumber = 1 AND [PocketNumber] IS NULL) OR ([PocketNumber] = @Original_PocketNumber)) AND ((@IsNull_ConnectDateTime = 1 AND [ConnectDateTime] IS NULL) OR ([ConnectDateTime] = @Original_ConnectDateTime)) AND ((@IsNull_DisconnectDateTime = 1 AND [DisconnectDateTime] IS NULL) OR ([DisconnectDateTime] = @Original_DisconnectDateTime)));
	
SELECT DeviceLogId, LocationName, DeviceName, BatterySerialNumber, IsConnected, PocketNumber, ConnectDateTime, DisconnectDateTime FROM DeviceLog WHERE (DeviceLogId = @DeviceLogId)
' 
END
GO
/****** Object:  StoredProcedure [dbo].[AllNonImpres]    Script Date: 06/03/2014 22:22:29 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[AllNonImpres]
	-- Add the parameters for the stored procedure here
		@parameter nvarchar(max),
    @rowcount int,
    @rowstart int
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	SELECT * FROM Radio WHERE BatteryTypeID not in (2,999) Order By RadioID, ComputerName
END
GO
/****** Object:  StoredProcedure [dbo].[AllRadioHistory]    Script Date: 06/03/2014 22:22:29 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[AllRadioHistory]
	-- Add the parameters for the stored procedure here
		@parameter nvarchar(max),
    @rowcount int,
    @rowstart int
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	  SELECT RadioHistoryID
			, RadioIP
			, RadioID
			, RadioESN
			, BatteryTypeID
			, BatterySerialNumber
			, ComputerName
			, DateOfRegistration
			, DuplicateID
			, RadioIDChanged = isnull(RadioIDChanged,'')
			, Proxy = DeviceName
	FROM RadioHistory
	WHERE RadioID=@Parameter
	ORDER BY DateOfRegistration
END
GO
/****** Object:  StoredProcedure [dbo].[AllBatteryHistory]    Script Date: 06/03/2014 22:22:29 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[AllBatteryHistory]
	-- Add the parameters for the stored procedure here
		@parameter nvarchar(max),
    @rowcount int,
    @rowstart int
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	  SELECT RadioHistoryID
			, RadioIP
			, RadioID
			, RadioESN
			, BatteryTypeID
			, BatterySerialNumber
			, ComputerName
			, DateOfRegistration
			, DuplicateID
			, RadioIDChanged = isnull(RadioIDChanged,'')
			, DeviceName
	  FROM RadioHistory 
	  WHERE BatterySerialNumber=@Parameter
	  ORDER BY DateOfRegistration
END
GO
/****** Object:  StoredProcedure [dbo].[DeviceLogSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceLogSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[DeviceLogSelectCommand]
AS
	SET NOCOUNT ON;
select * from devicelog
' 
END
GO
/****** Object:  StoredProcedure [dbo].[DeviceChargeSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceChargeSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[DeviceChargeSelectCommand]
AS
	SET NOCOUNT ON;
select * from devicecharge
' 
END
GO
/****** Object:  StoredProcedure [dbo].[DeviceChargeDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceChargeDeleteCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[DeviceChargeDeleteCommand]
(
	@Original_DeviceChargeId int,
	@IsNull_DeviceId Int,
	@Original_DeviceId int,
	@IsNull_SerialNumber Int,
	@Original_SerialNumber varchar(50),
	@IsNull_DateTimeOfChargeStart Int,
	@Original_DateTimeOfChargeStart datetime,
	@IsNull_DateTimeOfChargeEnd Int,
	@Original_DateTimeOfChargeEnd datetime
)
AS
	SET NOCOUNT OFF;
DELETE FROM [devicecharge] WHERE (([DeviceChargeId] = @Original_DeviceChargeId) AND ((@IsNull_DeviceId = 1 AND [DeviceId] IS NULL) OR ([DeviceId] = @Original_DeviceId)) AND ((@IsNull_SerialNumber = 1 AND [SerialNumber] IS NULL) OR ([SerialNumber] = @Original_SerialNumber)) AND ((@IsNull_DateTimeOfChargeStart = 1 AND [DateTimeOfChargeStart] IS NULL) OR ([DateTimeOfChargeStart] = @Original_DateTimeOfChargeStart)) AND ((@IsNull_DateTimeOfChargeEnd = 1 AND [DateTimeOfChargeEnd] IS NULL) OR ([DateTimeOfChargeEnd] = @Original_DateTimeOfChargeEnd)))
' 
END
GO
/****** Object:  Table [dbo].[Battery]    Script Date: 08/03/2012 15:12:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Battery]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[Battery](
	[SerialNumber] [varchar](50) COLLATE database_default NOT NULL,
	[CompanyId] [int] NULL,
	[Alias] [varchar](50) COLLATE database_default NULL,
	[KITn] [varchar](50) COLLATE database_default NULL,
	[CHEM] [int] NULL,
	[BatteryStatusTypeId] [int] NULL,
	[BatteryGroupId] [int] NULL,
	[BatteryChargeStateId] [nvarchar](max) COLLATE database_default NULL,
	[RadioFamilyId] [int] NULL,
	[CurrentCharge] [int] NULL,
	[PotentialCapacity] [int] NULL,
	[RatedCapacity] [int] NULL,
	[CapacityRatio] [int] NULL,
	[DateOfManufacture] [datetime] NULL,
	[AgeInDays] [int] NULL,
	[DateOfInitialUse] [datetime] NULL,
	[DaysSinceLastReconditioning] [int] NULL,
	[DaysSinceRemovalFromCharger] [int] NULL,
	[TotalIMPRESChargeCycles] [int] NULL,
	[TotalEstimatedNonIMPRESChargeCycles] [int] NULL,
	[TotalEstimatedNonIMPRESChargeCyclesPrior] [int] NULL,
	[TotalReconditioningCycles] [int] NULL,
	[EstimatedDaysUntilNextReconditioning] [int] NULL,
	[SoftwareVersion] [float] NULL,
	[TemperatureC] [float] NULL,
	[Voltage] [float] NULL,
	[LED] [int] NULL,
	[DateOfRead] [datetime] NULL,
	[RecommendationId] [nvarchar](max) COLLATE database_default NULL,
	[RichTextRecommendations] [nvarchar](max) COLLATE database_default NULL,
	[CA00] [int] NULL,
	[CA10] [int] NULL,
	[CA20] [int] NULL,
	[CA30] [int] NULL,
	[CA40] [int] NULL,
	[CA50] [int] NULL,
	[CA60] [int] NULL,
	[CA70] [int] NULL,
	[CA80] [int] NULL,
	[CA90] [int] NULL,
	[RE00] [int] NULL,
	[RE10] [int] NULL,
	[RE20] [int] NULL,
	[RE30] [int] NULL,
	[RE40] [int] NULL,
	[RE50] [int] NULL,
	[RE60] [int] NULL,
	[RE70] [int] NULL,
	[RE80] [int] NULL,
	[RE90] [int] NULL,
	[ComputerName] [varchar](50) COLLATE database_default NULL,
	[DeviceName] [varchar](250) COLLATE database_default NULL,
	[PocketNumber] [int] NULL,
	[DaysSinceLastRead] [int] NULL,
	[DaysSinceInitialUse] [int] NULL,
	[SNSR] [float] NULL,
	[ICA] [float] NOT NULL,
	[CTS] [int] NULL,
	[DOIU] [int] NULL,
	[WF00] [int] NULL,
	[WF10] [int] NULL,
	[WF20] [int] NULL,
	[WF30] [int] NULL,
	[WF40] [int] NULL,
	[WF50] [int] NULL,
	[WF60] [int] NULL,
	[WF70] [int] NULL,
	[WF80] [int] NULL,
	[WF90] [int] NULL,
	[ETM] [int] NULL,
	[LDAY] [int] NULL,
	[LHR] [int] NULL,
	[LMIN] [int] NULL,
	[FDDp] [int] NULL,
	[DISp] [int] NULL,
	[TRIG] [int] NULL,
	[DOIC] [int] NULL,
	[FM] [bit] NULL,
	[Comment] [nvarchar](max) COLLATE database_default NULL,
	[ChargerLowTemperature] [float] NULL,
	[ChargerHighTemperature] [float] NULL,
	[HID] [int] NULL,
	[ALERTID] [int] NULL,
	[UnsupportedFieldsList] [text] COLLATE database_default NULL,
	[ErrorFieldsList] [text] COLLATE database_default NULL,
	[DateofLastRemove] [datetime] NULL,
	[OverdueThreshold] [int] NULL,
	[Charging] [bit] NULL,
	[DateofInactive] [datetime] NULL,
	[NeedToRead] [bit] NULL,
	[RemainingCapacityRatio] [int] NULL,
	[TIA4950] [bit] NULL,
	[UL2504Div2] [bit] NULL,
	[CSA157] [bit] NULL,
	[ATEX] [bit] NULL,
	[NFPA] [bit] NULL,
	[NFPAContinuousOverTemp] [bit] NULL,
	[NFPACumulativeOverTemp] [bit] NULL,
	[NFPAOverTempCounter] [int] NULL,
	[BatteryTypeID] [int] NULL
 CONSTRAINT [PK_Battery] PRIMARY KEY CLUSTERED 
(
	[SerialNumber] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON)
)
END
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'Battery', N'COLUMN',N'CompanyId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Foreign key to Company Table' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Battery', @level2type=N'COLUMN',@level2name=N'CompanyId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'Battery', N'COLUMN',N'BatteryStatusTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Foreign Key to BatteryStatusType table' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Battery', @level2type=N'COLUMN',@level2name=N'BatteryStatusTypeId'
GO
/****** Object:  View [dbo].[View_BatteryForQuery]    Script Date: 08/03/2012 15:12:54 ******/
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[View_BatteryForQuery]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[View_BatteryForQuery]
AS
SELECT     a.SerialNumber, a.CompanyId, a.Alias, RadioID=IsNull(d.RadioID,''''), RadioAlias=IsNull(d.RadioAlias,''''), LastKnownRadioID=IsNull(e.RadioID,''''), LastKnownRadioAlias=IsNull(e.RadioAlias,''''),
                      a.KITn, a.CHEM, a.BatteryStatusTypeId, a.BatteryGroupId, a.BatteryChargeStateId, a.RadioFamilyId, 
                      a.CurrentCharge, a.PotentialCapacity, a.RatedCapacity, a.CapacityRatio, a.DateOfManufacture, a.AgeInDays, a.DateOfInitialUse, 
                      a.DaysSinceLastReconditioning, a.DaysSinceRemovalFromCharger, a.TotalIMPRESChargeCycles, a.TotalEstimatedNonIMPRESChargeCycles, 
                      a.TotalEstimatedNonIMPRESChargeCyclesPrior, a.TotalReconditioningCycles, a.EstimatedDaysUntilNextReconditioning, a.SoftwareVersion, 
                      a.TemperatureC, a.Voltage, a.LED, a.DateOfRead, a.RecommendationId, a.RichTextRecommendations, a.CA00, a.CA10, a.CA20, a.CA30, a.CA40, a.CA50,
                      a.CA60, a.CA70, a.CA80, a.CA90, a.RE00, a.RE10, a.RE20, a.RE30, a.RE40, a.RE50, a.RE60, a.RE70, a.RE80, a.RE90, a.ComputerName, 
                      a.DeviceName, a.PocketNumber, DATEDIFF(d, a.DateOfRead, CURRENT_TIMESTAMP) AS DaysSinceLastRead, a.DaysSinceInitialUse, a.SNSR, a.ICA, 
                      a.CTS, a.DOIU, a.WF00, a.WF10, a.WF20, a.WF30, a.WF40, a.WF50, a.WF60, a.WF70, a.WF80, a.WF90, a.ETM, a.LDAY, a.LHR, a.LMIN, a.FDDp, 
                      a.DISp, a.TRIG, a.DOIC, a.FM, a.Comment, a.ChargerHighTemperature, a.ChargerLowTemperature, a.HID, a.ALERTID, a.UnsupportedFieldsList, 
					  a.ErrorFieldsList, a.DateofLastRemove
                      , OverdueThreshold = CASE  WHEN a.OverdueThreshold > 0 THEN (a.OverdueThreshold/24) ELSE a.OverdueThreshold END
                      , a.Charging, a.DateofInactive, b.DisplayName AS ComputerAlias, c.DisplayName
                      , a.RemainingCapacityRatio
					  , a.TIA4950, a.UL2504Div2, a.CSA157, a.ATEX
					  		  , a.NFPA ,a.NFPAContinuousOverTemp, a.NFPACumulativeOverTemp, a.NFPAOverTempCounter
							  , a.BatteryTypeID
FROM         dbo.Battery AS a LEFT OUTER JOIN
                          (SELECT DISTINCT ComputerName, DisplayName
                            FROM          dbo.Computer) AS b ON a.ComputerName = b.ComputerName LEFT OUTER JOIN
                          (SELECT DISTINCT ComputerName, DeviceName, DisplayName
                            FROM          dbo.Device) AS c ON a.DeviceName = c.DeviceName and a.ComputerName = c.ComputerName
                          LEFT OUTER JOIN radio AS d ON a.serialnumber=d.batteryserialnumber
                          LEFT OUTER JOIN BatteryLastKnownRadio AS e ON a.serialnumber=e.BatterySerialNumber
'
GO
/****** Object:  StoredProcedure [dbo].[BatteryGroupInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryGroupInsertCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[BatteryGroupInsertCommand]
(
	@GroupName varchar(250)
)
AS
	SET NOCOUNT OFF;
IF ((select GroupName from BatteryGroup where CAST(GroupName as varbinary)= CAST(@GroupName as varbinary)) is Null)
Begin
INSERT INTO [BatteryGroup] ([GroupName]) VALUES (@GroupName);
SELECT BatteryGroupId, GroupName FROM BatteryGroup WHERE (BatteryGroupId = SCOPE_IDENTITY())
End
else
SELECT BatteryGroupId, GroupName FROM BatteryGroup WHERE (BatteryGroupId = SCOPE_IDENTITY())
' 
END
GO
/****** Object:  StoredProcedure [dbo].[BatteryGroupSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryGroupSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[BatteryGroupSelectCommand]
AS
	SET NOCOUNT ON;
select * from BatteryGroup
' 
END
GO
/****** Object:  StoredProcedure [dbo].[BatteryGroupUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryGroupUpdateCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[BatteryGroupUpdateCommand]
(
	@GroupName varchar(250),
	@Original_BatteryGroupId int,
	@IsNull_GroupName Int,
	@Original_GroupName varchar(250),
	@BatteryGroupId int
)
AS
	SET NOCOUNT OFF;
IF ((select GroupName from BatteryGroup where CAST(GroupName as varbinary)= CAST(@GroupName as varbinary)) is Null)
Begin
UPDATE [BatteryGroup] SET [GroupName] = @GroupName WHERE [BatteryGroupId] = @Original_BatteryGroupId;
End
SELECT BatteryGroupId, GroupName FROM BatteryGroup WHERE (BatteryGroupId = @Original_BatteryGroupId)
' 
END
GO
/****** Object:  StoredProcedure [dbo].[BatteryGroupDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryGroupDeleteCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[BatteryGroupDeleteCommand]
(
	@Original_BatteryGroupId int,
	@IsNull_GroupName Int,
	@Original_GroupName varchar(250)
)
AS
	SET NOCOUNT OFF;
IF ((select BatteryGroupId from BatteryGroup where BatteryGroupId=@Original_BatteryGroupId) is not Null)
Begin
DELETE FROM [BatteryGroup] WHERE [BatteryGroupId] = @Original_BatteryGroupId
Update Battery set BatteryGroupId=0 where BatteryGroupId=@Original_BatteryGroupId
end' 
END
GO
/****** Object:  StoredProcedure [dbo].[DeviceSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[DeviceSelectCommand]
AS
	SET NOCOUNT ON;
select * from device
' 
END
GO
/****** Object:  StoredProcedure [dbo].[DeviceUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceUpdateCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[DeviceUpdateCommand]
(
	@DeviceName varchar(250),
	@DisplayName varchar(250),
	@ComputerName varchar(250),
	@IsConnected bit,
	@NumberOfPockets int,
	@Pocket1 varchar(50),
	@Pocket2 varchar(50),
	@Pocket3 varchar(50),
	@Pocket4 varchar(50),
	@Pocket5 varchar(50),
	@Pocket6 varchar(50),
	@Pocket7 varchar(50),
	@Pocket8 varchar(50),
	@Pocket9 varchar(50),
	@Pocket10 varchar(50),
	@Pocket11 varchar(50),
	@Pocket12 varchar(50),
	@Pocket13 varchar(50),
	@Pocket14 varchar(50),
	@Pocket15 varchar(50),
	@Pocket16 varchar(50),
	@Pocket17 varchar(50),
	@Pocket18 varchar(50),
	@Pocket19 varchar(50),
	@Pocket20 varchar(50),
	@Pocket21 varchar(50),
	@Pocket22 varchar(50),
	@Pocket23 varchar(50),
	@Pocket24 varchar(50),
	@Pocket25 varchar(50),
	@Pocket26 varchar(50),
	@Pocket27 varchar(50),
	@Pocket28 varchar(50),
	@Pocket29 varchar(50),
	@Pocket30 varchar(50),
	@Pocket31 varchar(50),
	@DateOfLastHeartbeat datetime,
	@Original_DeviceId int,
	@Original_DeviceName varchar(250),
	@IsNull_DisplayName Int,
	@Original_DisplayName varchar(250),
	@Original_ComputerName varchar(250),
	@IsNull_IsConnected Int,
	@Original_IsConnected bit,
	@IsNull_NumberOfPockets Int,
	@Original_NumberOfPockets int,
	@IsNull_Pocket1 Int,
	@Original_Pocket1 varchar(50),
	@IsNull_Pocket2 Int,
	@Original_Pocket2 varchar(50),
	@IsNull_Pocket3 Int,
	@Original_Pocket3 varchar(50),
	@IsNull_Pocket4 Int,
	@Original_Pocket4 varchar(50),
	@IsNull_Pocket5 Int,
	@Original_Pocket5 varchar(50),
	@IsNull_Pocket6 Int,
	@Original_Pocket6 varchar(50),
	@IsNull_Pocket7 Int,
	@Original_Pocket7 varchar(50),
	@IsNull_Pocket8 Int,
	@Original_Pocket8 varchar(50),
	@IsNull_Pocket9 Int,
	@Original_Pocket9 varchar(50),
	@IsNull_Pocket10 Int,
	@Original_Pocket10 varchar(50),
	@IsNull_Pocket11 Int,
	@Original_Pocket11 varchar(50),
	@IsNull_Pocket12 Int,
	@Original_Pocket12 varchar(50),
	@IsNull_Pocket13 Int,
	@Original_Pocket13 varchar(50),
	@IsNull_Pocket14 Int,
	@Original_Pocket14 varchar(50),
	@IsNull_Pocket15 Int,
	@Original_Pocket15 varchar(50),
	@IsNull_Pocket16 Int,
	@Original_Pocket16 varchar(50),
	@IsNull_Pocket17 Int,
	@Original_Pocket17 varchar(50),
	@IsNull_Pocket18 Int,
	@Original_Pocket18 varchar(50),
	@IsNull_Pocket19 Int,
	@Original_Pocket19 varchar(50),
	@IsNull_Pocket20 Int,
	@Original_Pocket20 varchar(50),
	@IsNull_Pocket21 Int,
	@Original_Pocket21 varchar(50),
	@IsNull_Pocket22 Int,
	@Original_Pocket22 varchar(50),
	@IsNull_Pocket23 Int,
	@Original_Pocket23 varchar(50),
	@IsNull_Pocket24 Int,
	@Original_Pocket24 varchar(50),
	@IsNull_Pocket25 Int,
	@Original_Pocket25 varchar(50),
	@IsNull_Pocket26 Int,
	@Original_Pocket26 varchar(50),
	@IsNull_Pocket27 Int,
	@Original_Pocket27 varchar(50),
	@IsNull_Pocket28 Int,
	@Original_Pocket28 varchar(50),
	@IsNull_Pocket29 Int,
	@Original_Pocket29 varchar(50),
	@IsNull_Pocket30 Int,
	@Original_Pocket30 varchar(50),
	@IsNull_Pocket31 Int,
	@Original_Pocket31 varchar(50),
	@IsNull_DateOfLastHeartbeat Int,
	@Original_DateOfLastHeartbeat datetime,
	@DeviceId int,
    @DeviceType nvarchar(max),
    @DeviceStatus int,
    @DeviceInfo varchar(max),
	@DisconnectedTime datetime,
	@ConnectedTime datetime,
	@ComputerAlias nvarchar(50)
)
AS
	SET NOCOUNT OFF;
UPDATE [device] SET [DeviceName] = @DeviceName, [DisplayName] = @DisplayName, [ComputerName] = @ComputerName, [IsConnected] = @IsConnected, [NumberOfPockets] = @NumberOfPockets, [Pocket1] = @Pocket1, [Pocket2] = @Pocket2, [Pocket3] = @Pocket3, [Pocket4] = @Pocket4, [Pocket5] = @Pocket5, [Pocket6] = @Pocket6, [Pocket7] = @Pocket7, [Pocket8] = @Pocket8, [Pocket9] = @Pocket9, [Pocket10] = @Pocket10, [Pocket11] = @Pocket11, [Pocket12] = @Pocket12, [Pocket13] = @Pocket13, [Pocket14] = @Pocket14, [Pocket15] = @Pocket15, [Pocket16] = @Pocket16, [Pocket17] = @Pocket17, [Pocket18] = @Pocket18, [Pocket19] = @Pocket19, [Pocket20] = @Pocket20, [Pocket21] = @Pocket21, [Pocket22] = @Pocket22, [Pocket23] = @Pocket23, [Pocket24] = @Pocket24, [Pocket25] = @Pocket25, [Pocket26] = @Pocket26, [Pocket27] = @Pocket27, [Pocket28] = @Pocket28, [Pocket29] = @Pocket29, [Pocket30] = @Pocket30, [Pocket31] = @Pocket31, [DateOfLastHeartbeat] = @DateOfLastHeartbeat, [DeviceType]=@DeviceType, [DeviceStatus]=@DeviceStatus, [DeviceInfo]=@DeviceInfo, [DisconnectedTime]=@DisconnectedTime, [ConnectedTime]=@ConnectedTime, [ComputerAlias]=@ComputerAlias WHERE [DeviceId] = @Original_DeviceId;
	
SELECT * FROM Device WHERE (DeviceId = @Original_DeviceId)
' 
END
GO
/****** Object:  StoredProcedure [dbo].[DeviceDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceDeleteCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[DeviceDeleteCommand]
(
	@Original_DeviceId int,
	@Original_DeviceName varchar(250),
	@IsNull_DisplayName Int,
	@Original_DisplayName varchar(250),
	@Original_ComputerName varchar(250),
	@IsNull_IsConnected Int,
	@Original_IsConnected bit,
	@IsNull_NumberOfPockets Int,
	@Original_NumberOfPockets int,
	@IsNull_Pocket1 Int,
	@Original_Pocket1 varchar(50),
	@IsNull_Pocket2 Int,
	@Original_Pocket2 varchar(50),
	@IsNull_Pocket3 Int,
	@Original_Pocket3 varchar(50),
	@IsNull_Pocket4 Int,
	@Original_Pocket4 varchar(50),
	@IsNull_Pocket5 Int,
	@Original_Pocket5 varchar(50),
	@IsNull_Pocket6 Int,
	@Original_Pocket6 varchar(50),
	@IsNull_Pocket7 Int,
	@Original_Pocket7 varchar(50),
	@IsNull_Pocket8 Int,
	@Original_Pocket8 varchar(50),
	@IsNull_Pocket9 Int,
	@Original_Pocket9 varchar(50),
	@IsNull_Pocket10 Int,
	@Original_Pocket10 varchar(50),
	@IsNull_Pocket11 Int,
	@Original_Pocket11 varchar(50),
	@IsNull_Pocket12 Int,
	@Original_Pocket12 varchar(50),
	@IsNull_Pocket13 Int,
	@Original_Pocket13 varchar(50),
	@IsNull_Pocket14 Int,
	@Original_Pocket14 varchar(50),
	@IsNull_Pocket15 Int,
	@Original_Pocket15 varchar(50),
	@IsNull_Pocket16 Int,
	@Original_Pocket16 varchar(50),
	@IsNull_Pocket17 Int,
	@Original_Pocket17 varchar(50),
	@IsNull_Pocket18 Int,
	@Original_Pocket18 varchar(50),
	@IsNull_Pocket19 Int,
	@Original_Pocket19 varchar(50),
	@IsNull_Pocket20 Int,
	@Original_Pocket20 varchar(50),
	@IsNull_Pocket21 Int,
	@Original_Pocket21 varchar(50),
	@IsNull_Pocket22 Int,
	@Original_Pocket22 varchar(50),
	@IsNull_Pocket23 Int,
	@Original_Pocket23 varchar(50),
	@IsNull_Pocket24 Int,
	@Original_Pocket24 varchar(50),
	@IsNull_Pocket25 Int,
	@Original_Pocket25 varchar(50),
	@IsNull_Pocket26 Int,
	@Original_Pocket26 varchar(50),
	@IsNull_Pocket27 Int,
	@Original_Pocket27 varchar(50),
	@IsNull_Pocket28 Int,
	@Original_Pocket28 varchar(50),
	@IsNull_Pocket29 Int,
	@Original_Pocket29 varchar(50),
	@IsNull_Pocket30 Int,
	@Original_Pocket30 varchar(50),
	@IsNull_Pocket31 Int,
	@Original_Pocket31 varchar(50),
	@IsNull_DateOfLastHeartbeat Int,
	@Original_DateOfLastHeartbeat datetime
)
AS
	SET NOCOUNT OFF;
DELETE FROM [device] WHERE (([DeviceId] = @Original_DeviceId) AND ([DeviceName] = @Original_DeviceName) AND ((@IsNull_DisplayName = 1 AND [DisplayName] IS NULL) OR ([DisplayName] = @Original_DisplayName)) AND ([ComputerName] = @Original_ComputerName) AND ((@IsNull_IsConnected = 1 AND [IsConnected] IS NULL) OR ([IsConnected] = @Original_IsConnected)) AND ((@IsNull_NumberOfPockets = 1 AND [NumberOfPockets] IS NULL) OR ([NumberOfPockets] = @Original_NumberOfPockets)) AND ((@IsNull_Pocket1 = 1 AND [Pocket1] IS NULL) OR ([Pocket1] = @Original_Pocket1)) AND ((@IsNull_Pocket2 = 1 AND [Pocket2] IS NULL) OR ([Pocket2] = @Original_Pocket2)) AND ((@IsNull_Pocket3 = 1 AND [Pocket3] IS NULL) OR ([Pocket3] = @Original_Pocket3)) AND ((@IsNull_Pocket4 = 1 AND [Pocket4] IS NULL) OR ([Pocket4] = @Original_Pocket4)) AND ((@IsNull_Pocket5 = 1 AND [Pocket5] IS NULL) OR ([Pocket5] = @Original_Pocket5)) AND ((@IsNull_Pocket6 = 1 AND [Pocket6] IS NULL) OR ([Pocket6] = @Original_Pocket6)) AND ((@IsNull_Pocket7 = 1 AND [Pocket7] IS NULL) OR ([Pocket7] = @Original_Pocket7)) AND ((@IsNull_Pocket8 = 1 AND [Pocket8] IS NULL) OR ([Pocket8] = @Original_Pocket8)) AND ((@IsNull_Pocket9 = 1 AND [Pocket9] IS NULL) OR ([Pocket9] = @Original_Pocket9)) AND ((@IsNull_Pocket10 = 1 AND [Pocket10] IS NULL) OR ([Pocket10] = @Original_Pocket10)) AND ((@IsNull_Pocket11 = 1 AND [Pocket11] IS NULL) OR ([Pocket11] = @Original_Pocket11)) AND ((@IsNull_Pocket12 = 1 AND [Pocket12] IS NULL) OR ([Pocket12] = @Original_Pocket12)) AND ((@IsNull_Pocket13 = 1 AND [Pocket13] IS NULL) OR ([Pocket13] = @Original_Pocket13)) AND ((@IsNull_Pocket14 = 1 AND [Pocket14] IS NULL) OR ([Pocket14] = @Original_Pocket14)) AND ((@IsNull_Pocket15 = 1 AND [Pocket15] IS NULL) OR ([Pocket15] = @Original_Pocket15)) AND ((@IsNull_Pocket16 = 1 AND [Pocket16] IS NULL) OR ([Pocket16] = @Original_Pocket16)) AND ((@IsNull_Pocket17 = 1 AND [Pocket17] IS NULL) OR ([Pocket17] = @Original_Pocket17)) AND ((@IsNull_Pocket18 = 1 AND [Pocket18] IS NULL) OR ([Pocket18] = @Original_Pocket18)) AND ((@IsNull_Pocket19 = 1 AND [Pocket19] IS NULL) OR ([Pocket19] = @Original_Pocket19)) AND ((@IsNull_Pocket20 = 1 AND [Pocket20] IS NULL) OR ([Pocket20] = @Original_Pocket20)) AND ((@IsNull_Pocket21 = 1 AND [Pocket21] IS NULL) OR ([Pocket21] = @Original_Pocket21)) AND ((@IsNull_Pocket22 = 1 AND [Pocket22] IS NULL) OR ([Pocket22] = @Original_Pocket22)) AND ((@IsNull_Pocket23 = 1 AND [Pocket23] IS NULL) OR ([Pocket23] = @Original_Pocket23)) AND ((@IsNull_Pocket24 = 1 AND [Pocket24] IS NULL) OR ([Pocket24] = @Original_Pocket24)) AND ((@IsNull_Pocket25 = 1 AND [Pocket25] IS NULL) OR ([Pocket25] = @Original_Pocket25)) AND ((@IsNull_Pocket26 = 1 AND [Pocket26] IS NULL) OR ([Pocket26] = @Original_Pocket26)) AND ((@IsNull_Pocket27 = 1 AND [Pocket27] IS NULL) OR ([Pocket27] = @Original_Pocket27)) AND ((@IsNull_Pocket28 = 1 AND [Pocket28] IS NULL) OR ([Pocket28] = @Original_Pocket28)) AND ((@IsNull_Pocket29 = 1 AND [Pocket29] IS NULL) OR ([Pocket29] = @Original_Pocket29)) AND ((@IsNull_Pocket30 = 1 AND [Pocket30] IS NULL) OR ([Pocket30] = @Original_Pocket30)) AND ((@IsNull_Pocket31 = 1 AND [Pocket31] IS NULL) OR ([Pocket31] = @Original_Pocket31)) AND ((@IsNull_DateOfLastHeartbeat = 1 AND [DateOfLastHeartbeat] IS NULL) OR ([DateOfLastHeartbeat] = @Original_DateOfLastHeartbeat)))
' 
END
GO
/****** Object:  StoredProcedure [dbo].[DeviceInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceInsertCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[DeviceInsertCommand]
(
	@DeviceName varchar(250),
	@DisplayName varchar(250),
	@ComputerName varchar(250),
	@IsConnected bit,
	@NumberOfPockets int,
	@Pocket1 varchar(50),
	@Pocket2 varchar(50),
	@Pocket3 varchar(50),
	@Pocket4 varchar(50),
	@Pocket5 varchar(50),
	@Pocket6 varchar(50),
	@Pocket7 varchar(50),
	@Pocket8 varchar(50),
	@Pocket9 varchar(50),
	@Pocket10 varchar(50),
	@Pocket11 varchar(50),
	@Pocket12 varchar(50),
	@Pocket13 varchar(50),
	@Pocket14 varchar(50),
	@Pocket15 varchar(50),
	@Pocket16 varchar(50),
	@Pocket17 varchar(50),
	@Pocket18 varchar(50),
	@Pocket19 varchar(50),
	@Pocket20 varchar(50),
	@Pocket21 varchar(50),
	@Pocket22 varchar(50),
	@Pocket23 varchar(50),
	@Pocket24 varchar(50),
	@Pocket25 varchar(50),
	@Pocket26 varchar(50),
	@Pocket27 varchar(50),
	@Pocket28 varchar(50),
	@Pocket29 varchar(50),
	@Pocket30 varchar(50),
	@Pocket31 varchar(50),
	@DateOfLastHeartbeat datetime,
    @DeviceType nvarchar(max),
    @DeviceStatus int,
    @DeviceInfo varchar(max),
	@DisconnectedTime datetime,
	@ConnectedTime datetime,
	@ComputerAlias nvarchar(50)
)
AS
	SET NOCOUNT OFF;
INSERT INTO [device] ([DeviceName], [DisplayName], [ComputerName], [IsConnected], [NumberOfPockets], [Pocket1], [Pocket2], [Pocket3], [Pocket4], [Pocket5], [Pocket6], [Pocket7], [Pocket8], [Pocket9], [Pocket10], [Pocket11], [Pocket12], [Pocket13], [Pocket14], [Pocket15], [Pocket16], [Pocket17], [Pocket18], [Pocket19], [Pocket20], [Pocket21], [Pocket22], [Pocket23], [Pocket24], [Pocket25], [Pocket26], [Pocket27], [Pocket28], [Pocket29], [Pocket30], [Pocket31], [DateOfLastHeartbeat], [DeviceType], [DeviceStatus], [DeviceInfo], [DisconnectedTime], [ConnectedTime], [ComputerAlias]) VALUES (@DeviceName, @DisplayName, @ComputerName, @IsConnected, @NumberOfPockets, @Pocket1, @Pocket2, @Pocket3, @Pocket4, @Pocket5, @Pocket6, @Pocket7, @Pocket8, @Pocket9, @Pocket10, @Pocket11, @Pocket12, @Pocket13, @Pocket14, @Pocket15, @Pocket16, @Pocket17, @Pocket18, @Pocket19, @Pocket20, @Pocket21, @Pocket22, @Pocket23, @Pocket24, @Pocket25, @Pocket26, @Pocket27, @Pocket28, @Pocket29, @Pocket30, @Pocket31, @DateOfLastHeartbeat, @DeviceType, @DeviceStatus, @DeviceInfo, @DisconnectedTime, @ConnectedTime, @ComputerAlias);
	
SELECT * FROM Device WHERE (DeviceId = SCOPE_IDENTITY())
' 
END
GO
/****** Object:  StoredProcedure [dbo].[PocketUtilizationReport]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PocketUtilizationReport]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[PocketUtilizationReport] 
	-- Add the parameters for the stored procedure here
	@rowstart int,
    @rowcount int,
    @parameter nvarchar(max)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    -- Insert statements for procedure here
    if(@parameter = ''Day'')
	SELECT ComputerName, DeviceName, PocketNumber, count(PocketNumber) as CountOfUse from BatteryHistory where DateDiff(Hour,DateOfRead,GetDate())<24 AND (BatteryHistory.devicename <> ''Motorola IMPRES OTA'' AND BatteryHistory.devicename <> ''Motorola IMPRES UNS'') group by ComputerName, DeviceName,PocketNumber
    else if(@parameter=''Week'')
    SELECT ComputerName, DeviceName, PocketNumber, count(PocketNumber) as CountOfUse from BatteryHistory where DateDiff(Day,DateOfRead,GetDate())<7 AND (BatteryHistory.devicename <> ''Motorola IMPRES OTA'' AND BatteryHistory.devicename <> ''Motorola IMPRES UNS'') group by ComputerName, DeviceName,PocketNumber
    else if(@parameter=''Month'')
    SELECT BatteryHistory.ComputerName,Computer.DisplayName as ComputerAlias, BatteryHistory.DeviceName,Device.DisplayName, PocketNumber, count(PocketNumber) as CountOfUse
    from BatteryHistory LEFT OUTER JOIN 
    (SELECT DISTINCT ComputerName, DisplayName
		FROM          dbo.Computer) AS Computer ON BatteryHistory.ComputerName = Computer.ComputerName LEFT OUTER JOIN
	(SELECT DISTINCT ComputerName, DeviceName, DisplayName
		FROM          dbo.Device) AS Device ON BatteryHistory.DeviceName = Device.DeviceName and BatteryHistory.ComputerName = Device.ComputerName
	where DateDiff(Day,Dateadd("D",-60,GetDate()),DateOfRead)>0 and DateOfRead<GetDate() AND (BatteryHistory.devicename <> ''Motorola IMPRES OTA'' AND BatteryHistory.devicename <> ''Motorola IMPRES UNS'') group by BatteryHistory.ComputerName,Computer.DisplayName, BatteryHistory.DeviceName,Device.DisplayName,PocketNumber

END
' 
END
GO
/****** Object:  StoredProcedure [dbo].[BatteryDeleteAll]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryDeleteAll]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[BatteryDeleteAll] 
	@parameter nvarchar(max),
    @rowcount int,
    @rowstart int
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
    DELETE FROM BatteryHistory
    DELETE FROM BATTERY
	
END
' 
END
GO
/****** Object:  StoredProcedure [dbo].[BatteryHistorySelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryHistorySelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[BatteryHistorySelectCommand]
AS
	SET NOCOUNT ON;
select * from batteryhistory
' 
END
GO
/****** Object:  StoredProcedure [dbo].[BatteryHistoryDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryHistoryDeleteCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[BatteryHistoryDeleteCommand] 
	@SerialNumber varchar(max) 
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	Delete from BatteryHistory where SerialNumber = @SerialNumber
END
' 
END
GO
/****** Object:  StoredProcedure [dbo].[FindBatteryHistoryBySerialNumber]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FindBatteryHistoryBySerialNumber]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[FindBatteryHistoryBySerialNumber]
(
	@serialnumber varchar(50)
)
AS
	SET NOCOUNT ON;
select * from batteryhistory where serialnumber=@serialnumber
' 
END
GO
/****** Object:  StoredProcedure [dbo].[BatteryHistoryInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryHistoryInsertCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[BatteryHistoryInsertCommand]
(
	@SerialNumber varchar(50),
	@DateOfRead datetime,
	@CapacityRatio int,
    @ComputerName nvarchar(max),
    @DeviceName nvarchar(max),
    @PocketNumber int
)
AS
	SET NOCOUNT OFF;
INSERT INTO [batteryhistory] ([SerialNumber], [DateOfRead], [CapacityRatio], [ComputerName], [DeviceName], [PocketNumber]) VALUES (@SerialNumber, @DateOfRead, @CapacityRatio, @ComputerName, @DeviceName, @PocketNumber)
' 
END
GO
/****** Object:  StoredProcedure [dbo].[AlertInfoSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AlertInfoSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'Create PROCEDURE [dbo].[AlertInfoSelectCommand]
@Language nvarchar(max)
AS
	SET NOCOUNT ON;
if exists (select * from Translation where [Language]=@Language)
Select AlertId, T.Value as [Name] from AlertInfo left join (select * from Translation where [Language]=@Language) as T on AlertInfo.Name=T.English
else
Select * From AlertInfo 

' 
END
GO
/****** Object:  StoredProcedure [dbo].[ComputerUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ComputerUpdateCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ComputerUpdateCommand]
(
	@ComputerName varchar(250),
	@DisplayName varchar(250),
	@IsConnected bit,
	@DateOfLastHeartbeat datetime,
	@Original_ComputerId int,
	@IsNull_ComputerName Int,
	@Original_ComputerName varchar(250),
	@IsNull_DisplayName Int,
	@Original_DisplayName varchar(250),
	@IsNull_IsConnected Int,
	@Original_IsConnected bit,
	@IsNull_DateOfLastHeartbeat Int,
	@Original_DateOfLastHeartbeat datetime,
	@ComputerId int
)
AS
	SET NOCOUNT OFF;
UPDATE [computer] SET [ComputerName] = @ComputerName, [DisplayName] = @DisplayName, [IsConnected] = @IsConnected, [DateOfLastHeartbeat] = @DateOfLastHeartbeat WHERE [ComputerId] = @Original_ComputerId;
	
SELECT ComputerId, ComputerName, DisplayName, IsConnected, DateOfLastHeartbeat FROM Computer WHERE (ComputerId = @Original_ComputerId)
' 
END
GO
/****** Object:  StoredProcedure [dbo].[ComputerSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ComputerSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ComputerSelectCommand]
AS
	SET NOCOUNT ON;
select * from computer
' 
END
GO
/****** Object:  StoredProcedure [dbo].[ComputerInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ComputerInsertCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ComputerInsertCommand]
(
	@ComputerName varchar(250),
	@DisplayName varchar(250),
	@IsConnected bit,
	@DateOfLastHeartbeat datetime
)
AS
	SET NOCOUNT OFF;
INSERT INTO [computer] ([ComputerName], [DisplayName], [IsConnected], [DateOfLastHeartbeat]) VALUES (@ComputerName, @DisplayName, @IsConnected, @DateOfLastHeartbeat);
	
SELECT ComputerId, ComputerName, DisplayName, IsConnected, DateOfLastHeartbeat FROM Computer WHERE (ComputerId = SCOPE_IDENTITY())
' 
END
GO
/****** Object:  StoredProcedure [dbo].[ComputerDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ComputerDeleteCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ComputerDeleteCommand]
(
	@Original_ComputerId int,
	@IsNull_ComputerName Int,
	@Original_ComputerName varchar(250),
	@IsNull_DisplayName Int,
	@Original_DisplayName varchar(250),
	@IsNull_IsConnected Int,
	@Original_IsConnected bit,
	@IsNull_DateOfLastHeartbeat Int,
	@Original_DateOfLastHeartbeat datetime
)
AS
	SET NOCOUNT OFF;
DELETE FROM [computer] WHERE (([ComputerId] = @Original_ComputerId) AND ((@IsNull_ComputerName = 1 AND [ComputerName] IS NULL) OR ([ComputerName] = @Original_ComputerName)) AND ((@IsNull_DisplayName = 1 AND [DisplayName] IS NULL) OR ([DisplayName] = @Original_DisplayName)) AND ((@IsNull_IsConnected = 1 AND [IsConnected] IS NULL) OR ([IsConnected] = @Original_IsConnected)) AND ((@IsNull_DateOfLastHeartbeat = 1 AND [DateOfLastHeartbeat] IS NULL) OR ([DateOfLastHeartbeat] = @Original_DateOfLastHeartbeat)))
' 
END
GO
/****** Object:  StoredProcedure [dbo].[CompanyDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CompanyDeleteCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[CompanyDeleteCommand]
(
	@Original_CompanyId int,
	@IsNull_EOSLCapacityPercent Int,
	@Original_EOSLCapacityPercent float,
	@IsNull_EOSLAgeInDays Int,
	@Original_EOSLAgeInDays int
)
AS
	SET NOCOUNT OFF;
DELETE FROM [Company] WHERE (([CompanyId] = @Original_CompanyId) AND ((@IsNull_EOSLCapacityPercent = 1 AND [EOSLCapacityPercent] IS NULL) OR ([EOSLCapacityPercent] = @Original_EOSLCapacityPercent)) AND ((@IsNull_EOSLAgeInDays = 1 AND [EOSLAgeInDays] IS NULL) OR ([EOSLAgeInDays] = @Original_EOSLAgeInDays)))
' 
END
GO
/****** Object:  StoredProcedure [dbo].[CompanyInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CompanyInsertCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[CompanyInsertCommand]
(
	@CompanyId int,
	@Name text,
	@EOSLCapacityPercent float,
	@EOSLAgeInDays int,
    @MissingDaysThreshold int,
    @OverdueThreshold int,
    @PurgeThreshold int
    , @OTAThreshold int
    , @RHOT int
    , @HistoryPurgeThreshold int
)
AS
	SET NOCOUNT OFF;
INSERT INTO [Company] ([CompanyId], [Name], [EOSLCapacityPercent], [EOSLAgeInDays],[MissingDaysThreshold],[OverdueThreshold],[PurgeThreshold],[OTAThreshold],[RHOT],[HistoryPurgeThreshold]) 
VALUES (@CompanyId, @Name, @EOSLCapacityPercent, @EOSLAgeInDays,@MissingDaysThreshold, @OverdueThreshold,@PurgeThreshold, @OTAThreshold, @RHOT, @HistoryPurgeThreshold);
	
SELECT * FROM Company WHERE (CompanyId = @CompanyId)
' 
END
GO
/****** Object:  StoredProcedure [dbo].[CompanySelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CompanySelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[CompanySelectCommand]
AS
	SET NOCOUNT ON;
select * from Company
' 
END
GO
/****** Object:  UserDefinedFunction [dbo].[GetOverdueThreshold]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetOverdueThreshold]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date, ,>
-- Description:	<Description, ,>
-- =============================================
CREATE FUNCTION [dbo].[GetOverdueThreshold] 
(
	-- Add the parameters for the function here
	@OverdueThreshold int,
    @CompanyId int
)
RETURNS int
AS
BEGIN
	if(@OverdueThreshold is not null)
      return @OverdueThreshold
    Declare @tmpOverdueThreshold int
    set @tmpOverdueThreshold=(select OverdueThreshold from Company where CompanyId = @CompanyId)
    return @tmpOverdueThreshold
END
' 
END
GO
/****** Object:  UserDefinedFunction [dbo].[RecommendationExented]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RecommendationExented]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date, ,>
-- Description:	<Description, ,>
-- =============================================
CREATE FUNCTION [dbo].[RecommendationExented] 
(
    @CompanyId int,
	@RecommendationId nvarchar(50),
    @DateofRead datetime,
    @CapacityRatio int,
    @AgeInDays int
)
RETURNS nvarchar(max)
AS
BEGIN
    if(@RecommendationId is null)
       set @RecommendationId=''0''
    Begin
    if(@CapacityRatio<(SELECT EOSLCapacityPercent FROM Company WHERE  CompanyId = @CompanyId))
     Begin
      if(@RecommendationId=''0'')
        set @RecommendationId=''4''
      else if(Patindex(''%4%'',@RecommendationId)=0)       
        set @RecommendationId=@RecommendationId+''+4''
     End
    else
     Begin
      if(Patindex(''%+4%'',@RecommendationId)<>0)
        set @RecommendationId=Replace(@RecommendationId,''+4'','''')
      if(Patindex(''%4+%'',@RecommendationId)<>0)
        set @RecommendationId=Replace(@RecommendationId,''4+'','''')
      if(Patindex(''%4%'',@RecommendationId)<>0)
        set @RecommendationId=Replace(@RecommendationId,''4'',''0'')
     end
    if(@AgeInDays>(SELECT EOSLAgeInDays FROM Company WHERE  CompanyId = @CompanyId))
      Begin
       if(@RecommendationId=''0'')
        set @RecommendationId=''5''
       else if(Patindex(''%5%'',@RecommendationId)=0)
        set @RecommendationId=@RecommendationId+''+5''
      End
    else
     Begin
      if(Patindex(''%+5%'',@RecommendationId)<>0)
        set @RecommendationId=Replace(@RecommendationId,''+5'','''')
      if(Patindex(''%5+%'',@RecommendationId)<>0)
        set @RecommendationId=Replace(@RecommendationId,''5+'','''')
      if(Patindex(''%5%'',@RecommendationId)<>0)
        set @RecommendationId=Replace(@RecommendationId,''5'',''0'')
     end
    if(DATEDIFF(d, @DateOfRead, CURRENT_TIMESTAMP) > (SELECT MissingDaysThreshold FROM Company WHERE  CompanyId = @CompanyId ) )
      Begin
      if(@RecommendationId=''0'')
       set @RecommendationId=''6''
      else if(Patindex(''%6%'',@RecommendationId)=0)
       set @RecommendationId=@RecommendationId+''+6''
      End
    else
     Begin
      if(Patindex(''%+6%'',@RecommendationId)<>0)
        set @RecommendationId=Replace(@RecommendationId,''+6'','''')
      if(Patindex(''%6+%'',@RecommendationId)<>0)
        set @RecommendationId=Replace(@RecommendationId,''6+'','''')
      if(Patindex(''%6%'',@RecommendationId)<>0)
        set @RecommendationId=Replace(@RecommendationId,''6'',''0'')
     end
    end
	RETURN @RecommendationId

END
' 
END
GO
/****** Object:  UserDefinedFunction [dbo].[RecommendationDetails]    Script Date: 08/03/2012 18:05:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RecommendationDetails]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date, ,>
-- Description:	<Description, ,>
-- =============================================
CREATE FUNCTION [dbo].[RecommendationDetails] 
(
      @RecommendationId nvarchar(50)
)
RETURNS nvarchar(max)
AS
BEGIN
      Declare @RecommendationText nvarchar(max)
      Declare @RecommendationId_Len int, @Length int
      SET @RecommendationText = ''''

      SET @RecommendationId = REPLACE(@RecommendationId, ''+'', '''')
      SET @RecommendationId_Len = Len(@RecommendationId)
      SET @Length = @RecommendationId_Len

      IF (@RecommendationId = 0)
            SELECT @RecommendationText = ''''
      ELSE
      BEGIN
            WHILE (@Length > 0)
            BEGIN
                  IF @RecommendationText = ''''
                        SELECT @RecommendationText = Text FROM RecommendationType WHERE RecommendationId = CONVERT(INT, SUBSTRING ( @RecommendationId ,@RecommendationId_Len-@Length+1 , 1 ))
                  ELSE
                       SELECT @RecommendationText = @RecommendationText + CHAR(13) + CHAR(10) + Text FROM RecommendationType WHERE RecommendationId = CONVERT(INT, SUBSTRING ( @RecommendationId ,@RecommendationId_Len-@Length+1 , 1 ))
                  
                  IF (@Length = 1)
                        BREAK
                  ELSE
                        SET @Length = @Length - 1
                        CONTINUE
            END
      END

      RETURN @RecommendationText

END

' 
END
GO
/****** Object:  StoredProcedure [dbo].[PurchaseReport]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PurchaseReport]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[PurchaseReport] 
        -- Add the parameters for the stored procedure here
        @parameter nvarchar(max),
    @rowstart int,
    @rowcount int
AS
BEGIN 
    SET NOCOUNT ON;
    Declare @tempTable table(KITn nvarchar(max) COLLATE database_default, RadioFamilyId int, CHEM int, FM bit, RatedCapacity int, CountOfKITn int, TIA4950 bit, UL2504Div2 bit, CSA157 bit, ATEX bit, NFPA bit)
   
    insert into @tempTable select KITn, RadioFamilyId, CHEM, FM, RatedCapacity, count(KITn) as CountOfKITn, TIA4950, UL2504Div2, CSA157, ATEX, NFPA from Battery where (CapacityRatio < (SELECT EOSLCapacityPercent FROM Company WHERE  CompanyId = 1 ) 
    or  AgeInDays  > (SELECT EOSLAgeInDays FROM Company WHERE  CompanyId = 1 ) ) and  BatteryStatusTypeId <> 0 group by KITn,RadioFamilyId, CHEM, FM, RatedCapacity, TIA4950, UL2504Div2, CSA157, ATEX, NFPA
   
    select top(@rowcount) KITn, RadioFamilyId,CHEM,FM, RatedCapacity, CountOfKITn, TIA4950, UL2504Div2, CSA157, ATEX from @tempTable as A where KITn not in (select top(@rowstart) KITn from @tempTable as B order by KITn) order by KITn
END
--BEGIN 
--    SET NOCOUNT ON;
--    Declare @tempTable table(KITn nvarchar(max) COLLATE database_default, RadioFamilyId int, CHEM int, FM bit, RatedCapacity int, CountOfKITn int)
--   
--    insert into @tempTable select KITn, RadioFamilyId, CHEM, FM, RatedCapacity, count(KITn) as CountOfKITn from Battery where CapacityRatio < (SELECT EOSLCapacityPercent FROM Company WHERE  CompanyId = 1 ) 
--    or  DATEDIFF(d, DateOfManufacture, CURRENT_TIMESTAMP)  > (SELECT EOSLAgeInDays FROM Company WHERE  CompanyId = 1 ) and  BatteryStatusTypeId <> 0 group by KITn,RadioFamilyId, CHEM, FM, RatedCapacity
--   
--    select top(@rowcount) KITn, RadioFamilyId, CHEM, FM, RatedCapacity, CountOfKITn from @tempTable as A where KITn not in (select top(@rowstart) KITn from @tempTable as B order by KITn) order by KITn
--END
' 
END
GO
/****** Object:  StoredProcedure [dbo].[LocationDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[LocationDeleteCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[LocationDeleteCommand]
(
	@Original_Name varchar(50),
	@IsNull_IsConnected Int,
	@Original_IsConnected bit
)
AS
	SET NOCOUNT OFF;
DELETE FROM [Location] WHERE (([Name] = @Original_Name) AND ((@IsNull_IsConnected = 1 AND [IsConnected] IS NULL) OR ([IsConnected] = @Original_IsConnected)))
' 
END
GO
/****** Object:  StoredProcedure [dbo].[LocationSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[LocationSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[LocationSelectCommand]
AS
	SET NOCOUNT ON;
Select * From Location
' 
END
GO
/****** Object:  StoredProcedure [dbo].[LocationSelectByName]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[LocationSelectByName]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[LocationSelectByName]
(
	@Name text
)
AS
	SET NOCOUNT ON;
select * from Location where Name Like @Name
' 
END
GO
/****** Object:  StoredProcedure [dbo].[LocationInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[LocationInsertCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[LocationInsertCommand]
(
	@Name varchar(50),
	@IsConnected bit
)
AS
	SET NOCOUNT OFF;
INSERT INTO [Location] ([Name], [IsConnected]) VALUES (@Name, @IsConnected);
	
SELECT Name, IsConnected FROM Location WHERE (Name = @Name)
' 
END
GO
/****** Object:  StoredProcedure [dbo].[LocationUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[LocationUpdateCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[LocationUpdateCommand]
(
	@Name varchar(50),
	@IsConnected bit,
	@Original_Name varchar(50),
	@IsNull_IsConnected Int,
	@Original_IsConnected bit
)
AS
	SET NOCOUNT OFF;
UPDATE [Location] SET [Name] = @Name, [IsConnected] = @IsConnected WHERE [Name] = @Original_Name;
	
SELECT Name, IsConnected FROM Location WHERE (Name = @Original_Name)
' 
END
GO
/****** Object:  StoredProcedure [dbo].[ViewColumnSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewColumnSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ViewColumnSelectCommand]
AS
	SET NOCOUNT ON;
select * from viewcolumn
' 
END
GO
/****** Object:  StoredProcedure [dbo].[ViewColumnInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewColumnInsertCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ViewColumnInsertCommand]
(
	@ColumnName varchar(250),
	@ViewId int,
	@SortOrder int
)
AS
	SET NOCOUNT OFF;
if @ColumnName=''RecommendationId''
Begin
INSERT INTO [viewcolumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (@ColumnName, @ViewId, @SortOrder);
INSERT INTO [viewcolumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (''RichTextRecommendations'', @ViewId, 10000);	
SELECT ColumnName, ViewId, SortOrder FROM ViewColumn WHERE (ColumnName = @ColumnName or ColumnName=''RichTextRecommendations'') AND (ViewId = @ViewId)
end
else
Begin
INSERT INTO [viewcolumn] ([ColumnName], [ViewId], [SortOrder]) VALUES (@ColumnName, @ViewId, @SortOrder);
SELECT ColumnName, ViewId, SortOrder FROM ViewColumn WHERE (ColumnName = @ColumnName) AND (ViewId = @ViewId)
end
' 
END
GO
/****** Object:  StoredProcedure [dbo].[ViewColumnUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewColumnUpdateCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ViewColumnUpdateCommand]
(
	@ColumnName varchar(250),
	@ViewId int,
	@SortOrder int,
	@Original_ColumnName varchar(250),
	@Original_ViewId int,
	@IsNull_SortOrder Int,
	@Original_SortOrder int
)
AS
	SET NOCOUNT OFF;
UPDATE [viewcolumn] SET [ColumnName] = @ColumnName, [ViewId] = @ViewId, [SortOrder] = @SortOrder WHERE ([ColumnName] = @Original_ColumnName) AND ([ViewId] = @Original_ViewId);
	
SELECT ColumnName, ViewId, SortOrder FROM ViewColumn WHERE (ColumnName = @Original_ColumnName) AND (ViewId = @Original_ViewId)
' 
END
GO
/****** Object:  StoredProcedure [dbo].[ViewColumnDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewColumnDeleteCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ViewColumnDeleteCommand]
(
	@Original_ColumnName varchar(250),
	@Original_ViewId int,
	@IsNull_SortOrder Int,
	@Original_SortOrder int
)
AS
	SET NOCOUNT OFF;
if ((select [ColumnName] from [viewColumn] where (([ColumnName] = @Original_ColumnName) AND ([ViewId] = @Original_ViewId))) is not null)
begin
DELETE FROM [viewcolumn] WHERE (([ColumnName] = @Original_ColumnName) AND ([ViewId] = @Original_ViewId) AND ((@IsNull_SortOrder = 1 AND [SortOrder] IS NULL) OR ([SortOrder] = @Original_SortOrder)))
end' 
END
GO
/****** Object:  StoredProcedure [dbo].[RadioFamilyUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioFamilyUpdateCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioFamilyUpdateCommand]
(
	@RadioFamilyId int,
	@Name varchar(250),
	@Original_RadioFamilyId int,
	@IsNull_Name Int,
	@Original_Name varchar(250)
)
AS
	SET NOCOUNT OFF;
UPDATE [RadioFamily] SET [RadioFamilyId] = @RadioFamilyId, [Name] = @Name WHERE (([RadioFamilyId] = @Original_RadioFamilyId) AND ((@IsNull_Name = 1 AND [Name] IS NULL) OR ([Name] = @Original_Name)));
	
SELECT RadioFamilyId, Name FROM RadioFamily WHERE (RadioFamilyId = @RadioFamilyId)
' 
END
GO
/****** Object:  StoredProcedure [dbo].[RadioFamilySelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioFamilySelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioFamilySelectCommand]
AS
	SET NOCOUNT ON;
select * from RadioFamily order by [Name]
' 
END
GO
/****** Object:  StoredProcedure [dbo].[RadioFamilyInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioFamilyInsertCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioFamilyInsertCommand]
(
	@RadioFamilyId int,
	@Name varchar(250)
)
AS
	SET NOCOUNT OFF;
INSERT INTO [RadioFamily] ([RadioFamilyId], [Name]) VALUES (@RadioFamilyId, @Name);
	
SELECT RadioFamilyId, Name FROM RadioFamily WHERE (RadioFamilyId = @RadioFamilyId)
' 
END
GO
/****** Object:  StoredProcedure [dbo].[RadioFamilyDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioFamilyDeleteCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioFamilyDeleteCommand]
(
	@Original_RadioFamilyId int,
	@IsNull_Name Int,
	@Original_Name varchar(250)
)
AS
	SET NOCOUNT OFF;
DELETE FROM [RadioFamily] WHERE (([RadioFamilyId] = @Original_RadioFamilyId) AND ((@IsNull_Name = 1 AND [Name] IS NULL) OR ([Name] = @Original_Name)))
' 
END
GO

/****** Object:  StoredProcedure [dbo].[BatteryStatusTypeSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryStatusTypeSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[BatteryStatusTypeSelectCommand]
@Language nvarchar(max)
AS
	SET NOCOUNT ON;
if exists (select * from Translation where [Language]=@Language)
Select BatteryStatusTypeId, T.Value as [Name] from dbo.BatteryStatusType left join (select * from Translation where [Language]=@Language) as T on BatteryStatusType.Name=T.English
else
SELECT BatteryStatusTypeId, Name FROM dbo.BatteryStatusType
' 
END
GO
/****** Object:  StoredProcedure [dbo].[ViewDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewDeleteCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ViewDeleteCommand]
(
	@Original_ViewId int,
	@IsNull_QueryAllowUserToEdit Int,
	@Original_QueryAllowUserToEdit bit
)
AS
	SET NOCOUNT OFF;
DELETE FROM [View] WHERE [ViewId] = @Original_ViewId
' 
END
GO
/****** Object:  StoredProcedure [dbo].[ViewUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewUpdateCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ViewUpdateCommand]
(
	@Name text,
	@ViewType text,
	@Description text,
	@QueryRowFilter text,
	@QuerySort text,
	@QueryAllowUserToEdit bit,
	@QueryInformation text,
	@ThresholdExpress text,
	@Statistic bit,
	@ChartYAxisTitle text,
    @IsShowParaDialog bit,
    @IsUseRowfilter bit,
    @ParameterName text,
	@Original_ViewId int,
	@IsNull_QueryAllowUserToEdit Int,
	@Original_QueryAllowUserToEdit bit,
	@ViewId int
)
AS
	SET NOCOUNT OFF;
UPDATE [View] SET [Name] = @Name, [ViewType] = @ViewType, [Description] = @Description, [QueryRowFilter] = @QueryRowFilter, [QuerySort] = @QuerySort, [QueryAllowUserToEdit] = @QueryAllowUserToEdit, [QueryInformation] = @QueryInformation, [ThresholdExpress] = @ThresholdExpress, [Statistic] = @Statistic, [ChartYAxisTitle] = @ChartYAxisTitle, [IsShowParaDialog]=@IsShowParaDialog, [IsUseRowfilter]=@IsUseRowfilter, [ParameterName]=@ParameterName WHERE [ViewId] = @Original_ViewId;
	
SELECT ViewId, Name, ViewType, Description, QueryRowFilter, QuerySort, QueryAllowUserToEdit, QueryInformation, ThresholdExpress, Statistic, ChartYAxisTitle FROM [View] WHERE (ViewId = @Original_ViewId)
' 
END
GO
/****** Object:  StoredProcedure [dbo].[ViewInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewInsertCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ViewInsertCommand]
(
	@Name text,
	@ViewType text,
	@Description text,
	@QueryRowFilter text,
	@QuerySort text,
	@QueryAllowUserToEdit bit,
	@QueryInformation text,
	@ThresholdExpress text,
	@Statistic bit,
	@ChartYAxisTitle text,
    @IsShowParaDialog bit,
    @IsUseRowfilter bit,
    @ParameterName text
)
AS
	SET NOCOUNT OFF;
IF ((select [Name] from [View] where CAST([Name] as varbinary(max))= CAST(CAST(@Name AS nvarchar(max)) as varbinary(max))) is Null)
Begin
INSERT INTO [View] ([Name], [ViewType], [Description], [QueryRowFilter], [QuerySort], [QueryAllowUserToEdit], [QueryInformation], [ThresholdExpress], [Statistic], [ChartYAxisTitle], [IsShowParaDialog], [IsUseRowfilter], [ParameterName]) VALUES (@Name, @ViewType, @Description, @QueryRowFilter, @QuerySort, @QueryAllowUserToEdit, @QueryInformation, @ThresholdExpress, @Statistic, @ChartYAxisTitle, @IsShowParaDialog, @IsUseRowfilter, @ParameterName);
End	
SELECT * FROM [View] WHERE (ViewId = SCOPE_IDENTITY())
' 
END
GO
/****** Object:  StoredProcedure [dbo].[ViewSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ViewSelectCommand]
@Language nvarchar(max)
AS
	SET NOCOUNT ON;

if exists (select * from Translation where [Language]=@Language)
Begin
Declare @TempTable table(ViewId int, [Name] nvarchar(max) COLLATE database_default,ViewType nvarchar(max) COLLATE database_default, [Description] nvarchar(max) COLLATE database_default, QueryRowFilter nvarchar(max) COLLATE database_default, QuerySort nvarchar(max) COLLATE database_default, QueryAllowUserToEdit bit, QueryInformation nvarchar(max) COLLATE database_default, ThresholdExpress nvarchar(max) COLLATE database_default, Statistic bit, ChartYAxisTitle nvarchar(max) COLLATE database_default, IsShowParaDialog bit, IsUseRowfilter bit, ParameterName nvarchar(max) COLLATE database_default)
Insert into @TempTable SELECT [View].ViewId, T.Value AS Name, [View].ViewType, [View].Description, [View].QueryRowFilter, [View].QuerySort, [View].QueryAllowUserToEdit, 
                      [View].QueryInformation, [View].ThresholdExpress, [View].Statistic, [View].ChartYAxisTitle, [View].IsShowParaDialog, [View].IsUseRowfilter, 
                      [View].ParameterName FROM [View] LEFT OUTER JOIN
                      (Select * from Translation where [Language]=@Language) as T ON [View].Name = T.English
Declare @ParameterTable table(ViewId int, ParameterName nvarchar(max) COLLATE database_default)
insert into @ParameterTable select [View].ViewId, T1.Value as ParameterName from [View] left join (select * from Translation) as T1 on [View].ParameterName=T1.English

select T2.ViewId, T2.Name, T2.ViewType, T2.Description, T2.QueryRowFilter, T2.QuerySort, T2.QueryAllowUserToEdit, T2.QueryInformation, T2.ThresholdExpress, T2.Statistic, T2.ChartYAxisTitle, T2.IsShowParaDialog, T2.IsUseRowfilter, T3.ParameterName from (Select * from @TempTable where [Name] is not null UNION Select * from [View] where [View].ViewId in (Select ViewId from @TempTable where [Name] is null)) as T2 left join
(select * from @ParameterTable where ParameterName is not null UNION select ViewId, ParameterName from [View] where [View].ViewId in (Select ViewId from @ParameterTable where ParameterName is null)) as T3 on T2.ViewId=T3.ViewId

end
else
select * from [View]' 
END
GO
/****** Object:  StoredProcedure [dbo].[RecommendationTypeSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RecommendationTypeSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'Create PROCEDURE [dbo].[RecommendationTypeSelectCommand]
 @Language nvarchar(max)
AS
	SET NOCOUNT ON;
if exists (Select * from Translation where [Language]=@Language)
SELECT RecommendationId, T.Value as [Text] FROM RecommendationType left join (Select * from Translation where [Language]=@Language) as T on RecommendationType.Text=T.English
else
Select RecommendationId, [Text] from RecommendationType
' 
END
GO
/****** Object:  StoredProcedure [dbo].[ManullyUpdateRadioFamily]    Script Date: 10/31/2012 13:45:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ManullyUpdateRadioFamily]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
CREATE PROCEDURE [dbo].[ManullyUpdateRadioFamily] 
	@KITn varchar(50)
AS
BEGIN

Declare @RadioFamilyId int
Declare @FM bit
Declare @TIA4950 bit
Declare @UL2504Div2 bit
Declare @CSA157 bit
Declare @ATEX bit
Declare @NFPA bit
Declare @condition varchar(50)
Set @condition=@KITn+''%''

select top 1 @RadioFamilyId=RadioFamilyid,@FM=FM,@TIA4950=TIA4950,@UL2504Div2=UL2504Div2,@CSA157=CSA157,@ATEX=ATEX,@NFPA=NFPA from dbo.RadioFamilyKitNumber where kitn like @condition order by kitn asc
if @RadioFamilyId is not null
begin
	update battery set 
		RadioFamilyId=@RadioFamilyId,fm=@FM,TIA4950=@TIA4950,UL2504Div2=@UL2504Div2,CSA157=@CSA157,ATEX=@ATEX,NFPA=@NFPA
	where kitn like @condition 
	and kitn not in(select kitn from RadioFamilyKitNumber)
end
	

END
' 
END
GO
/****** Object:  StoredProcedure [dbo].[LanguageSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[LanguageSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[LanguageSelectCommand] 
	-- Add the parameters for the stored procedure here
	AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	SELECT * from dbo.Language
END
' 
END
GO
/****** Object:  StoredProcedure [dbo].[BatteryChemistryTypeSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryChemistryTypeSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[BatteryChemistryTypeSelectCommand]
@Language nvarchar(max)
AS
	SET NOCOUNT ON;
if exists (select * from Translation where [Language]=@Language)
Select ChemistryTypeId, T.Value as [Name] from BatteryChemistryType left join (select * from Translation where [Language]=@Language) as T on BatteryChemistryType.Name=T.English
else
Select * From BatteryChemistryType
' 
END
GO
/****** Object:  StoredProcedure [dbo].[BatteryLEDStatusTypeSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryLEDStatusTypeSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[BatteryLEDStatusTypeSelectCommand]
@Language nvarchar(max)
AS
	SET NOCOUNT ON;
if exists (select * from Translation where [Language]=@Language)
Select LEDStatusTypeId, T.Value as [Name] from BatteryLEDStatusType left join (select * from Translation where [Language]=@Language) as T on BatteryLEDStatusType.Name=T.English
else
Select * From BatteryLEDStatusType
' 
END
GO
/****** Object:  StoredProcedure [dbo].[ColumnInformationUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ColumnInformationUpdateCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ColumnInformationUpdateCommand]
(
	@ColumnName varchar(50),
	@DataType varchar(50),
	@HeaderText varchar(50),
	@Description varchar(MAX),
	@GridColumnType varchar(50),
	@GridWidth int,
	@GridComboBoxDataSource varchar(50),
	@GridComboBoxDisplayMember varchar(50),
	@GridComboBoxValueMember varchar(50),
	@ChartPietSliceColor int,
	@Original_ColumnName varchar(50),
	@IsNull_DataType Int,
	@Original_DataType varchar(50),
	@IsNull_HeaderText Int,
	@Original_HeaderText varchar(50),
	@IsNull_GridColumnType Int,
	@Original_GridColumnType varchar(50),
	@IsNull_GridWidth Int,
	@Original_GridWidth int,
	@IsNull_GridComboBoxDataSource Int,
	@Original_GridComboBoxDataSource varchar(50),
	@IsNull_GridComboBoxDisplayMember Int,
	@Original_GridComboBoxDisplayMember varchar(50),
	@IsNull_GridComboBoxValueMember Int,
	@Original_GridComboBoxValueMember varchar(50),
	@IsNull_ChartPietSliceColor Int,
	@Original_ChartPietSliceColor int
)
AS
	SET NOCOUNT OFF;
UPDATE [ColumnInformation] SET [ColumnName] = @ColumnName, [DataType] = @DataType, [HeaderText] = @HeaderText, [Description] = @Description, [GridColumnType] = @GridColumnType, [GridWidth] = @GridWidth, [GridComboBoxDataSource] = @GridComboBoxDataSource, [GridComboBoxDisplayMember] = @GridComboBoxDisplayMember, [GridComboBoxValueMember] = @GridComboBoxValueMember, [ChartPietSliceColor] = @ChartPietSliceColor WHERE [ColumnName] = @Original_ColumnName;
	
SELECT ColumnName, DataType, HeaderText, Description, GridColumnType, GridWidth, GridComboBoxDataSource, GridComboBoxDisplayMember, GridComboBoxValueMember, ChartPietSliceColor FROM ColumnInformation WHERE (ColumnName = @Original_ColumnName)
' 
END
GO
/****** Object:  StoredProcedure [dbo].[ColumnInformationInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ColumnInformationInsertCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ColumnInformationInsertCommand]
(
	@ColumnName varchar(50),
	@DataType varchar(50),
	@HeaderText varchar(50),
	@Description varchar(MAX),
	@GridColumnType varchar(50),
	@GridWidth int,
	@GridComboBoxDataSource varchar(50),
	@GridComboBoxDisplayMember varchar(50),
	@GridComboBoxValueMember varchar(50),
	@ChartPietSliceColor int
)
AS
	SET NOCOUNT OFF;
INSERT INTO [ColumnInformation] ([ColumnName], [DataType], [HeaderText], [Description], [GridColumnType], [GridWidth], [GridComboBoxDataSource], [GridComboBoxDisplayMember], [GridComboBoxValueMember], [ChartPietSliceColor]) VALUES (@ColumnName, @DataType, @HeaderText, @Description, @GridColumnType, @GridWidth, @GridComboBoxDataSource, @GridComboBoxDisplayMember, @GridComboBoxValueMember, @ChartPietSliceColor);
	
SELECT ColumnName, DataType, HeaderText, Description, GridColumnType, GridWidth, GridComboBoxDataSource, GridComboBoxDisplayMember, GridComboBoxValueMember, ChartPietSliceColor FROM ColumnInformation WHERE (ColumnName = @ColumnName)
' 
END
GO
/****** Object:  StoredProcedure [dbo].[ColumnInformationDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ColumnInformationDeleteCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ColumnInformationDeleteCommand]
(
	@Original_ColumnName varchar(50),
	@IsNull_DataType Int,
	@Original_DataType varchar(50),
	@IsNull_HeaderText Int,
	@Original_HeaderText varchar(50),
	@IsNull_GridColumnType Int,
	@Original_GridColumnType varchar(50),
	@IsNull_GridWidth Int,
	@Original_GridWidth int,
	@IsNull_GridComboBoxDataSource Int,
	@Original_GridComboBoxDataSource varchar(50),
	@IsNull_GridComboBoxDisplayMember Int,
	@Original_GridComboBoxDisplayMember varchar(50),
	@IsNull_GridComboBoxValueMember Int,
	@Original_GridComboBoxValueMember varchar(50),
	@IsNull_ChartPietSliceColor Int,
	@Original_ChartPietSliceColor int
)
AS
	SET NOCOUNT OFF;
DELETE FROM [ColumnInformation] WHERE (([ColumnName] = @Original_ColumnName) AND ((@IsNull_DataType = 1 AND [DataType] IS NULL) OR ([DataType] = @Original_DataType)) AND ((@IsNull_HeaderText = 1 AND [HeaderText] IS NULL) OR ([HeaderText] = @Original_HeaderText)) AND ((@IsNull_GridColumnType = 1 AND [GridColumnType] IS NULL) OR ([GridColumnType] = @Original_GridColumnType)) AND ((@IsNull_GridWidth = 1 AND [GridWidth] IS NULL) OR ([GridWidth] = @Original_GridWidth)) AND ((@IsNull_GridComboBoxDataSource = 1 AND [GridComboBoxDataSource] IS NULL) OR ([GridComboBoxDataSource] = @Original_GridComboBoxDataSource)) AND ((@IsNull_GridComboBoxDisplayMember = 1 AND [GridComboBoxDisplayMember] IS NULL) OR ([GridComboBoxDisplayMember] = @Original_GridComboBoxDisplayMember)) AND ((@IsNull_GridComboBoxValueMember = 1 AND [GridComboBoxValueMember] IS NULL) OR ([GridComboBoxValueMember] = @Original_GridComboBoxValueMember)) AND ((@IsNull_ChartPietSliceColor = 1 AND [ChartPietSliceColor] IS NULL) OR ([ChartPietSliceColor] = @Original_ChartPietSliceColor)))
' 
END
GO
/****** Object:  StoredProcedure [dbo].[ColumnInformationSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ColumnInformationSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ColumnInformationSelectCommand]
@Language nvarchar(max)
AS
	SET NOCOUNT ON;
if exists (select * from Translation where [Language]=@Language)
select ColumnName, DataType, T.Value as HeadeText, [Description], GridColumnType, GridWidth, GridComboBoxDataSource, GridComboBoxDisplayMember, GridComboBoxValueMember, ChartPietSliceColor from ColumnInformation left join (select * from Translation where [Language]=@Language) as T on ColumnInformation.HeaderText=T.English
else
select * from ColumnInformation
' 
END
GO
/****** Object:  StoredProcedure [dbo].[ThresholdExpressSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ThresholdExpressSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[ThresholdExpressSelectCommand] 
	-- Add the parameters for the stored procedure here
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	SELECT * from ThresholdExpress
END
' 
END
GO
/****** Object:  StoredProcedure [dbo].[BatteryChargeStatusTypeSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryChargeStatusTypeSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[BatteryChargeStatusTypeSelectCommand]
@Language nvarchar(max)
AS
	SET NOCOUNT ON;
if exists (select * from Translation where [Language]=@Language)
Select ChargeStatusTypeId, T.Value as [Name] from BatteryChargeStatusType left join (Select * from Translation where [Language]=@Language) as T on BatteryChargeStatusType.Name=T.English
else
Select * From BatteryChargeStatusType
' 
END
GO
/****** Object:  StoredProcedure [dbo].[BatteryChargeStateTypeSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryChargeStateTypeSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[BatteryChargeStateTypeSelectCommand]
 @Language nvarchar(max)
AS
	SET NOCOUNT ON;
if exists (Select * from Translation where [Language]=@Language)
SELECT ChargeStateTypeId, T.Value as [Name] FROM BatteryChargeStateType left join (Select * from Translation where [Language]=@Language) as T on BatteryChargeStateType.Name=T.English
else
Select ChargeStateTypeId, [Name] from BatteryChargeStateType' 
END
GO
/****** Object:  StoredProcedure [dbo].[ChartInformationSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ChartInformationSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[ChartInformationSelectCommand] 
	AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	SELECT * from ChartInformation
END
' 
END
GO
/****** Object:  StoredProcedure [dbo].[ViewChartSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewChartSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[ViewChartSelectCommand] 
	AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	SELECT * from ViewChart
END
' 
END
GO
/****** Object:  StoredProcedure [dbo].[MarkableDataSelectCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MarkableDataSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[MarkableDataSelectCommand] 
	-- Add the parameters for the stored procedure here
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	SELECT SerialNumber, ALERTID from Battery where ALERTID=1;
END
' 
END
GO
/****** Object:  StoredProcedure [dbo].[ErrorBatteriesReprot]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ErrorBatteriesReprot]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[ErrorBatteriesReprot] 
	-- Add the parameters for the stored procedure here
    @parameter nvarchar(max),
    @rowstart int,
    @rowcount int
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	SELECT * from Battery where BatteryStatusTypeId=2
END
' 
END
GO
/****** Object:  StoredProcedure [dbo].[RawBatterySelectBySerialNumber]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RawBatterySelectBySerialNumber]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RawBatterySelectBySerialNumber] 
	-- Add the parameters for the stored procedure here
	
@serialnumber varchar(50)

AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	select          SerialNumber, CompanyId, Alias, KITn, CHEM, BatteryStatusTypeId, BatteryGroupId, BatteryChargeStateId, RadioFamilyId, CurrentCharge, 
                      PotentialCapacity, RatedCapacity, CapacityRatio, DateOfManufacture,DATEDIFF(d, DateofinitialUse, CURRENT_TIMESTAMP) as AgeInDays, DateOfInitialUse, DaysSinceLastReconditioning, 
                      DaysSinceRemovalFromCharger, TotalIMPRESChargeCycles, TotalEstimatedNonIMPRESChargeCycles, TotalEstimatedNonIMPRESChargeCyclesPrior, 
                      TotalReconditioningCycles, EstimatedDaysUntilNextReconditioning, SoftwareVersion, TemperatureC, Voltage, LED, DateOfRead, RecommendationId, RichTextRecommendations, 
                      CA00, CA10, CA20, CA30, CA40, CA50, CA60, CA70, CA80, CA90, RE00, RE10, RE20, RE30, RE40, RE50, RE60, RE70, RE80, RE90, ComputerName, 
                      DeviceName, PocketNumber, DATEDIFF(d, DateOfRead, CURRENT_TIMESTAMP) as DaysSinceLastRead, DaysSinceInitialUse, SNSR, ICA, CTS, DOIU, WF00, WF10, WF20, WF30, WF40, WF50, WF60, 
                      WF70, WF80, WF90, ETM, LDAY, LHR, LMIN, FDDp, DISp, TRIG, DOIC, FM, Comment, ChargerHighTemperature, ChargerLowTemperature,HID,ALERTID,UnsupportedFieldsList,ErrorFieldsList, DateofLastRemove, OverdueThreshold,Charging
			, NeedToRead
			, RemainingCapacityRatio
			, TIA4950
			, UL2504Div2
			, CSA157
			, ATEX
			, NFPA
			, NFPAContinuousOverTemp
			, NFPACumulativeOverTemp
			, NFPAOverTempCounter
			, BatteryTypeID
 from battery  
where SerialNumber = @serialnumber
END
' 
END
GO
/****** Object:  StoredProcedure [dbo].[FindBySerialNumber]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FindBySerialNumber]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[FindBySerialNumber]
(
	@serialnumber varchar(50)
)
AS
	SET NOCOUNT ON;
select * from battery where serialnumber=@serialnumber
' 
END
GO
/****** Object:  StoredProcedure [dbo].[BatterySelectBySerialNumber]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatterySelectBySerialNumber]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[BatterySelectBySerialNumber]
(
	@serialnumber varchar(50)
)
AS
	SET NOCOUNT ON;
select          SerialNumber,a.CompanyId,a.Alias,a.KITn,a.CHEM,a.BatteryStatusTypeId,a.BatteryGroupId,a.BatteryChargeStateId,a.RadioFamilyId,a.CurrentCharge,a.
                      PotentialCapacity,a.RatedCapacity,a.CapacityRatio,a.DateOfManufacture,DATEDIFF(d,a.DateofinitialUse,CURRENT_TIMESTAMP) as AgeInDays,a.DateOfInitialUse,a.DaysSinceLastReconditioning,a.
                      DaysSinceRemovalFromCharger,a.TotalIMPRESChargeCycles,a.TotalEstimatedNonIMPRESChargeCycles,a.TotalEstimatedNonIMPRESChargeCyclesPrior,a.
                      TotalReconditioningCycles,a.EstimatedDaysUntilNextReconditioning,a.SoftwareVersion,a.TemperatureC,a.Voltage,a.LED,a.DateOfRead,a.RecommendationId,a.RichTextRecommendations,a.
                      CA00,a.CA10,a.CA20,a.CA30,a.CA40,a.CA50,a.CA60,a.CA70,a.CA80,a.CA90,a.RE00,a.RE10,a.RE20,a.RE30,a.RE40,a.RE50,a.RE60,a.RE70,a.RE80,a.RE90,a.ComputerName,a.
                      DeviceName,a.PocketNumber,DATEDIFF(d,a.DateOfRead,CURRENT_TIMESTAMP) as DaysSinceLastRead,a.DaysSinceInitialUse,a.SNSR,a.ICA,a.CTS,a.DOIU,a.WF00,a.WF10,a.WF20,a.WF30,a.WF40,a.WF50,a.WF60,a.
                      WF70,a.WF80,a.WF90,a.ETM,a.LDAY,a.LHR,a.LMIN,a.FDDp,a.DISp,a.TRIG,a.DOIC,a.FM,a.Comment,a.ChargerHighTemperature,a.ChargerLowTemperature,HID,ALERTID,UnsupportedFieldsList,ErrorFieldsList,a.DateofLastRemove,a.OverdueThreshold,a.Charging 
					,b.DisplayName as ComputerAlias,c.DisplayName
					,a.NeedToRead
					, a.RemainingCapacityRatio
					, a.TIA4950, a.UL2504Div2, a.CSA157, a.ATEX
							  , a.NFPA
							  , a.NFPAContinuousOverTemp
					  , a.NFPACumulativeOverTemp
					  , a.NFPAOverTempCounter
					  , a.BatteryTypeID
from battery a LEFT OUTER JOIN
	(SELECT DISTINCT ComputerName, DisplayName
		FROM          dbo.Computer) AS b ON a.ComputerName = b.ComputerName LEFT OUTER JOIN
	(SELECT DISTINCT ComputerName, DeviceName, DisplayName
		FROM          dbo.Device) AS c ON a.DeviceName = c.DeviceName and a.ComputerName = c.ComputerName
where a.SerialNumber = @serialnumber
' 
END
GO
/****** Object:  StoredProcedure [dbo].[BatterySelectCommand]    Script Date: 06/10/2014 13:27:31 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatterySelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[BatterySelectCommand]

AS
	SET NOCOUNT ON;
Begin
select a.SerialNumber,a.CompanyId,a.Alias,RadioID=IsNull(d.RadioID,''''),RadioIP=IsNull(d.RadioIP,''''),RadioAlias=IsNull(d.RadioAlias,''''),LastKnownRadioID=IsNull(e.RadioID,''''),LastKnownRadioPresentity=IsNull(e.RadioPresentity,''''),LastKnownRadioAlias=IsNull(e.RadioAlias,''''),
a.KITn,a.CHEM,a.BatteryStatusTypeId,a.BatteryGroupId,a.BatteryChargeStateId,a.RadioFamilyId,a.CurrentCharge,a.PotentialCapacity,a.RatedCapacity,a.CapacityRatio,
Convert(nvarchar(max),a.DateOfManufacture,110) as DateOfManufacture,
DATEDIFF(d,a.DateofinitialUse,CURRENT_TIMESTAMP) as AgeInDays,
a.DateOfInitialUse,a.DaysSinceLastReconditioning,
a.DaysSinceRemovalFromCharger,a.TotalIMPRESChargeCycles,a.TotalEstimatedNonIMPRESChargeCycles,a.TotalEstimatedNonIMPRESChargeCyclesPrior,
a.TotalReconditioningCycles,a.EstimatedDaysUntilNextReconditioning,a.SoftwareVersion,a.TemperatureC,a.Voltage,a.LED,a.DateOfRead,a.RecommendationId,a.RichTextRecommendations,
a.CA00,a.CA10,a.CA20,a.CA30,a.CA40,a.CA50,a.CA60,a.CA70,a.CA80,a.CA90,a.RE00,a.RE10,a.RE20,a.RE30,a.RE40,a.RE50,a.RE60,a.RE70,a.RE80,a.RE90,a.ComputerName,
a.DeviceName,a.PocketNumber,DATEDIFF(d,a.DateOfRead,CURRENT_TIMESTAMP) as DaysSinceLastRead,a.DaysSinceInitialUse,a.SNSR,a.ICA,a.CTS,a.DOIU,a.WF00,a.WF10,a.WF20,a.WF30,a.WF40,a.WF50,a.WF60,
a.WF70,a.WF80,a.WF90,a.ETM,a.LDAY,a.LHR,a.LMIN,a.FDDp,a.DISp,a.TRIG,a.DOIC,a.FM,a.Comment,a.ChargerHighTemperature,a.ChargerLowTemperature,a.HID,a.ALERTID,a.UnsupportedFieldsList,a.ErrorFieldsList,a.DateofLastRemove,a.OverdueThreshold,a.Charging,
b.DisplayName as ComputerAlias,c.DisplayName
,a.NeedToRead
, a.RemainingCapacityRatio
, a.TIA4950
, a.UL2504Div2
, a.CSA157
, a.ATEX
		  , a.NFPA
		   , a.NFPAContinuousOverTemp
					  , a.NFPACumulativeOverTemp
					  , a.NFPAOverTempCounter
					  , a.BatteryTypeID
from battery a LEFT OUTER JOIN
	(SELECT DISTINCT ComputerName, DisplayName
		FROM          dbo.Computer) AS b ON a.ComputerName = b.ComputerName LEFT OUTER JOIN
	(SELECT DISTINCT ComputerName, DeviceName, DisplayName
		FROM          dbo.Device) AS c ON a.DeviceName = c.DeviceName and a.ComputerName = c.ComputerName
	LEFT OUTER JOIN radio AS d ON a.serialnumber=d.batteryserialnumber
    LEFT OUTER JOIN BatteryLastKnownRadio AS e ON a.serialnumber=e.BatterySerialNumber 
where BatteryStatusTypeId<>0
end
' 
END
GO
/****** Object:  StoredProcedure [dbo].[FindBatteryBySerialNumber]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FindBatteryBySerialNumber]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[FindBatteryBySerialNumber]
(
	@serialnumber varchar(50)
)
AS
	SET NOCOUNT ON;
select * from battery where serialnumber=@serialnumber
' 
END
GO
/****** Object:  StoredProcedure [dbo].[BatteryDeleteCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryDeleteCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[BatteryDeleteCommand]
(
	@Original_SerialNumber varchar(50)
--	@IsNull_CompanyId Int,
--	@Original_CompanyId int,
--	@IsNull_Alias Int,
--	@Original_Alias varchar(50),
--	@IsNull_KITn Int,
--	@Original_KITn varchar(50),
--	@IsNull_CHEM Int,
--	@Original_CHEM int,
--	@IsNull_BatteryStatusTypeId Int,
--	@Original_BatteryStatusTypeId int,
--	@IsNull_BatteryGroupId Int,
--	@Original_BatteryGroupId int,
--	@IsNull_BatteryChargeStateId Int,
--	@Original_BatteryChargeStateId int,
--	@IsNull_RadioFamilyId Int,
--	@Original_RadioFamilyId int,
--	@IsNull_CurrentCharge Int,
--	@Original_CurrentCharge int,
--	@IsNull_PotentialCapacity Int,
--	@Original_PotentialCapacity int,
--	@IsNull_RatedCapacity Int,
--	@Original_RatedCapacity int,
--	@IsNull_CapacityRatio Int,
--	@Original_CapacityRatio int,
--	@IsNull_DateOfManufacture Int,
--	@Original_DateOfManufacture datetime,
--	@IsNull_AgeInDays Int,
--	@Original_AgeInDays int,
--	@IsNull_DateOfInitialUse Int,
--	@Original_DateOfInitialUse datetime,
--	@IsNull_DaysSinceLastReconditioning Int,
--	@Original_DaysSinceLastReconditioning int,
--	@IsNull_DaysSinceRemovalFromCharger Int,
--	@Original_DaysSinceRemovalFromCharger int,
--	@IsNull_TotalIMPRESChargeCycles Int,
--	@Original_TotalIMPRESChargeCycles int,
--	@IsNull_TotalEstimatedNonIMPRESChargeCycles Int,
--	@Original_TotalEstimatedNonIMPRESChargeCycles int,
--	@IsNull_TotalEstimatedNonIMPRESChargeCyclesPrior Int,
--	@Original_TotalEstimatedNonIMPRESChargeCyclesPrior int,
--	@IsNull_TotalReconditioningCycles Int,
--	@Original_TotalReconditioningCycles int,
--	@IsNull_EstimatedDaysUntilNextReconditioning Int,
--	@Original_EstimatedDaysUntilNextReconditioning int,
--	@IsNull_SoftwareVersion Int,
--	@Original_SoftwareVersion float,
--	@IsNull_TemperatureC Int,
--	@Original_TemperatureC float,
--	@IsNull_Voltage Int,
--	@Original_Voltage float,
--	@IsNull_LED Int,
--	@Original_LED int,
--	@IsNull_DateOfRead Int,
--	@Original_DateOfRead datetime,
--	@IsNull_Recommendations Int,
--	@Original_Recommendations varchar(250),
--	@IsNull_CA00 Int,
--	@Original_CA00 int,
--	@IsNull_CA10 Int,
--	@Original_CA10 int,
--	@IsNull_CA20 Int,
--	@Original_CA20 int,
--	@IsNull_CA30 Int,
--	@Original_CA30 int,
--	@IsNull_CA40 Int,
--	@Original_CA40 int,
--	@IsNull_CA50 Int,
--	@Original_CA50 int,
--	@IsNull_CA60 Int,
--	@Original_CA60 int,
--	@IsNull_CA70 Int,
--	@Original_CA70 int,
--	@IsNull_CA80 Int,
--	@Original_CA80 int,
--	@IsNull_CA90 Int,
--	@Original_CA90 int,
--	@IsNull_RE00 Int,
--	@Original_RE00 int,
--	@IsNull_RE10 Int,
--	@Original_RE10 int,
--	@IsNull_RE20 Int,
--	@Original_RE20 int,
--	@IsNull_RE30 Int,
--	@Original_RE30 int,
--	@IsNull_RE40 Int,
--	@Original_RE40 int,
--	@IsNull_RE50 Int,
--	@Original_RE50 int,
--	@IsNull_RE60 Int,
--	@Original_RE60 int,
--	@IsNull_RE70 Int,
--	@Original_RE70 int,
--	@IsNull_RE80 Int,
--	@Original_RE80 int,
--	@IsNull_RE90 Int,
--	@Original_RE90 int,
--	@IsNull_ComputerName Int,
--	@Original_ComputerName varchar(50),
--	@IsNull_DeviceName Int,
--	@Original_DeviceName varchar(250),
--	@IsNull_PocketNumber Int,
--	@Original_PocketNumber int,
--	@IsNull_DaysSinceLastRead Int,
--	@Original_DaysSinceLastRead int,
--	@IsNull_DaysSinceInitialUse Int,
--	@Original_DaysSinceInitialUse int,
--	@IsNull_SNSR Int,
--	@Original_SNSR float,
--	@Original_ICA float,
--	@IsNull_CTS Int,
--	@Original_CTS int,
--	@IsNull_DOIU Int,
--	@Original_DOIU int,
--	@IsNull_WF00 Int,
--	@Original_WF00 int,
--	@IsNull_WF10 Int,
--	@Original_WF10 int,
--	@IsNull_WF20 Int,
--	@Original_WF20 int,
--	@IsNull_WF30 Int,
--	@Original_WF30 int,
--	@IsNull_WF40 Int,
--	@Original_WF40 int,
--	@IsNull_WF50 Int,
--	@Original_WF50 int,
--	@IsNull_WF60 Int,
--	@Original_WF60 int,
--	@IsNull_WF70 Int,
--	@Original_WF70 int,
--	@IsNull_WF80 Int,
--	@Original_WF80 int,
--	@IsNull_WF90 Int,
--	@Original_WF90 int,
--	@IsNull_ETM Int,
--	@Original_ETM int,
--	@IsNull_LDAY Int,
--	@Original_LDAY int,
--	@IsNull_LHR Int,
--	@Original_LHR int,
--	@IsNull_LMIN Int,
--	@Original_LMIN int,
--	@IsNull_FDDp Int,
--	@Original_FDDp int,
--	@IsNull_DISp Int,
--	@Original_DISp int,
--	@IsNull_TRIG Int,
--	@Original_TRIG int,
--	@IsNull_DOIC Int,
--	@Original_DOIC int,
--	@IsNull_FM Int,
--	@Original_FM bit
)
AS
	SET NOCOUNT OFF;
--DELETE FROM [battery] WHERE (([SerialNumber] = @Original_SerialNumber) AND ((@IsNull_CompanyId = 1 AND [CompanyId] IS NULL) OR ([CompanyId] = @Original_CompanyId)) AND ((@IsNull_Alias = 1 AND [Alias] IS NULL) OR ([Alias] = @Original_Alias)) AND ((@IsNull_KITn = 1 AND [KITn] IS NULL) OR ([KITn] = @Original_KITn)) AND ((@IsNull_CHEM = 1 AND [CHEM] IS NULL) OR ([CHEM] = @Original_CHEM)) AND ((@IsNull_BatteryStatusTypeId = 1 AND [BatteryStatusTypeId] IS NULL) OR ([BatteryStatusTypeId] = @Original_BatteryStatusTypeId)) AND ((@IsNull_BatteryGroupId = 1 AND [BatteryGroupId] IS NULL) OR ([BatteryGroupId] = @Original_BatteryGroupId)) AND ((@IsNull_BatteryChargeStateId = 1 AND [BatteryChargeStateId] IS NULL) OR ([BatteryChargeStateId] = @Original_BatteryChargeStateId)) AND ((@IsNull_RadioFamilyId = 1 AND [RadioFamilyId] IS NULL) OR ([RadioFamilyId] = @Original_RadioFamilyId)) AND ((@IsNull_CurrentCharge = 1 AND [CurrentCharge] IS NULL) OR ([CurrentCharge] = @Original_CurrentCharge)) AND ((@IsNull_PotentialCapacity = 1 AND [PotentialCapacity] IS NULL) OR ([PotentialCapacity] = @Original_PotentialCapacity)) AND ((@IsNull_RatedCapacity = 1 AND [RatedCapacity] IS NULL) OR ([RatedCapacity] = @Original_RatedCapacity)) AND ((@IsNull_CapacityRatio = 1 AND [CapacityRatio] IS NULL) OR ([CapacityRatio] = @Original_CapacityRatio)) AND ((@IsNull_DateOfManufacture = 1 AND [DateOfManufacture] IS NULL) OR ([DateOfManufacture] = @Original_DateOfManufacture)) AND ((@IsNull_AgeInDays = 1 AND [AgeInDays] IS NULL) OR ([AgeInDays] = @Original_AgeInDays)) AND ((@IsNull_DateOfInitialUse = 1 AND [DateOfInitialUse] IS NULL) OR ([DateOfInitialUse] = @Original_DateOfInitialUse)) AND ((@IsNull_DaysSinceLastReconditioning = 1 AND [DaysSinceLastReconditioning] IS NULL) OR ([DaysSinceLastReconditioning] = @Original_DaysSinceLastReconditioning)) AND ((@IsNull_DaysSinceRemovalFromCharger = 1 AND [DaysSinceRemovalFromCharger] IS NULL) OR ([DaysSinceRemovalFromCharger] = @Original_DaysSinceRemovalFromCharger)) AND ((@IsNull_TotalIMPRESChargeCycles = 1 AND [TotalIMPRESChargeCycles] IS NULL) OR ([TotalIMPRESChargeCycles] = @Original_TotalIMPRESChargeCycles)) AND ((@IsNull_TotalEstimatedNonIMPRESChargeCycles = 1 AND [TotalEstimatedNonIMPRESChargeCycles] IS NULL) OR ([TotalEstimatedNonIMPRESChargeCycles] = @Original_TotalEstimatedNonIMPRESChargeCycles)) AND ((@IsNull_TotalEstimatedNonIMPRESChargeCyclesPrior = 1 AND [TotalEstimatedNonIMPRESChargeCyclesPrior] IS NULL) OR ([TotalEstimatedNonIMPRESChargeCyclesPrior] = @Original_TotalEstimatedNonIMPRESChargeCyclesPrior)) AND ((@IsNull_TotalReconditioningCycles = 1 AND [TotalReconditioningCycles] IS NULL) OR ([TotalReconditioningCycles] = @Original_TotalReconditioningCycles)) AND ((@IsNull_EstimatedDaysUntilNextReconditioning = 1 AND [EstimatedDaysUntilNextReconditioning] IS NULL) OR ([EstimatedDaysUntilNextReconditioning] = @Original_EstimatedDaysUntilNextReconditioning)) AND ((@IsNull_SoftwareVersion = 1 AND [SoftwareVersion] IS NULL) OR ([SoftwareVersion] = @Original_SoftwareVersion)) AND ((@IsNull_TemperatureC = 1 AND [TemperatureC] IS NULL) OR ([TemperatureC] = @Original_TemperatureC)) AND ((@IsNull_Voltage = 1 AND [Voltage] IS NULL) OR ([Voltage] = @Original_Voltage)) AND ((@IsNull_LED = 1 AND [LED] IS NULL) OR ([LED] = @Original_LED)) AND ((@IsNull_DateOfRead = 1 AND [DateOfRead] IS NULL) OR ([DateOfRead] = @Original_DateOfRead)) AND ((@IsNull_Recommendations = 1 AND [Recommendations] IS NULL) OR ([Recommendations] = @Original_Recommendations)) AND ((@IsNull_CA00 = 1 AND [CA00] IS NULL) OR ([CA00] = @Original_CA00)) AND ((@IsNull_CA10 = 1 AND [CA10] IS NULL) OR ([CA10] = @Original_CA10)) AND ((@IsNull_CA20 = 1 AND [CA20] IS NULL) OR ([CA20] = @Original_CA20)) AND ((@IsNull_CA30 = 1 AND [CA30] IS NULL) OR ([CA30] = @Original_CA30)) AND ((@IsNull_CA40 = 1 AND [CA40] IS NULL) OR ([CA40] = @Original_CA40)) AND ((@IsNull_CA50 = 1 AND [CA50] IS NULL) OR ([CA50] = @Original_CA50)) AND ((@IsNull_CA60 = 1 AND [CA60] IS NULL) OR ([CA60] = @Original_CA60)) AND ((@IsNull_CA70 = 1 AND [CA70] IS NULL) OR ([CA70] = @Original_CA70)) AND ((@IsNull_CA80 = 1 AND [CA80] IS NULL) OR ([CA80] = @Original_CA80)) AND ((@IsNull_CA90 = 1 AND [CA90] IS NULL) OR ([CA90] = @Original_CA90)) AND ((@IsNull_RE00 = 1 AND [RE00] IS NULL) OR ([RE00] = @Original_RE00)) AND ((@IsNull_RE10 = 1 AND [RE10] IS NULL) OR ([RE10] = @Original_RE10)) AND ((@IsNull_RE20 = 1 AND [RE20] IS NULL) OR ([RE20] = @Original_RE20)) AND ((@IsNull_RE30 = 1 AND [RE30] IS NULL) OR ([RE30] = @Original_RE30)) AND ((@IsNull_RE40 = 1 AND [RE40] IS NULL) OR ([RE40] = @Original_RE40)) AND ((@IsNull_RE50 = 1 AND [RE50] IS NULL) OR ([RE50] = @Original_RE50)) AND ((@IsNull_RE60 = 1 AND [RE60] IS NULL) OR ([RE60] = @Original_RE60)) AND ((@IsNull_RE70 = 1 AND [RE70] IS NULL) OR ([RE70] = @Original_RE70)) AND ((@IsNull_RE80 = 1 AND [RE80] IS NULL) OR ([RE80] = @Original_RE80)) AND ((@IsNull_RE90 = 1 AND [RE90] IS NULL) OR ([RE90] = @Original_RE90)) AND ((@IsNull_ComputerName = 1 AND [ComputerName] IS NULL) OR ([ComputerName] = @Original_ComputerName)) AND ((@IsNull_DeviceName = 1 AND [DeviceName] IS NULL) OR ([DeviceName] = @Original_DeviceName)) AND ((@IsNull_PocketNumber = 1 AND [PocketNumber] IS NULL) OR ([PocketNumber] = @Original_PocketNumber)) AND ((@IsNull_DaysSinceLastRead = 1 AND [DaysSinceLastRead] IS NULL) OR ([DaysSinceLastRead] = @Original_DaysSinceLastRead)) AND ((@IsNull_DaysSinceInitialUse = 1 AND [DaysSinceInitialUse] IS NULL) OR ([DaysSinceInitialUse] = @Original_DaysSinceInitialUse)) AND ((@IsNull_SNSR = 1 AND [SNSR] IS NULL) OR ([SNSR] = @Original_SNSR)) AND ([ICA] = @Original_ICA) AND ((@IsNull_CTS = 1 AND [CTS] IS NULL) OR ([CTS] = @Original_CTS)) AND ((@IsNull_DOIU = 1 AND [DOIU] IS NULL) OR ([DOIU] = @Original_DOIU)) AND ((@IsNull_WF00 = 1 AND [WF00] IS NULL) OR ([WF00] = @Original_WF00)) AND ((@IsNull_WF10 = 1 AND [WF10] IS NULL) OR ([WF10] = @Original_WF10)) AND ((@IsNull_WF20 = 1 AND [WF20] IS NULL) OR ([WF20] = @Original_WF20)) AND ((@IsNull_WF30 = 1 AND [WF30] IS NULL) OR ([WF30] = @Original_WF30)) AND ((@IsNull_WF40 = 1 AND [WF40] IS NULL) OR ([WF40] = @Original_WF40)) AND ((@IsNull_WF50 = 1 AND [WF50] IS NULL) OR ([WF50] = @Original_WF50)) AND ((@IsNull_WF60 = 1 AND [WF60] IS NULL) OR ([WF60] = @Original_WF60)) AND ((@IsNull_WF70 = 1 AND [WF70] IS NULL) OR ([WF70] = @Original_WF70)) AND ((@IsNull_WF80 = 1 AND [WF80] IS NULL) OR ([WF80] = @Original_WF80)) AND ((@IsNull_WF90 = 1 AND [WF90] IS NULL) OR ([WF90] = @Original_WF90)) AND ((@IsNull_ETM = 1 AND [ETM] IS NULL) OR ([ETM] = @Original_ETM)) AND ((@IsNull_LDAY = 1 AND [LDAY] IS NULL) OR ([LDAY] = @Original_LDAY)) AND ((@IsNull_LHR = 1 AND [LHR] IS NULL) OR ([LHR] = @Original_LHR)) AND ((@IsNull_LMIN = 1 AND [LMIN] IS NULL) OR ([LMIN] = @Original_LMIN)) AND ((@IsNull_FDDp = 1 AND [FDDp] IS NULL) OR ([FDDp] = @Original_FDDp)) AND ((@IsNull_DISp = 1 AND [DISp] IS NULL) OR ([DISp] = @Original_DISp)) AND ((@IsNull_TRIG = 1 AND [TRIG] IS NULL) OR ([TRIG] = @Original_TRIG)) AND ((@IsNull_DOIC = 1 AND [DOIC] IS NULL) OR ([DOIC] = @Original_DOIC)) AND ((@IsNull_FM = 1 AND [FM] IS NULL) OR ([FM] = @Original_FM)))
DELETE FROM [Battery] WHERE SerialNumber=@Original_SerialNumber' 
END
GO
/****** Object:  StoredProcedure [dbo].[RadioFamilyKitNumberUpdateCommand]    Script Date: 08/03/2012 18:05:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioFamilyKitNumberUpdateCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
CREATE PROCEDURE [dbo].[RadioFamilyKitNumberUpdateCommand]
(
	@RadioFamilyId int,
	@KITn varchar(50),
	@FM bit,
	@TIA4950 bit,
	@UL2504Div2 bit,
	@CSA157 bit,
	@ATEX bit,
	@NFPA bit,
	@BatteryTypeID int
)
AS
	SET NOCOUNT OFF;
UPDATE [radiofamilyKitNumber] SET [FM]=@FM, [TIA4950]=@TIA4950, [UL2504Div2]=@UL2504Div2, [CSA157]=@CSA157, [ATEX]=@ATEX, [NFPA]=@NFPA, [RadioFamilyId] = @RadioFamilyId, [BatteryTypeID] = @BatteryTypeID WHERE ([KITn] = @KITn);
Update Battery set RadioFamilyId=@RadioFamilyId, FM=@FM, TIA4950=@TIA4950, UL2504Div2=@UL2504Div2, CSA157=@CSA157, ATEX=@ATEX, NFPA=@NFPA where Battery.KITn=@KITn;
SELECT RadioFamilyId, KITn FROM RadioFamilyKitNumber WHERE (KITn = @KITn) AND (RadioFamilyId = @RadioFamilyId)
' 
END
GO
/****** Object:  StoredProcedure [dbo].[RadioFamilyKitNumberInsertCommand]    Script Date: 08/03/2012 18:05:18 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioFamilyKitNumberInsertCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
CREATE PROCEDURE [dbo].[RadioFamilyKitNumberInsertCommand]
(
	@RadioFamilyId int,
	@KITn varchar(50),
    @FM bit,
	@TIA4950 bit,
	@UL2504Div2 bit,
	@CSA157 bit,
	@ATEX bit,
	@NFPA bit,
	@BatteryTypeID int
)
AS
	SET NOCOUNT OFF;
INSERT INTO [radiofamilyKitNumber] ([RadioFamilyId], [KITn],[FM],[TIA4950],[UL2504Div2],[CSA157],[ATEX], [NFPA], [BatteryTypeID]) VALUES (@RadioFamilyId, @KITn,@FM,@TIA4950,@UL2504Div2,@CSA157,@ATEX,@NFPA,@BatteryTypeID);
Update Battery set RadioFamilyId=@RadioFamilyId, FM=@FM, TIA4950=@TIA4950, UL2504Div2=@UL2504Div2, CSA157=@CSA157, ATEX=@ATEX, NFPA=@NFPA where Battery.KITn=@KITn;
SELECT RadioFamilyId, KITn FROM RadioFamilyKitNumber WHERE (KITn = @KITn) AND (RadioFamilyId = @RadioFamilyId)
' 
END
GO
/****** Object:  StoredProcedure [dbo].[Calculate]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Calculate]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[Calculate] 
	-- Add the parameters for the stored procedure here
	
AS
Declare @Recondition int,
        @Update int,
        @Both int
set @Recondition=1;

set @Update=2;

set @Both=3;
--declare @DateofManufacture datetime;
--Set @DateofManufacture=DateAdd(year,-@BatteryAge,GetDate())
SET NOCOUNT ON;
Begin
Update Battery set AgeInDays=DATEDIFF(d, DateofinitialUse, CURRENT_TIMESTAMP)
where Year(DateOfManufacture)<>1970 and BatteryStatusTypeId<>2
Update Battery set DaysSinceLastRead=DATEDIFF(d, DateOfRead, CURRENT_TIMESTAMP)
where Year(DateOfRead)<>1970 and BatteryStatusTypeId<>2
Update Battery set DaysSinceInitialUse=DATEDIFF(d, DateOfInitialUse, CURRENT_TIMESTAMP),EstimatedDaysUntilNextReconditioning=dbo.EstimatedDays(RE00,RE10,RE20,RE30,RE40,RE50,RE60,RE70,RE80,RE90,WF00,WF10,WF20,WF30,WF40,WF50,WF60,WF70,WF80,WF90,DaysSinceLastReconditioning,TRIG,DateOfInitialUse,TotalIMPRESChargeCycles,TotalEstimatedNonIMPRESChargeCycles)
where Year(DateOfInitialUse)<>1970 and BatteryStatusTypeId<>2
Update Battery set RecommendationId=dbo.RecommendationExented(CompanyId,RecommendationId,DateOfRead,CapacityRatio,AgeInDays),RichTextRecommendations=dbo.RecommendationExented(CompanyId,RichTextRecommendations,DateOfRead,CapacityRatio,AgeInDays) where BatteryStatusTypeId<>2
Delete from Battery where (DateAdd(m, (select PurgeThreshold from Company),DateofInactive)< CURRENT_TIMESTAMP and BatteryStatusTypeId=0)
Delete from radiohistory where (DateAdd(m, (select HistoryPurgeThreshold from Company),DateofRegistration)< CURRENT_TIMESTAMP)
Delete from Radio where BatteryTypeID = 2 and not exists (select 1 from Battery where radio.BatterySerialNumber = battery.SerialNumber)
end
--BEGIN
--    Update battery set RecommendationId=@Recondition, RichTextRecommendations=@Recondition  where 
--    (CapacityRatio < (SELECT EOSLCapacityPercent FROM Company WHERE  CompanyId = 1 ) 
--    or  AgeInDays  > (SELECT EOSLAgeInDays FROM Company WHERE  CompanyId = 1 ))
--END
--BEGIN
--    Update battery set RecommendationId=@Update, RichTextRecommendations=@Update where 
--    SoftwareVersion<3.4
--END
--BEGIN
--    Update battery set RecommendationId=@Both,RichTextRecommendations=@Both where 
--    (CapacityRatio < (SELECT EOSLCapacityPercent FROM Company WHERE  CompanyId = 1 ) 
--    or  AgeInDays  > (SELECT EOSLAgeInDays FROM Company WHERE  CompanyId = 1 )) and SoftwareVersion<3.1
--END
--Begin
--Update Battery set RecommendationId=dbo.CreateRecommendation(DaysSinceLastReconditioning,TRIG,TemperatureC,ChargerLowTemperature,ChargerHighTemperature), RichTextRecommendations=dbo.CreateRecommendation(DaysSinceLastReconditioning,TRIG,TemperatureC,ChargerLowTemperature,ChargerHighTemperature)
--end
' 
END
GO
/****** Object:  StoredProcedure [dbo].[CompanyUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CompanyUpdateCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[CompanyUpdateCommand]
(
	@CompanyId int,
	@Name text,
	@EOSLCapacityPercent float,
    @MissingDays int,
	@EOSLAgeInDays int,
	@Original_CompanyId int,
	@IsNull_EOSLCapacityPercent Int,
	@Original_EOSLCapacityPercent float,
	@IsNull_EOSLAgeInDays Int,
	@Original_EOSLAgeInDays int,
    @IsNull_MissingDays int,
    @Original_MissingDays int,
    @OverdueThreshold int,
    @PurgeThreshold int
	, @OTAThreshold int
    , @RHOT int
    , @HistoryPurgeThreshold int
    , @RadioMissingDays int
)
AS
	SET NOCOUNT OFF;
UPDATE [Company]
SET [CompanyId] = @CompanyId, [Name] = @Name, [EOSLCapacityPercent] = @EOSLCapacityPercent
	, [EOSLAgeInDays] = @EOSLAgeInDays, [MissingDaysThreshold]=@MissingDays,[OverdueThreshold]=@OverdueThreshold,[PurgeThreshold]=@PurgeThreshold 
	, [OTAThreshold]=@OTAThreshold, [RHOT]=@RHOT , [HistoryPurgeThreshold]=@HistoryPurgeThreshold 
	, [RadioMissingDaysThreshold]=@RadioMissingDays 
WHERE [CompanyId] = @Original_CompanyId;

Update Battery set RecommendationId=dbo.RecommendationExented(CompanyId,RecommendationId,DateOfRead,CapacityRatio,AgeInDays),RichTextRecommendations=dbo.RecommendationExented(CompanyId,RichTextRecommendations,DateOfRead,CapacityRatio,AgeInDays) where BatteryStatusTypeId<>2	
SELECT CompanyId, Name, EOSLCapacityPercent, EOSLAgeInDays FROM Company WHERE (CompanyId = @Original_CompanyId)
' 
END
GO
/****** Object:  StoredProcedure [dbo].[BatteryInsertCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryInsertCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[BatteryInsertCommand]
(
	@SerialNumber varchar(50),
	@CompanyId int,
	@Alias varchar(50),
	@KITn varchar(50),
	@CHEM int,
	@BatteryStatusTypeId int,
	@BatteryGroupId int,
	@BatteryChargeStateId nvarchar(max),
	@RadioFamilyId int,
	@CurrentCharge int,
	@PotentialCapacity int,
	@RatedCapacity int,
	@CapacityRatio int,
	@DateOfManufacture datetime,
	@AgeInDays int,
	@DateOfInitialUse datetime,
	@DaysSinceLastReconditioning int,
	@DaysSinceRemovalFromCharger int,
	@TotalIMPRESChargeCycles int,
	@TotalEstimatedNonIMPRESChargeCycles int,
	@TotalEstimatedNonIMPRESChargeCyclesPrior int,
	@TotalReconditioningCycles int,
	@EstimatedDaysUntilNextReconditioning int,
	@SoftwareVersion float,
	@TemperatureC float,
	@Voltage float,
	@LED int,
	@DateOfRead datetime,
	@Recommendations nvarchar(max),
    @RichTextRecommendations nvarchar(max),
	@CA00 int,
	@CA10 int,
	@CA20 int,
	@CA30 int,
	@CA40 int,
	@CA50 int,
	@CA60 int,
	@CA70 int,
	@CA80 int,
	@CA90 int,
	@RE00 int,
	@RE10 int,
	@RE20 int,
	@RE30 int,
	@RE40 int,
	@RE50 int,
	@RE60 int,
	@RE70 int,
	@RE80 int,
	@RE90 int,
	@ComputerName varchar(50),
	@DeviceName varchar(250),
	@PocketNumber int,
	@DaysSinceLastRead int,
	@DaysSinceInitialUse int,
	@SNSR float,
	@ICA float,
	@CTS int,
	@DOIU int,
	@WF00 int,
	@WF10 int,
	@WF20 int,
	@WF30 int,
	@WF40 int,
	@WF50 int,
	@WF60 int,
	@WF70 int,
	@WF80 int,
	@WF90 int,
	@ETM int,
	@LDAY int,
	@LHR int,
	@LMIN int,
	@FDDp int,
	@DISp int,
	@TRIG int,
	@DOIC int,
	@FM bit,
    @Comment nvarchar(max),
    @ChargerLowTemperature float,
    @ChargerHighTemperature float,
    @HID int,
    @ALERTID int,
    @UnsupportedFieldsList Text,
    @ErrorFieldsList Text,
    @DateofLastRemove datetime,
    @OverdueThreshold int,
    @Charging bit
    ,@NeedToRead bit
	,@RemainingCapacityRatio int
    ,@TIA4950 bit
	,@UL2504Div2 bit
	,@CSA157 bit
	,@ATEX bit
     ,@NFPA bit
  ,@NFPAContinuousOverTemp bit
  ,@NFPACumulativeOverTemp bit
  ,@NFPAOverTempCounter int
  ,@BatteryTypeID int
)
AS
	SET NOCOUNT OFF;
--if(@OverdueHours is not null)
  INSERT INTO [battery] ([SerialNumber], [CompanyId], [Alias], [KITn], [CHEM], [BatteryStatusTypeId], [BatteryGroupId], [BatteryChargeStateId], [RadioFamilyId], [CurrentCharge], [PotentialCapacity], [RatedCapacity], [CapacityRatio], [DateOfManufacture], [AgeInDays], [DateOfInitialUse], [DaysSinceLastReconditioning], [DaysSinceRemovalFromCharger], [TotalIMPRESChargeCycles], [TotalEstimatedNonIMPRESChargeCycles], [TotalEstimatedNonIMPRESChargeCyclesPrior], [TotalReconditioningCycles], [EstimatedDaysUntilNextReconditioning], [SoftwareVersion], [TemperatureC], [Voltage], [LED], [DateOfRead], [RecommendationId], [RichTextRecommendations], [CA00], [CA10], [CA20], [CA30], [CA40], [CA50], [CA60], [CA70], [CA80], [CA90], [RE00], [RE10], [RE20], [RE30], [RE40], [RE50], [RE60], [RE70], [RE80], [RE90], [ComputerName], [DeviceName], [PocketNumber], [DaysSinceLastRead], [DaysSinceInitialUse], [SNSR], [ICA], [CTS], [DOIU], [WF00], [WF10], [WF20], [WF30], [WF40], [WF50], [WF60], [WF70], [WF80], [WF90], [ETM], [LDAY], [LHR], [LMIN], [FDDp], [DISp], [TRIG], [DOIC], [FM], [Comment], [ChargerLowTemperature], [ChargerHighTemperature], [HID],[ALERTID],[UnsupportedFieldsList],[ErrorFieldsList],[DateofLastRemove],[OverdueThreshold],[Charging],[NeedToRead], [RemainingCapacityRatio], [TIA4950], [UL2504Div2], [CSA157], [ATEX], 
  [NFPA], [NFPAContinuousOverTemp], [NFPACumulativeOverTemp], [NFPAOverTempCounter],
  [BatteryTypeID]) 
  VALUES (@SerialNumber, @CompanyId, @Alias, @KITn, @CHEM, @BatteryStatusTypeId, @BatteryGroupId, @BatteryChargeStateId, @RadioFamilyId, @CurrentCharge, @PotentialCapacity, @RatedCapacity, @CapacityRatio, @DateOfManufacture, @AgeInDays, @DateOfInitialUse, @DaysSinceLastReconditioning, @DaysSinceRemovalFromCharger, @TotalIMPRESChargeCycles, @TotalEstimatedNonIMPRESChargeCycles, @TotalEstimatedNonIMPRESChargeCyclesPrior, @TotalReconditioningCycles, @EstimatedDaysUntilNextReconditioning, @SoftwareVersion, @TemperatureC, @Voltage, @LED, @DateOfRead, dbo.RecommendationExented(@CompanyId,@Recommendations,@DateofRead,@CapacityRatio,@AgeInDays), dbo.RecommendationExented(@CompanyId,@RichTextRecommendations,@DateofRead,@CapacityRatio,@AgeInDays), @CA00, @CA10, @CA20, @CA30, @CA40, @CA50, @CA60, @CA70, @CA80, @CA90, @RE00, @RE10, @RE20, @RE30, @RE40, @RE50, @RE60, @RE70, @RE80, @RE90, @ComputerName, @DeviceName, @PocketNumber, @DaysSinceLastRead, @DaysSinceInitialUse, @SNSR, @ICA, @CTS, @DOIU, @WF00, @WF10, @WF20, @WF30, @WF40, @WF50, @WF60, @WF70, @WF80, @WF90, @ETM, @LDAY, @LHR, @LMIN, @FDDp, @DISp, @TRIG, @DOIC, @FM, @Comment, @ChargerLowTemperature, @ChargerHighTemperature, @HID,@ALERTID,@UnsupportedFieldsList,@ErrorFieldsList,@DateofLastRemove,@OverdueThreshold,@Charging,@NeedToRead, @RemainingCapacityRatio, @TIA4950, @UL2504Div2, @CSA157, @ATEX,
	@NFPA,
	@NFPAContinuousOverTemp,
	@NFPACumulativeOverTemp,
	@NFPAOverTempCounter,
	@BatteryTypeID
);
--else
--  exec(''INSERT INTO [battery] select ''''''+@SerialNumber+'''''', ''''''+@CompanyId+'''''', ''''''+@Alias+'''''', ''''''+@KITn+'''''', ''''''+@CHEM+'''''', ''''''+@BatteryStatusTypeId+'''''', ''''''+@BatteryGroupId+'''''', ''''''+@BatteryChargeStateId+'''''', ''''''+@RadioFamilyId+'''''', ''''''+@CurrentCharge+'''''', ''''''+@PotentialCapacity+'''''', ''''''+@RatedCapacity+'''''', ''''''+@CapacityRatio+'''''', ''''''+@DateOfManufacture+'''''', ''''''+@AgeInDays+'''''', ''''''+@DateOfInitialUse+'''''', ''''''+@DaysSinceLastReconditioning+'''''', ''''''+@DaysSinceRemovalFromCharger+'''''', ''''''+@TotalIMPRESChargeCycles+'''''', ''''''+@TotalEstimatedNonIMPRESChargeCycles+'''''', ''''''+@TotalEstimatedNonIMPRESChargeCyclesPrior+'''''', ''''''+@TotalReconditioningCycles+'''''', ''''''+@EstimatedDaysUntilNextReconditioning+'''''', ''''''+@SoftwareVersion+'''''', ''''''+@TemperatureC+'''''', ''''''+@Voltage+'''''', ''''''+@LED+'''''', ''''''+@DateOfRead+'''''', ''''''+@Recommendations+'''''', ''''''+@RichTextRecommendations+'''''', ''''''+@CA00+'''''', ''''''+@CA10+'''''', ''''''+@CA20+'''''', ''''''+@CA30+'''''', ''''''+@CA40+'''''', ''''''+@CA50+'''''', ''''''+@CA60+'''''', ''''''+@CA70+'''''', ''''''+@CA80+'''''', ''''''+@CA90+'''''', ''''''+@RE00+'''''', ''''''+@RE10+'''''', ''''''+@RE20+'''''', ''''''+@RE30+'''''', ''''''+@RE40+'''''', ''''''+@RE50+'''''', ''''''+@RE60+'''''', ''''''+@RE70+'''''', ''''''+@RE80+'''''', ''''''+@RE90+'''''', ''''''+@ComputerName+'''''', ''''''+@DeviceName+'''''', ''''''+@PocketNumber+'''''', ''''''+@DaysSinceLastRead+'''''', ''''''+@DaysSinceInitialUse+'''''', ''''''+@SNSR+'''''', ''''''+@ICA+'''''', ''''''+@CTS+'''''', ''''''+@DOIU+'''''', ''''''+@WF00+'''''', ''''''+@WF10+'''''', ''''''+@WF20+'''''', ''''''+@WF30+'''''', ''''''+@WF40+'''''', ''''''+@WF50+'''''', ''''''+@WF60+'''''', ''''''+@WF70+'''''', ''''''+@WF80+'''''', ''''''+@WF90+'''''', ''''''+@ETM+'''''', ''''''+@LDAY+'''''', ''''''+@LHR+'''''', ''''''+@LMIN+'''''', ''''''+@FDDp+'''''', ''''''+@DISp+'''''', ''''''+@TRIG+'''''', ''''''+@DOIC+'''''', ''''''+@FM+'''''', ''''''+@Comment+'''''', ''''''+@ChargerLowTemperature+'''''', ''''''+@ChargerHighTemperature+'''''', ''''''+@HID+'''''', ''''''+@ALERTID+'''''', ''''''+@UnsupportedFieldsList+'''''', ''''''+@ErrorFieldsList+'''''', ''''''+@DateofLastRemove+'''''', (select OverdueThreshold from Company where CompanyId=''''''+@CompanyId+'''''')'');

SELECT * FROM Battery WHERE (SerialNumber = @SerialNumber)



/****** Object:  StoredProcedure [dbo].[BatterySelectBySerialNumber]    Script Date: 10/28/2009 11:50:51 ******/
SET ANSI_NULLS ON
' 
END
GO
/****** Object:  StoredProcedure [dbo].[BatteryUpdateCommand]    Script Date: 08/03/2012 15:12:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryUpdateCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[BatteryUpdateCommand]
(
	@SerialNumber varchar(50),
	@CompanyId int,
	@Alias varchar(50),
	@KITn varchar(50),
	@CHEM int,
	@BatteryStatusTypeId int,
	@BatteryGroupId int,
	@BatteryChargeStateId nvarchar(max),
	@RadioFamilyId int,
	@CurrentCharge int,
	@PotentialCapacity int,
	@RatedCapacity int,
	@CapacityRatio int,
	@DateOfManufacture datetime,
	@AgeInDays int,
	@DateOfInitialUse datetime,
	@DaysSinceLastReconditioning int,
	@DaysSinceRemovalFromCharger int,
	@TotalIMPRESChargeCycles int,
	@TotalEstimatedNonIMPRESChargeCycles int,
	@TotalEstimatedNonIMPRESChargeCyclesPrior int,
	@TotalReconditioningCycles int,
	@EstimatedDaysUntilNextReconditioning int,
	@SoftwareVersion float,
	@TemperatureC float,
	@Voltage float,
	@LED int,
	@DateOfRead datetime,
	@Recommendations nvarchar(max),
    @RichTextRecommendations nvarchar(max),
	@CA00 int,
	@CA10 int,
	@CA20 int,
	@CA30 int,
	@CA40 int,
	@CA50 int,
	@CA60 int,
	@CA70 int,
	@CA80 int,
	@CA90 int,
	@RE00 int,
	@RE10 int,
	@RE20 int,
	@RE30 int,
	@RE40 int,
	@RE50 int,
	@RE60 int,
	@RE70 int,
	@RE80 int,
	@RE90 int,
	@ComputerName varchar(50),
	@DeviceName varchar(250),
	@PocketNumber int,
	@DaysSinceLastRead int,
	@DaysSinceInitialUse int,
	@SNSR float,
	@ICA float,
	@CTS int,
	@DOIU int,
	@WF00 int,
	@WF10 int,
	@WF20 int,
	@WF30 int,
	@WF40 int,
	@WF50 int,
	@WF60 int,
	@WF70 int,
	@WF80 int,
	@WF90 int,
	@ETM int,
	@LDAY int,
	@LHR int,
	@LMIN int,
	@FDDp int,
	@DISp int,
	@TRIG int,
	@DOIC int,
	@FM bit,
    @Comment nvarchar(max),
    @ChargerHighTemperature float, 
    @ChargerLowTemperature float,
    @HID int,
    @ALERTID int,
    @UnsupportedFieldsList Text,
    @ErrorFieldsList Text,
    @DateofLastRemove datetime,
    @OverdueThreshold int,
    @Charging bit
    ,@NeedToRead bit
	,@RemainingCapacityRatio int
    ,@TIA4950 bit
	,@UL2504Div2 bit
	,@CSA157 bit
	,@ATEX bit
	,@NFPA bit
	,@NFPAContinuousOverTemp bit
  ,@NFPACumulativeOverTemp bit
  ,@NFPAOverTempCounter int
  ,@BatteryTypeID int
)
AS
	SET NOCOUNT OFF;
--if(@OverdueHours is not null)
   declare @dateofinactive datetime
   declare @previewStatus int
   set @previewStatus=(select BatteryStatusTypeId from battery where SerialNumber=@SerialNumber)
   if(@BatteryStatusTypeId<>@previewStatus)
    begin
      if(@previewStatus=1 and @BatteryStatusTypeId=0)
        set @dateofinactive=getdate()
      else
        set @dateofinactive=NULL
    end

   UPDATE [battery] SET [SerialNumber] = @SerialNumber, [CompanyId] = @CompanyId, [Alias] = @Alias, [KITn] = @KITn, [CHEM] = @CHEM, [BatteryStatusTypeId] = @BatteryStatusTypeId, [BatteryGroupId] = @BatteryGroupId, [BatteryChargeStateId] = @BatteryChargeStateId, [RadioFamilyId] = @RadioFamilyId, [CurrentCharge] = @CurrentCharge, [PotentialCapacity] = @PotentialCapacity, [RatedCapacity] = @RatedCapacity, [CapacityRatio] = @CapacityRatio, [DateOfManufacture] = @DateOfManufacture, [AgeInDays] = @AgeInDays, [DateOfInitialUse] = @DateOfInitialUse, [DaysSinceLastReconditioning] = @DaysSinceLastReconditioning, [DaysSinceRemovalFromCharger] = @DaysSinceRemovalFromCharger, [TotalIMPRESChargeCycles] = @TotalIMPRESChargeCycles, [TotalEstimatedNonIMPRESChargeCycles] = @TotalEstimatedNonIMPRESChargeCycles, [TotalEstimatedNonIMPRESChargeCyclesPrior] = @TotalEstimatedNonIMPRESChargeCyclesPrior, [TotalReconditioningCycles] = @TotalReconditioningCycles, [EstimatedDaysUntilNextReconditioning] = @EstimatedDaysUntilNextReconditioning, [SoftwareVersion] = @SoftwareVersion, [TemperatureC] = @TemperatureC, [Voltage] = @Voltage, [LED] = @LED, [DateOfRead] = @DateOfRead, [RecommendationId] = dbo.RecommendationExented(@CompanyId,@Recommendations,@DateofRead,@CapacityRatio,@AgeInDays), [RichTextRecommendations]=dbo.RecommendationExented(@CompanyId,@RichTextRecommendations,@DateOfRead,@CapacityRatio,@AgeInDays), [CA00] = @CA00, [CA10] = @CA10, [CA20] = @CA20, [CA30] = @CA30, [CA40] = @CA40, [CA50] = @CA50, [CA60] = @CA60, [CA70] = @CA70, [CA80] = @CA80, [CA90] = @CA90, [RE00] = @RE00, [RE10] = @RE10, [RE20] = @RE20, [RE30] = @RE30, [RE40] = @RE40, [RE50] = @RE50, [RE60] = @RE60, [RE70] = @RE70, [RE80] = @RE80, [RE90] = @RE90, [ComputerName] = @ComputerName, [DeviceName] = @DeviceName, [PocketNumber] = @PocketNumber, [DaysSinceLastRead] = @DaysSinceLastRead, [DaysSinceInitialUse] = @DaysSinceInitialUse, [SNSR] = @SNSR, [ICA] = @ICA, [CTS] = @CTS, [DOIU] = @DOIU, [WF00] = @WF00, [WF10] = @WF10, [WF20] = @WF20, [WF30] = @WF30, [WF40] = @WF40, [WF50] = @WF50, [WF60] = @WF60, [WF70] = @WF70, [WF80] = @WF80, [WF90] = @WF90, [ETM] = @ETM, [LDAY] = @LDAY, [LHR] = @LHR, [LMIN] = @LMIN, [FDDp] = @FDDp, [DISp] = @DISp, [TRIG] = @TRIG, [DOIC] = @DOIC, [FM] = @FM, [Comment]=@Comment, [ChargerHighTemperature]=@ChargerHighTemperature, [ChargerLowTemperature]=@ChargerLowTemperature, [HID]=@HID, [ALERTID]=@ALERTID, [UnsupportedFieldsList]=@UnsupportedFieldsList,[ErrorFieldsList]=@ErrorFieldsList,[DateofLastRemove]=@DateofLastRemove,[OverdueThreshold]=@OverdueThreshold,[Charging]=@Charging,[DateofInactive]=@dateofinactive
, [NeedToRead]=@NeedToRead 
, [RemainingCapacityRatio] = @RemainingCapacityRatio
, [TIA4950]=@TIA4950
, [UL2504Div2]=@UL2504Div2
, [CSA157]=@CSA157
, [ATEX]=@ATEX
, [NFPA]=@NFPA
, [NFPAContinuousOverTemp]=@NFPAContinuousOverTemp
, [NFPACumulativeOverTemp]=@NFPACumulativeOverTemp
, [NFPAOverTempCounter]=@NFPAOverTempCounter
, [BatteryTypeID]=@BatteryTypeID

WHERE [SerialNumber] = @SerialNumber	
--else
--   UPDATE [battery] SET [SerialNumber] = @SerialNumber, [CompanyId] = @CompanyId, [Alias] = @Alias, [KITn] = @KITn, [CHEM] = @CHEM, [BatteryStatusTypeId] = @BatteryStatusTypeId, [BatteryGroupId] = @BatteryGroupId, [BatteryChargeStateId] = @BatteryChargeStateId, [RadioFamilyId] = @RadioFamilyId, [CurrentCharge] = @CurrentCharge, [PotentialCapacity] = @PotentialCapacity, [RatedCapacity] = @RatedCapacity, [CapacityRatio] = @CapacityRatio, [DateOfManufacture] = @DateOfManufacture, [AgeInDays] = @AgeInDays, [DateOfInitialUse] = @DateOfInitialUse, [DaysSinceLastReconditioning] = @DaysSinceLastReconditioning, [DaysSinceRemovalFromCharger] = @DaysSinceRemovalFromCharger, [TotalIMPRESChargeCycles] = @TotalIMPRESChargeCycles, [TotalEstimatedNonIMPRESChargeCycles] = @TotalEstimatedNonIMPRESChargeCycles, [TotalEstimatedNonIMPRESChargeCyclesPrior] = @TotalEstimatedNonIMPRESChargeCyclesPrior, [TotalReconditioningCycles] = @TotalReconditioningCycles, [EstimatedDaysUntilNextReconditioning] = @EstimatedDaysUntilNextReconditioning, [SoftwareVersion] = @SoftwareVersion, [TemperatureC] = @TemperatureC, [Voltage] = @Voltage, [LED] = @LED, [DateOfRead] = @DateOfRead, [RecommendationId] = @Recommendations, [RichTextRecommendations]=@RichTextRecommendations, [CA00] = @CA00, [CA10] = @CA10, [CA20] = @CA20, [CA30] = @CA30, [CA40] = @CA40, [CA50] = @CA50, [CA60] = @CA60, [CA70] = @CA70, [CA80] = @CA80, [CA90] = @CA90, [RE00] = @RE00, [RE10] = @RE10, [RE20] = @RE20, [RE30] = @RE30, [RE40] = @RE40, [RE50] = @RE50, [RE60] = @RE60, [RE70] = @RE70, [RE80] = @RE80, [RE90] = @RE90, [ComputerName] = @ComputerName, [DeviceName] = @DeviceName, [PocketNumber] = @PocketNumber, [DaysSinceLastRead] = @DaysSinceLastRead, [DaysSinceInitialUse] = @DaysSinceInitialUse, [SNSR] = @SNSR, [ICA] = @ICA, [CTS] = @CTS, [DOIU] = @DOIU, [WF00] = @WF00, [WF10] = @WF10, [WF20] = @WF20, [WF30] = @WF30, [WF40] = @WF40, [WF50] = @WF50, [WF60] = @WF60, [WF70] = @WF70, [WF80] = @WF80, [WF90] = @WF90, [ETM] = @ETM, [LDAY] = @LDAY, [LHR] = @LHR, [LMIN] = @LMIN, [FDDp] = @FDDp, [DISp] = @DISp, [TRIG] = @TRIG, [DOIC] = @DOIC, [FM] = @FM, [Comment]=@Comment, [ChargerHighTemperature]=@ChargerHighTemperature, [ChargerLowTemperature]=@ChargerLowTemperature, [HID]=@HID, [ALERTID]=@ALERTID, [UnsupportedFieldsList]=@UnsupportedFieldsList,[ErrorFieldsList]=@ErrorFieldsList,[DateofLastRemove]=@DateofLastRemove, [OverdueHours]=(select OverdueThreshold from Company where CompanyId=@CompanyId) WHERE [SerialNumber] = @SerialNumber	
SELECT SerialNumber, CompanyId, Alias, KITn, CHEM, BatteryStatusTypeId, BatteryGroupId, BatteryChargeStateId, RadioFamilyId, CurrentCharge, PotentialCapacity, RatedCapacity, CapacityRatio, DateOfManufacture, AgeInDays, DateOfInitialUse, DaysSinceLastReconditioning, DaysSinceRemovalFromCharger, TotalIMPRESChargeCycles, TotalEstimatedNonIMPRESChargeCycles, TotalEstimatedNonIMPRESChargeCyclesPrior, TotalReconditioningCycles, EstimatedDaysUntilNextReconditioning, SoftwareVersion, TemperatureC, Voltage, LED, DateOfRead, RecommendationId, CA00, CA10, CA20, CA30, CA40, CA50, CA60, CA70, CA80, CA90, RE00, RE10, RE20, RE30, RE40, RE50, RE60, RE70, RE80, RE90, ComputerName, DeviceName, PocketNumber, DaysSinceLastRead, DaysSinceInitialUse, SNSR, ICA, CTS, DOIU, WF00, WF10, WF20, WF30, WF40, WF50, WF60, WF70, WF80, WF90, ETM, LDAY, LHR, LMIN, FDDp, DISp, TRIG, DOIC, FM, Comment, ChargerLowTemperature, ChargerHighTemperature, TIA4950, UL2504Div2, CSA157, ATEX,NFPA
  FROM Battery WHERE (SerialNumber = @SerialNumber)
' 
END
GO

/****** Object:  StoredProcedure [dbo].[RadioDeleteCommand]    Script Date: 05/30/2014 14:37:32 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioDeleteCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioDeleteCommand]
(
	@RadioID varchar(50),
	@ComputerName varchar(255),
	@DeviceName varchar(250)
)
AS
	SET NOCOUNT OFF;
DELETE FROM [radio] WHERE [RadioID] = @RadioID AND [ComputerName] = @ComputerName AND [DeviceName] = @DeviceName
' 
END
GO


/****** Object:  StoredProcedure [dbo].[RadioInsertCommand]    Script Date: 05/30/2014 14:44:10 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioInsertCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioInsertCommand]
(
	@RadioIP varchar(50),
	@RadioID varchar(50),
	@RadioESN nvarchar(50),
	@RadioAlias varchar(250),
	@ComputerName varchar(250),
	@BatteryTypeID int,
	@BatterySerialNumber varchar(50),
	@TaskID int,
	@DateOfRegistration datetime,
	@DateOfRead datetime,
	@NeedToRead bit,
	@ManualReadRequest bit,
	@RHOT int,
	@DuplicateID bit,
	@RadioIDChanged varchar(50),
	@DeviceName varchar(250)
)
AS
	SET NOCOUNT OFF;
INSERT INTO [radio] ([RadioIP], [RadioID], [RadioESN], [RadioAlias], [ComputerName], [BatteryTypeID], [BatterySerialNumber], [TaskID], [DateOfRegistration], [DateOfRead], [NeedToRead], [ManualReadRequest], [RHOT], [DuplicateID], [RadioIDChanged], [DeviceName]) 
VALUES (@RadioIP, @RadioID, @RadioESN, @RadioAlias, @ComputerName, @BatteryTypeID, @BatterySerialNumber, @TaskID, @DateOfRegistration, @DateOfRead, @NeedToRead, @ManualReadRequest, @RHOT, @DuplicateID, @RadioIDChanged, @DeviceName);
	
select RadioIP
	, RadioID
	, RadioESN
	, RadioAlias
	, ComputerName
	, BatteryTypeID
	, BatterySerialNumber
	, TaskID
	, DateOfRegistration
	, DateOfRead
	, NeedToRead
	, ManualReadRequest
	, RHOT
	, DuplicateID
	, RadioIDChanged
	, DeviceName
from Radio
WHERE [RadioID] = @RadioID AND [ComputerName] = @ComputerName AND [DeviceName] = @DeviceName


' 
END
GO

/****** Object:  StoredProcedure [dbo].[RadioSelectCommand]    Script Date: 05/30/2014 14:47:41 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioSelectCommand]
AS
	SET NOCOUNT ON;
select * from radio
' 
END
GO

/****** Object:  StoredProcedure [dbo].[RadioSelectByRadioID]    Script Date: 05/30/2014 14:48:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioSelectByRadioID]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioSelectByRadioID]
(
	@RadioID varchar(50),
	@ComputerName varchar(255),
	@DeviceName varchar(250)
)
AS
	SET NOCOUNT ON;
select RadioIP
	, RadioID
	, RadioESN
	, RadioAlias
	, ComputerName
	, BatteryTypeID
	, BatterySerialNumber
	, TaskID
	, DateOfRegistration
	, DateOfRead
	, NeedToRead
	, ManualReadRequest
	, RHOT
	, DuplicateID
	, RadioIDChanged
	, DeviceName
from Radio
WHERE [RadioID] = @RadioID AND [ComputerName] = @ComputerName AND [DeviceName] = @DeviceName

' 
END
GO

/****** Object:  StoredProcedure [dbo].[RadioSelectRHOTByRadioID]    Script Date: 05/30/2014 14:48:52 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioSelectRHOTByRadioID]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioSelectRHOTByRadioID]
(
	@RadioID varchar(50),
	@ComputerName varchar(255),
	@DeviceName varchar(250)
)
AS
	SET NOCOUNT ON;

IF Exists
(
	select 1
	from Radio
	where RadioID = @RadioID 
		AND DeviceName = @DeviceName
		AND ComputerName = @ComputerName 
		AND RHOT IS NOT NULL
)
BEGIN 
	select RHOT
	from Radio
	where RadioID = @RadioID 
	  AND DeviceName = @DeviceName
		AND ComputerName = @ComputerName 
		AND RHOT IS NOT NULL
END
ELSE
BEGIN 
	select RHOT
	from company
END
' 
END
GO

/****** Object:  StoredProcedure [dbo].[RadioUpdateCommand]    Script Date: 05/30/2014 14:49:58 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioUpdateCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioUpdateCommand]
(
	@RadioIP varchar(50),
	@RadioID varchar(50),
	@RadioESN nvarchar(50),
	@RadioAlias varchar(250),
	@ComputerName varchar(250),
	@BatteryTypeID int,
	@BatterySerialNumber varchar(50),
	@TaskID int,
	@DateOfRegistration datetime,
	@DateOfRead datetime,
	@NeedToRead bit,
	@ManualReadRequest bit,
	@RHOT int,
	@DuplicateID bit,
	@RadioIDChanged varchar(50),
	@DeviceName varchar(250)
)
AS
	SET NOCOUNT OFF;
UPDATE [radio] SET [RadioIP] = @RadioIP
	, [RadioESN] = @RadioESN
	, [RadioAlias] = @RadioAlias
	, [BatteryTypeID] = @BatteryTypeID
	, [BatterySerialNumber] = @BatterySerialNumber
	, [TaskID] = @TaskID
	, [DateOfRegistration] = @DateOfRegistration
	, [DateOfRead] = @DateOfRead
	, [NeedToRead] = @NeedToRead
	, [ManualReadRequest] = @ManualReadRequest
	, [RHOT] = @RHOT 
	, [DuplicateID] = @DuplicateID 
	, [RadioIDChanged] = @RadioIDChanged 
	, [DeviceName] = @DeviceName
WHERE [RadioID] = @RadioID AND [ComputerName] = @ComputerName AND [DeviceName] = @DeviceName
	
select RadioIP
	, RadioID
	, RadioESN
	, RadioAlias
	, ComputerName
	, BatteryTypeID
	, BatterySerialNumber
	, TaskID
	, DateOfRegistration
	, DateOfRead
	, NeedToRead
	, ManualReadRequest
	, RHOT
	, DuplicateID
	, RadioIDChanged
	, DeviceName
from Radio
WHERE [RadioID] = @RadioID AND [ComputerName] = @ComputerName AND [DeviceName] = @DeviceName

' 
END
GO

/****** Object:  StoredProcedure [dbo].[RadioDeregistrationBySerialNumber]    Script Date: 05/30/2014 15:32:37 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioDeregistrationBySerialNumber]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioDeregistrationBySerialNumber]
(
	@BatterySerialNumber varchar(50)
)
AS
	SET NOCOUNT OFF;
UPDATE [radio] SET [BatteryTypeID] = 999, [BatterySerialNumber] = '''', [TaskID] = 0 
WHERE [BatterySerialNumber] = @BatterySerialNumber;

' 
END
GO

/****** Object:  StoredProcedure [dbo].[RadioSelectRadioIDChanged]    Script Date: 05/30/2014 15:32:37 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioSelectRadioIDChanged]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioSelectRadioIDChanged]
(
	@RadioID varchar(50),
	@RadioESN nvarchar(50),
	@DeviceName varchar(250)
)
AS
	SET NOCOUNT ON;

	IF OBJECT_ID(''tempdb..#tempRadioHistory'') IS NOT NULL
		DROP TABLE #tempRadioHistory

	SELECT TOP 1 RadioID, RadioESN, DeviceName
	INTO #tempRadioHistory 
	FROM RadioHistory 
	WHERE RadioESN = @RadioESN
		AND DeviceName = @DeviceName
	ORDER BY RadioHistoryID DESC

	IF Exists
	(
		SELECT 1
		FROM Radio
		WHERE RadioESN = @RadioESN 
			AND DeviceName = @DeviceName
			AND RadioID <> @RadioID 
	)
	BEGIN 
		SELECT RadioID
		FROM Radio
		WHERE RadioESN = @RadioESN 
			AND DeviceName = @DeviceName
			AND RadioID <> @RadioID 
	END
	ELSE
	BEGIN 
		IF Exists
		(
			SELECT 1
			FROM #tempRadioHistory
			WHERE RadioESN = @RadioESN 
				AND DeviceName = @DeviceName
				AND RadioID <> @RadioID 
		)
		BEGIN 
			SELECT RadioID
			FROM #tempRadioHistory
			WHERE RadioESN = @RadioESN 
			AND DeviceName = @DeviceName
				AND RadioID <> @RadioID 
		END
		ELSE
		BEGIN 
			select RadioID = ''''
		END
	END


' 
END
GO

/****** Object:  StoredProcedure [dbo].[RadioRemoveDuplicateRecord]    Script Date: 05/30/2014 15:32:37 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioRemoveDuplicateRecord]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioRemoveDuplicateRecord]
(
	@RadioID varchar(50),
	@RadioESN nvarchar(50),
	@ComputerName varchar(255),
	@DeviceName varchar(250)
)
AS
	SET NOCOUNT ON;

IF Exists
(
	SELECT 1
	FROM Radio
	WHERE RadioESN = @RadioESN 
		AND DeviceName = @DeviceName
		AND RadioID <> @RadioID 
		AND ComputerName <> @ComputerName
)
BEGIN 
	DELETE Radio 
	WHERE radioESN = @RadioESN 
		AND DeviceName = @DeviceName
		AND RadioID <> @RadioID 
		AND ComputerName <> @ComputerName
END
' 
END
GO

/****** Object:  StoredProcedure [dbo].[RadioHistoryByRadioIP]    Script Date: 05/30/2014 15:32:37 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioHistoryByRadioIP]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioHistoryByRadioIP]
(
	@RadioIP varchar(50),
	@ComputerName varchar(250)
)
AS
	SET NOCOUNT ON;
SELECT RadioHistoryID
	, RadioIP
	, RadioID
	, RadioESN
	, BatteryTypeID
	, BatterySerialNumber
	, ComputerName
	, DateOfRegistration
	, DuplicateID
	, RadioIDChanged
	, DeviceName
FROM RadioHistory where ([RadioIP] = @RadioIP and [ComputerName] = @ComputerName and [RadioHistoryID] = (SELECT max([RadioHistoryID]) FROM RadioHistory WHERE [RadioIP] = @RadioIP and [ComputerName] = @ComputerName))
' 
END
GO

/****** Object:  StoredProcedure [dbo].[TaskSelectCommand]    Script Date: 05/22/2014 17:34:05 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[TaskSelectCommand]
AS
	SET NOCOUNT ON;
select * from task
' 
END
GO

/****** Object:  StoredProcedure [dbo].[TaskInsertCommand]    Script Date: 05/22/2014 17:34:05 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskInsertCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[TaskInsertCommand]
(
	@RequestID int,
	@TaskTypeID int,
	@RadioIP varchar(50),
	@RadioID varchar(50),
	@RadioESN nvarchar(50),
	@ComputerName varchar(250),
	@BatteryTypeID int,
	@BatterySerialNumber varchar(50)
)
AS
	SET NOCOUNT OFF;
INSERT INTO [task] ([RequestID], [TaskTypeID], [RadioIP], [RadioID], [RadioESN], [ComputerName], [BatteryTypeID], [BatterySerialNumber], [TaskDateTime]) 
VALUES (@RequestID, @TaskTypeID, @RadioIP, @RadioID, @RadioESN, @ComputerName, @BatteryTypeID, @BatterySerialNumber, Getdate());

Declare @TaskID int
Select @TaskID = TaskID From Task Where (TaskID = SCOPE_IDENTITY())

Update Radio set TaskID = @TaskID, ManualReadRequest = 1 Where RadioIP = @RadioIP AND ComputerName = @ComputerName

Select @TaskID ''@TaskID''
' 
END
GO

/****** Object:  StoredProcedure [dbo].[TaskUpdateCommand]    Script Date: 05/22/2014 17:34:05 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskUpdateCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[TaskUpdateCommand]
(
	@RequestID int,
	@TaskTypeID int,
	@TaskResultTypeID int,
	@RadioIP varchar(50),
	@RadioID varchar(50),
	@RadioESN nvarchar(50),
	@ComputerName varchar(250),
	@BatteryTypeID int,
	@BatterySerialNumber varchar(50),
	@TaskDateTime datetime,
	@ResponseDateTime datetime,
	@TaskID int
)
AS
	SET NOCOUNT OFF;
UPDATE [task] SET [RequestID] = @RequestID, [TaskTypeID] = @TaskTypeID, [TaskResultTypeID] = @TaskResultTypeID, [RadioIP] = @RadioIP, [RadioID] = @RadioID, [RadioESN] = @RadioESN, [ComputerName] = @ComputerName, [BatteryTypeID] = @BatteryTypeID, [BatterySerialNumber] = @BatterySerialNumber, [TaskDateTime] = @TaskDateTime, [ResponseDateTime] = @ResponseDateTime 
WHERE [TaskID] = @TaskID;
	
SELECT TaskID, RequestID, TaskTypeID, TaskResultTypeID, RadioIP, RadioID, RadioESN, ComputerName, BatteryTypeID, BatterySerialNumber, TaskDateTime, ResponseDateTime 
FROM Task WHERE (TaskID = @TaskID)
' 
END
GO

/****** Object:  StoredProcedure [dbo].[TaskDeleteCommand]    Script Date: 05/22/2014 17:34:05 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskDeleteCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[TaskDeleteCommand]
(
	@TaskID int
)
AS
	SET NOCOUNT OFF;
DELETE FROM [task] WHERE [TaskID] = @TaskID
' 
END
GO

/****** Object:  StoredProcedure [dbo].[TaskSelectByRadioID]    Script Date: 05/22/2014 17:34:05 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskSelectByRadioID]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[TaskSelectByRadioID]
(
	@RadioID varchar(50),
	@ComputerName varchar(250),
	@DeviceName varchar(250)
)
AS
	SET NOCOUNT ON;
select task.TaskID
	, task.RequestID
	, task.TaskTypeID
	, task.TaskResultTypeID
	, task.RadioIP
	, task.RadioID
	, task.RadioESN
	, task.ComputerName
	, task.BatteryTypeID
	, task.BatterySerialNumber
	, task.TaskDateTime
	, task.ResponseDateTime from task, radio
where radio.taskid = task.taskid 
	AND radio.RadioID = task.RadioID 
	AND radio.ComputerName = task.ComputerName 
	AND radio.RadioID = @RadioID
	AND radio.ComputerName = @ComputerName
	AND radio.DeviceName = @DeviceName
' 
END
GO

/****** Object:  StoredProcedure [dbo].[TaskSelectByRequestID]    Script Date: 05/22/2014 17:34:05 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskSelectByRequestID]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[TaskSelectByRequestID]
(
	@RadioID varchar(50),
	@ComputerName varchar(250),
	@RequestID int
)
AS
	SET NOCOUNT ON;
select task.TaskID
	, task.RequestID
	, task.TaskTypeID
	, task.TaskResultTypeID
	, task.RadioIP
	, task.RadioID
	, task.RadioESN
	, task.ComputerName
	, task.BatteryTypeID
	, task.BatterySerialNumber
	, task.TaskDateTime
	, task.ResponseDateTime from task, radio
where radio.taskid = task.taskid 
	AND radio.radioID = task.radioID
	AND radio.ComputerName = task.ComputerName
	AND task.TaskResultTypeID IS NULL
	AND radio.RadioID = @RadioID 
	AND radio.ComputerName = @ComputerName 
	AND task.requestid = @RequestID
' 
END
GO

/****** Object:  StoredProcedure [dbo].[TaskSelectReadRequest]    Script Date: 05/30/2014 15:54:46 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskSelectReadRequest]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[TaskSelectReadRequest]
(
	@RadioIP varchar(50),
	@ComputerName varchar(250),
	@BatterySerialNumber varchar(50)
)
AS
	SET NOCOUNT ON;

Declare @ReadRequest int
Select @ReadRequest = 0

IF Exists
	(Select 1 From Radio 
		Where	RadioIP = @RadioIP 
				AND ComputerName = @ComputerName 
				AND NeedToRead = 1)
Begin 
	Select @ReadRequest = 1
End

IF Exists
	(Select 1 
	From Battery 
	Where SerialNumber = @BatterySerialNumber 
	AND ((NeedToRead = 1) or (Datediff(hh, dateofread, Getdate()) >= CASE WHEN Isnull(OverdueThreshold,0) > 0 THEN OverdueThreshold  ELSE (select OTAThreshold * 24 from company) END)))
Begin 
	Select @ReadRequest = 1
End

Select ReadRequest = @ReadRequest
' 
END
GO

/****** Object:  StoredProcedure [dbo].[TaskVerifyResponseTimer]    Script Date: 05/30/2014 15:54:46 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskVerifyResponseTimer]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[TaskVerifyResponseTimer]
(
	@RadioIP varchar(50),
	@ComputerName varchar(250),
	@TaskID int
)
AS
	SET NOCOUNT ON;
If Exists(
select 1 from task
where TaskID = @TaskID
	AND TaskResultTypeID is NULL 
	AND RadioIP = @RadioIP
	AND ComputerName = @ComputerName
)
Begin 
	Update task set TaskResultTypeID = 10, ResponseDateTime = Getdate()
	where TaskID = @TaskID
		AND TaskResultTypeID is NULL 
		AND RadioIP = @RadioIP
		AND ComputerName = @ComputerName

	Update radio set ManualReadRequest = 0
	from task
	where task.TaskID = @TaskID
		AND radio.RadioID = task.RadioID 
		AND radio.ComputerName = task.ComputerName 
		AND radio.RadioIP = @RadioIP
		AND radio.ComputerName = @ComputerName
		AND radio.ManualReadRequest = 1
End
' 
END
GO

/****** Object:  StoredProcedure [dbo].[TaskVerifyResponseTimer_All]    Script Date: 05/30/2014 15:54:46 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskVerifyResponseTimer_All]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[TaskVerifyResponseTimer_All]
AS

SET NOCOUNT ON;
If Exists(
select 1 from task, radio
where radio.taskid = task.taskid 
	AND radio.RadioID = task.RadioID 
	AND radio.ComputerName = task.ComputerName 
	AND task.TaskResultTypeID is NULL
	AND Dateadd(s, 300, task.TaskDateTime) < CURRENT_TIMESTAMP
)
Begin 
	Update radio set ManualReadRequest = 0
	from task
	where radio.taskid = task.taskid 
		AND radio.RadioID = task.RadioID 
		AND radio.ComputerName = task.ComputerName 
		AND task.TaskResultTypeID is NULL
		AND Dateadd(s, 300, task.TaskDateTime) < CURRENT_TIMESTAMP
		AND radio.ManualReadRequest = 1

	Update task set TaskResultTypeID = 10, ResponseDateTime = Getdate()
	from radio
	where radio.taskid = task.taskid 
		AND radio.RadioID = task.RadioID 
		AND radio.ComputerName = task.ComputerName 
		AND task.TaskResultTypeID is NULL
		AND Dateadd(s, 300, task.TaskDateTime) < CURRENT_TIMESTAMP
End
' 
END
GO

/****** Object:  StoredProcedure [dbo].[RadioHistorySelectCommand]    Script Date: 05/22/2014 17:34:05 ******/
/****** JIRA Ticket: BFM-231 - DC customer database crashes 3.5 GUI ******/
/****** This Stored Procedure is redundant hence we only select one row from the RadioHistory database table ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioHistorySelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioHistorySelectCommand]
AS
	SET NOCOUNT ON;
SELECT TOP 1 * FROM RadioHistory
' 
END
GO

/****** Object:  StoredProcedure [dbo].[RadioHistoryInsertCommand]    Script Date: 05/22/2014 17:34:05 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioHistoryInsertCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioHistoryInsertCommand]
(
	@RadioIP varchar(50),
	@RadioID varchar(50),
	@RadioESN nvarchar(50),
	@BatteryTypeID int,
	@BatterySerialNumber varchar(50),
	@ComputerName varchar(250),
	@DateOfRegistration datetime,
	@DuplicateID bit,
	@RadioIDChanged varchar(50),
	@DeviceName varchar(250)
)
AS
	SET NOCOUNT OFF;
INSERT INTO [radiohistory] ([RadioIP], [RadioID], [RadioESN], [BatteryTypeID], [BatterySerialNumber], [ComputerName], [DateOfRegistration], [DuplicateID], [RadioIDChanged], [DeviceName]) 
VALUES (@RadioIP, @RadioID, @RadioESN, @BatteryTypeID, @BatterySerialNumber, @ComputerName, @DateOfRegistration, @DuplicateID, @RadioIDChanged, @DeviceName);
	
SELECT RadioHistoryID
	, RadioIP
	, RadioID
	, RadioESN
	, BatteryTypeID
	, BatterySerialNumber
	, ComputerName
	, DateOfRegistration
	, DuplicateID
	, RadioIDChanged 
	, DeviceName
FROM RadioHistory WHERE (RadioHistoryID = SCOPE_IDENTITY())
' 
END
GO

/****** Object:  StoredProcedure [dbo].[RadioHistoryUpdateCommand]    Script Date: 05/22/2014 17:34:05 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioHistoryUpdateCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioHistoryUpdateCommand]
(
	@RadioIP varchar(50),
	@RadioID varchar(50),
	@RadioESN nvarchar(50),
	@BatteryTypeID int,
	@BatterySerialNumber varchar(50),
	@ComputerName varchar(250),
	@DateOfRegistration datetime,
	@DuplicateID bit,
	@RadioIDChanged varchar(50),
	@RadioHistoryID int,
	@DeviceName varchar(250)
)
AS
	SET NOCOUNT OFF;
UPDATE [radiohistory] SET [RadioIP] = @RadioIP, [RadioID] = @RadioID, [RadioESN] = @RadioESN, [BatteryTypeID] = @BatteryTypeID, [BatterySerialNumber] = @BatterySerialNumber, [ComputerName] = @ComputerName, [DateOfRegistration] = @DateOfRegistration , [DuplicateID] = @DuplicateID , [RadioIDChanged] = @RadioIDChanged , [DeviceName] = @DeviceName 
WHERE [RadioHistoryID] = @RadioHistoryID;
	
SELECT RadioHistoryID
	, RadioIP
	, RadioID
	, RadioESN
	, BatteryTypeID
	, BatterySerialNumber
	, ComputerName
	, DateOfRegistration
	, DuplicateID
	, RadioIDChanged 
	, DeviceName
FROM RadioHistory WHERE (RadioHistoryID = @RadioHistoryID)
' 
END
GO

/****** Object:  StoredProcedure [dbo].[RadioHistoryDeleteCommand]    Script Date: 05/22/2014 17:34:05 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioHistoryDeleteCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioHistoryDeleteCommand]
(
	@RadioID varchar(50),
	@ComputerName varchar(250),
	@DeviceName varchar(250)
)
AS
	SET NOCOUNT OFF;
DELETE FROM [radiohistory] WHERE ([RadioID] = @RadioID AND ComputerName = @ComputerName AND [DeviceName] = @DeviceName)
' 
END
GO

/****** Object:  StoredProcedure [dbo].[RadioHistorySelectByRadioID]    Script Date: 05/22/2014 17:34:05 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioHistorySelectByRadioID]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioHistorySelectByRadioID]
(
	@RadioIP varchar(50)
)
AS
	SET NOCOUNT ON;
	
SELECT RadioHistoryID
	, RadioIP
	, RadioID
	, RadioESN
	, BatteryTypeID
	, BatterySerialNumber
	, ComputerName
	, DateOfRegistration
	, DuplicateID
	, RadioIDChanged 
from radiohistory where ([RadioIP] = @RadioIP)
' 
END
GO

/****** Object:  StoredProcedure [dbo].[RadioHistorySelectByBatterySerialNumber]    Script Date: 05/22/2014 17:34:05 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RadioHistorySelectByBatterySerialNumber]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RadioHistorySelectByBatterySerialNumber]
(
	@BatterySerialNumber varchar(50)
)
AS
	SET NOCOUNT ON;
SELECT RadioHistoryID
	, RadioIP
	, RadioID
	, RadioESN
	, BatteryTypeID
	, BatterySerialNumber
	, ComputerName
	, DateOfRegistration
	, DuplicateID
	, RadioIDChanged 
from radiohistory where ([BatterySerialNumber] = @BatterySerialNumber)
' 
END
GO

/****** Object:  StoredProcedure [dbo].[BatteryTypeSelectCommand]    Script Date: 06/10/2014 13:27:31 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatteryTypeSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[BatteryTypeSelectCommand]
@Language nvarchar(max)
AS
	SET NOCOUNT ON;
if exists (select * from Translation where [Language]=@Language)
Select BatteryTypeId, T.Value as [Name] from BatteryType left join (Select * from Translation where [Language]=@Language) as T on BatteryType.Name=T.English
else
Select * From BatteryType
' 
END
GO

/****** Object:  StoredProcedure [dbo].[TaskTypeSelectCommand]    Script Date: 06/10/2014 13:27:31 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskTypeSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[TaskTypeSelectCommand]
@Language nvarchar(max)
AS
	SET NOCOUNT ON;
if exists (select * from Translation where [Language]=@Language)
Select TaskTypeId, T.Value as [Name] from TaskType left join (Select * from Translation where [Language]=@Language) as T on TaskType.Name=T.English
else
Select * From TaskType
' 
END
GO

/****** Object:  StoredProcedure [dbo].[TaskResultTypeSelectCommand]    Script Date: 06/10/2014 13:27:31 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TaskResultTypeSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[TaskResultTypeSelectCommand]
@Language nvarchar(max)
AS
	SET NOCOUNT ON;
if exists (select * from Translation where [Language]=@Language)
Select TaskResultTypeId, T.Value as [Name] from TaskResultType left join (Select * from Translation where [Language]=@Language) as T on TaskResultType.Name=T.English
else
Select * From TaskResultType
' 
END
GO

/****** Object:  StoredProcedure [dbo].[FilterDeleteCommand]    Script Date: 9/10/2024 10:26:16 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FilterDeleteCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[FilterDeleteCommand] AS' 
END
GO
ALTER PROCEDURE [dbo].[FilterDeleteCommand]
(
	@Original_FilterName nchar(100),
	@IsNull_FieldName Int,
	@Original_FieldName nchar(1000),
	@IsNull_Operator Int,
	@Original_Operator nchar(1000),
	@IsNull_Value Int,
	@Original_Value nchar(1000),
	@IsNull_DateCreated Int,
	@Original_DateCreated datetime
)
AS
	SET NOCOUNT OFF;
DELETE FROM [Filter] WHERE (([FilterName] = @Original_FilterName) AND ((@IsNull_FieldName = 1 AND [FieldName] IS NULL) OR ([FieldName] = @Original_FieldName)) AND ((@IsNull_Operator = 1 AND [Operator] IS NULL) OR ([Operator] = @Original_Operator)) AND ((@IsNull_Value = 1 AND [Value] IS NULL) OR ([Value] = @Original_Value)) AND ((@IsNull_DateCreated = 1 AND [DateCreated] IS NULL) OR ([DateCreated] = @Original_DateCreated)))
GO
/****** Object:  StoredProcedure [dbo].[FilterInsertCommand]    Script Date: 9/10/2024 10:26:16 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FilterInsertCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[FilterInsertCommand] AS' 
END
GO
ALTER PROCEDURE [dbo].[FilterInsertCommand]
(
	@FilterName nchar(100),
	@FieldName nchar(1000),
	@Operator nchar(1000),
	@Value nchar(1000),
	@DateCreated datetime
)
AS
	SET NOCOUNT OFF;
INSERT INTO [Filter] ([FilterName], [FieldName], [Operator], [Value], [DateCreated]) VALUES (@FilterName, @FieldName, @Operator, @Value, @DateCreated);
	
SELECT FilterName, FieldName, Operator, Value, DateCreated FROM Filter WHERE (FilterName = @FilterName)
GO
/****** Object:  StoredProcedure [dbo].[FilterSelectCommand]    Script Date: 9/10/2024 10:26:16 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FilterSelectCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[FilterSelectCommand] AS' 
END
GO
ALTER PROCEDURE [dbo].[FilterSelectCommand]
AS
	SET NOCOUNT ON;
SELECT FilterName, FieldName, Operator, Value, DateCreated
FROM   Filter
GO
/****** Object:  StoredProcedure [dbo].[FilterUpdateCommand]    Script Date: 9/10/2024 10:26:16 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FilterUpdateCommand]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[FilterUpdateCommand] AS' 
END
GO
ALTER PROCEDURE [dbo].[FilterUpdateCommand]
(
	@FilterName nchar(100),
	@FieldName nchar(1000),
	@Operator nchar(1000),
	@Value nchar(1000),
	@DateCreated datetime,
	@Original_FilterName nchar(100),
	@IsNull_FieldName Int,
	@Original_FieldName nchar(1000),
	@IsNull_Operator Int,
	@Original_Operator nchar(1000),
	@IsNull_Value Int,
	@Original_Value nchar(1000),
	@IsNull_DateCreated Int,
	@Original_DateCreated datetime
)
AS
	SET NOCOUNT OFF;
UPDATE [Filter] SET [FilterName] = @FilterName, [FieldName] = @FieldName, [Operator] = @Operator, [Value] = @Value, [DateCreated] = @DateCreated WHERE (([FilterName] = @Original_FilterName) AND ((@IsNull_FieldName = 1 AND [FieldName] IS NULL) OR ([FieldName] = @Original_FieldName)) AND ((@IsNull_Operator = 1 AND [Operator] IS NULL) OR ([Operator] = @Original_Operator)) AND ((@IsNull_Value = 1 AND [Value] IS NULL) OR ([Value] = @Original_Value)) AND ((@IsNull_DateCreated = 1 AND [DateCreated] IS NULL) OR ([DateCreated] = @Original_DateCreated)));
	
SELECT FilterName, FieldName, Operator, Value, DateCreated FROM Filter WHERE (FilterName = @FilterName)
GO

/****** Object:  Default [DF_AlertInfoTable_AlertId]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_AlertInfoTable_AlertId]') AND parent_object_id = OBJECT_ID(N'[dbo].[AlertInfo]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_AlertInfoTable_AlertId]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[AlertInfo] ADD  CONSTRAINT [DF_AlertInfoTable_AlertId]  DEFAULT ((0)) FOR [AlertId]
END


End
GO
/****** Object:  Default [DF_Battery1_CompanyId]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CompanyId]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CompanyId]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CompanyId]  DEFAULT ((1)) FOR [CompanyId]
END


End
GO
/****** Object:  Default [DF_Battery1_Alias]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_Alias]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_Alias]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_Alias]  DEFAULT ('') FOR [Alias]
END


End
GO
/****** Object:  Default [DF_Battery1_KITn]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_KITn]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_KITn]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_KITn]  DEFAULT ('') FOR [KITn]
END


End
GO
/****** Object:  Default [DF_Battery1_CHEM]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CHEM]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CHEM]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CHEM]  DEFAULT ((0)) FOR [CHEM]
END


End
GO
/****** Object:  Default [DF_Battery1_BatteryStatusTypeId]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_BatteryStatusTypeId]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_BatteryStatusTypeId]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_BatteryStatusTypeId]  DEFAULT ((1)) FOR [BatteryStatusTypeId]
END


End
GO
/****** Object:  Default [DF_Battery1_BatteryGroupId]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_BatteryGroupId]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_BatteryGroupId]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_BatteryGroupId]  DEFAULT ((0)) FOR [BatteryGroupId]
END


End
GO
/****** Object:  Default [DF_Battery1_BatteryChargeStateId]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_BatteryChargeStateId]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_BatteryChargeStateId]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_BatteryChargeStateId]  DEFAULT ((0)) FOR [BatteryChargeStateId]
END


End
GO
/****** Object:  Default [DF_Battery1_RadioFamilyId]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_RadioFamilyId]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_RadioFamilyId]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_RadioFamilyId]  DEFAULT ((0)) FOR [RadioFamilyId]
END


End
GO
/****** Object:  Default [DF_Battery1_CurrentCharge]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CurrentCharge]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CurrentCharge]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CurrentCharge]  DEFAULT ((0)) FOR [CurrentCharge]
END


End
GO
/****** Object:  Default [DF_Battery1_PotentialCapacity]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_PotentialCapacity]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_PotentialCapacity]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_PotentialCapacity]  DEFAULT ((0)) FOR [PotentialCapacity]
END


End
GO
/****** Object:  Default [DF_Battery1_RatedCapacity]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_RatedCapacity]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_RatedCapacity]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_RatedCapacity]  DEFAULT ((0)) FOR [RatedCapacity]
END


End
GO
/****** Object:  Default [DF_Battery1_CapacityRatio]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CapacityRatio]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CapacityRatio]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CapacityRatio]  DEFAULT ((0)) FOR [CapacityRatio]
END


End
GO
/****** Object:  Default [DF_Battery_RemainingCapacityRatio]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_RemainingCapacityRatio]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_RemainingCapacityRatio]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_RemainingCapacityRatio]  DEFAULT ((0)) FOR [RemainingCapacityRatio]
END


End
GO
/****** Object:  Default [DF_Table_1_DOM]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Table_1_DOM]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Table_1_DOM]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Table_1_DOM]  DEFAULT ('1/1/1900') FOR [DateOfManufacture]
END


End
GO
/****** Object:  Default [DF_Battery1_AgeInDays]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_AgeInDays]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_AgeInDays]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_AgeInDays]  DEFAULT ((0)) FOR [AgeInDays]
END


End
GO
/****** Object:  Default [DF_Battery1_DateOfInitialUse]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_DateOfInitialUse]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_DateOfInitialUse]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_DateOfInitialUse]  DEFAULT ('1/1/1900') FOR [DateOfInitialUse]
END


End
GO
/****** Object:  Default [DF_Battery1_DaysSinceLastReconditioning]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_DaysSinceLastReconditioning]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_DaysSinceLastReconditioning]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_DaysSinceLastReconditioning]  DEFAULT ((0)) FOR [DaysSinceLastReconditioning]
END


End
GO
/****** Object:  Default [DF_Battery1_DaysSinceRemovalFromCharger]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_DaysSinceRemovalFromCharger]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_DaysSinceRemovalFromCharger]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_DaysSinceRemovalFromCharger]  DEFAULT ((0)) FOR [DaysSinceRemovalFromCharger]
END


End
GO
/****** Object:  Default [DF_Battery1_TotalIMPRESChargeCycles]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_TotalIMPRESChargeCycles]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_TotalIMPRESChargeCycles]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_TotalIMPRESChargeCycles]  DEFAULT ((0)) FOR [TotalIMPRESChargeCycles]
END


End
GO
/****** Object:  Default [DF_Battery1_TotalEstimatedNonIMPRESChargeCycles]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_TotalEstimatedNonIMPRESChargeCycles]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_TotalEstimatedNonIMPRESChargeCycles]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_TotalEstimatedNonIMPRESChargeCycles]  DEFAULT ((0)) FOR [TotalEstimatedNonIMPRESChargeCycles]
END


End
GO
/****** Object:  Default [DF_Battery1_TotalEstimatedNonIMPRESChargeCyclesPrior]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_TotalEstimatedNonIMPRESChargeCyclesPrior]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_TotalEstimatedNonIMPRESChargeCyclesPrior]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_TotalEstimatedNonIMPRESChargeCyclesPrior]  DEFAULT ((0)) FOR [TotalEstimatedNonIMPRESChargeCyclesPrior]
END


End
GO
/****** Object:  Default [DF_Battery1_TotalReconditioningCycles]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_TotalReconditioningCycles]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_TotalReconditioningCycles]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_TotalReconditioningCycles]  DEFAULT ((0)) FOR [TotalReconditioningCycles]
END


End
GO
/****** Object:  Default [DF_Battery1_SoftwareVersion]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_SoftwareVersion]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_SoftwareVersion]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_SoftwareVersion]  DEFAULT ((0)) FOR [SoftwareVersion]
END


End
GO
/****** Object:  Default [DF_Battery1_TemperatureC]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_TemperatureC]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_TemperatureC]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_TemperatureC]  DEFAULT ((0)) FOR [TemperatureC]
END


End
GO
/****** Object:  Default [DF_Battery1_Voltage]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_Voltage]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_Voltage]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_Voltage]  DEFAULT ((0)) FOR [Voltage]
END


End
GO
/****** Object:  Default [DF_Battery1_LED]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_LED]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_LED]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_LED]  DEFAULT ((0)) FOR [LED]
END


End
GO
/****** Object:  Default [DF_Battery1_DateOfRead]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_DateOfRead]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_DateOfRead]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_DateOfRead]  DEFAULT ('1/1/1900') FOR [DateOfRead]
END


End
GO
/****** Object:  Default [DF_Battery_RichTextRecommendations]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_RichTextRecommendations]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_RichTextRecommendations]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_RichTextRecommendations]  DEFAULT ((0)) FOR [RichTextRecommendations]
END


End
GO
/****** Object:  Default [DF_Battery1_CA00]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CA00]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CA00]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CA00]  DEFAULT ((0)) FOR [CA00]
END


End
GO
/****** Object:  Default [DF_Battery1_CA10]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CA10]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CA10]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CA10]  DEFAULT ((0)) FOR [CA10]
END


End
GO
/****** Object:  Default [DF_Battery1_CA20]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CA20]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CA20]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CA20]  DEFAULT ((0)) FOR [CA20]
END


End
GO
/****** Object:  Default [DF_Battery1_CA30]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CA30]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CA30]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CA30]  DEFAULT ((0)) FOR [CA30]
END


End
GO
/****** Object:  Default [DF_Battery1_CA40]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CA40]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CA40]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CA40]  DEFAULT ((0)) FOR [CA40]
END


End
GO
/****** Object:  Default [DF_Battery1_CA50]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CA50]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CA50]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CA50]  DEFAULT ((0)) FOR [CA50]
END


End
GO
/****** Object:  Default [DF_Battery1_CA60]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CA60]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CA60]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CA60]  DEFAULT ((0)) FOR [CA60]
END


End
GO
/****** Object:  Default [DF_Battery1_CA70]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CA70]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CA70]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CA70]  DEFAULT ((0)) FOR [CA70]
END


End
GO
/****** Object:  Default [DF_Battery1_CA80]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CA80]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CA80]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CA80]  DEFAULT ((0)) FOR [CA80]
END


End
GO
/****** Object:  Default [DF_Battery1_CA90]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CA90]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CA90]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CA90]  DEFAULT ((0)) FOR [CA90]
END


End
GO
/****** Object:  Default [DF_Battery1_CR00]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CR00]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CR00]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CR00]  DEFAULT ((0)) FOR [RE00]
END


End
GO
/****** Object:  Default [DF_Battery1_CR10]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CR10]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CR10]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CR10]  DEFAULT ((0)) FOR [RE10]
END


End
GO
/****** Object:  Default [DF_Battery1_CR20]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CR20]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CR20]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CR20]  DEFAULT ((0)) FOR [RE20]
END


End
GO
/****** Object:  Default [DF_Battery1_CR30]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CR30]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CR30]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CR30]  DEFAULT ((0)) FOR [RE30]
END


End
GO
/****** Object:  Default [DF_Battery1_CR40]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CR40]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CR40]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CR40]  DEFAULT ((0)) FOR [RE40]
END


End
GO
/****** Object:  Default [DF_Battery1_CR50]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CR50]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CR50]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CR50]  DEFAULT ((0)) FOR [RE50]
END


End
GO
/****** Object:  Default [DF_Battery1_CR60]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CR60]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CR60]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CR60]  DEFAULT ((0)) FOR [RE60]
END


End
GO
/****** Object:  Default [DF_Battery1_CR70]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CR70]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CR70]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CR70]  DEFAULT ((0)) FOR [RE70]
END


End
GO
/****** Object:  Default [DF_Battery1_CR80]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CR80]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CR80]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CR80]  DEFAULT ((0)) FOR [RE80]
END


End
GO
/****** Object:  Default [DF_Battery1_CR90]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery1_CR90]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery1_CR90]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery1_CR90]  DEFAULT ((0)) FOR [RE90]
END


End
GO
/****** Object:  Default [DF_Battery_DaysSinceLastRead]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_DaysSinceLastRead]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_DaysSinceLastRead]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_DaysSinceLastRead]  DEFAULT ((0)) FOR [DaysSinceLastRead]
END


End
GO
/****** Object:  Default [DF_Battery_DaysSinceInitialUse]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_DaysSinceInitialUse]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_DaysSinceInitialUse]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_DaysSinceInitialUse]  DEFAULT ((0)) FOR [DaysSinceInitialUse]
END


End
GO
/****** Object:  Default [DF_Battery_SNSR]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_SNSR]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_SNSR]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_SNSR]  DEFAULT ((0)) FOR [SNSR]
END


End
GO
/****** Object:  Default [DF_Battery_ICA]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_ICA]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_ICA]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_ICA]  DEFAULT ((0)) FOR [ICA]
END


End
GO
/****** Object:  Default [DF_Battery_CTS]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_CTS]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_CTS]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_CTS]  DEFAULT ((0)) FOR [CTS]
END


End
GO
/****** Object:  Default [DF_Battery_DOIU]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_DOIU]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_DOIU]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_DOIU]  DEFAULT ((0)) FOR [DOIU]
END


End
GO
/****** Object:  Default [DF_Battery_WF00]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_WF00]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_WF00]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_WF00]  DEFAULT ((0)) FOR [WF00]
END


End
GO
/****** Object:  Default [DF_Battery_WF10]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_WF10]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_WF10]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_WF10]  DEFAULT ((0)) FOR [WF10]
END


End
GO
/****** Object:  Default [DF_Battery_WF20]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_WF20]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_WF20]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_WF20]  DEFAULT ((0)) FOR [WF20]
END


End
GO
/****** Object:  Default [DF_Battery_WF30]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_WF30]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_WF30]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_WF30]  DEFAULT ((0)) FOR [WF30]
END


End
GO
/****** Object:  Default [DF_Battery_WF40]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_WF40]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_WF40]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_WF40]  DEFAULT ((0)) FOR [WF40]
END


End
GO
/****** Object:  Default [DF_Battery_WF50]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_WF50]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_WF50]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_WF50]  DEFAULT ((0)) FOR [WF50]
END


End
GO
/****** Object:  Default [DF_Battery_WF60]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_WF60]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_WF60]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_WF60]  DEFAULT ((0)) FOR [WF60]
END


End
GO
/****** Object:  Default [DF_Battery_WF70]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_WF70]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_WF70]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_WF70]  DEFAULT ((0)) FOR [WF70]
END


End
GO
/****** Object:  Default [DF_Battery_WF80]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_WF80]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_WF80]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_WF80]  DEFAULT ((0)) FOR [WF80]
END


End
GO
/****** Object:  Default [DF_Battery_WF90]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_WF90]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_WF90]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_WF90]  DEFAULT ((0)) FOR [WF90]
END


End
GO
/****** Object:  Default [DF_Battery_ETM]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_ETM]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_ETM]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_ETM]  DEFAULT ((0)) FOR [ETM]
END


End
GO
/****** Object:  Default [DF_Battery_LDAY]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_LDAY]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_LDAY]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_LDAY]  DEFAULT ((0)) FOR [LDAY]
END


End
GO
/****** Object:  Default [DF_Battery_LHR]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_LHR]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_LHR]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_LHR]  DEFAULT ((0)) FOR [LHR]
END


End
GO
/****** Object:  Default [DF_Battery_LMIN]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_LMIN]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_LMIN]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_LMIN]  DEFAULT ((0)) FOR [LMIN]
END


End
GO
/****** Object:  Default [DF_Battery_FDDp]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_FDDp]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_FDDp]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_FDDp]  DEFAULT ((0)) FOR [FDDp]
END


End
GO
/****** Object:  Default [DF_Battery_DISp]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_DISp]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_DISp]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_DISp]  DEFAULT ((0)) FOR [DISp]
END


End
GO
/****** Object:  Default [DF_Battery_TRIG]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_TRIG]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_TRIG]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_TRIG]  DEFAULT ((0)) FOR [TRIG]
END


End
GO
/****** Object:  Default [DF_Battery_DOIC]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_DOIC]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_DOIC]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_DOIC]  DEFAULT ((0)) FOR [DOIC]
END


End
GO
/****** Object:  Default [DF_Battery_ALERTID]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_ALERTID]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_ALERTID]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_ALERTID]  DEFAULT ((0)) FOR [ALERTID]
END


End
GO
/****** Object:  Default [DF_Battery_NeedToRead]    Script Date: 04/14/2014 15:48:39 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Battery_NeedToRead]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Battery_NeedToRead]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Battery] ADD  CONSTRAINT [DF_Battery_NeedToRead]  DEFAULT ((0)) FOR [NeedToRead]
End

End
GO
/****** Object:  Default [DF_Company_Name]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Company_Name]') AND parent_object_id = OBJECT_ID(N'[dbo].[Company]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Company_Name]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Company] ADD  CONSTRAINT [DF_Company_Name]  DEFAULT ('') FOR [Name]
END


End
GO
/****** Object:  Default [DF_Company_EOSLCapacityPercent]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Company_EOSLCapacityPercent]') AND parent_object_id = OBJECT_ID(N'[dbo].[Company]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Company_EOSLCapacityPercent]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Company] ADD  CONSTRAINT [DF_Company_EOSLCapacityPercent]  DEFAULT ((0)) FOR [EOSLCapacityPercent]
END


End
GO
/****** Object:  Default [DF_Company_EOSLAgeInDays]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Company_EOSLAgeInDays]') AND parent_object_id = OBJECT_ID(N'[dbo].[Company]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Company_EOSLAgeInDays]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Company] ADD  CONSTRAINT [DF_Company_EOSLAgeInDays]  DEFAULT ((0)) FOR [EOSLAgeInDays]
END


End
GO
/****** Object:  Default [DF_Company_MissingDaysThreshold]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Company_MissingDaysThreshold]') AND parent_object_id = OBJECT_ID(N'[dbo].[Company]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Company_MissingDaysThreshold]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Company] ADD  CONSTRAINT [DF_Company_MissingDaysThreshold]  DEFAULT ((0)) FOR [MissingDaysThreshold]
END


End
GO
/****** Object:  Default [DF_Company_OverdueThreshold]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Company_OverdueThreshold]') AND parent_object_id = OBJECT_ID(N'[dbo].[Company]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Company_OverdueThreshold]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Company] ADD  CONSTRAINT [DF_Company_OverdueThreshold]  DEFAULT ((0)) FOR [OverdueThreshold]
END


End
GO
/****** Object:  Default [DF_Company_PurgeThreshold]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Company_PurgeThreshold]') AND parent_object_id = OBJECT_ID(N'[dbo].[Company]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Company_PurgeThreshold]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Company] ADD  CONSTRAINT [DF_Company_PurgeThreshold]  DEFAULT ((0)) FOR [PurgeThreshold]
END


End
GO
/****** Object:  Default [DF_Company_OTAThreshold]    Script Date: 04/14/2014 15:18:07 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Company_OTAThreshold]') AND parent_object_id = OBJECT_ID(N'[dbo].[Company]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Company_OTAThreshold]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Company] ADD  CONSTRAINT [DF_Company_OTAThreshold]  DEFAULT ((0)) FOR [OTAThreshold]
End

End
GO
/****** Object:  Default [DF_Company_RHOT]    Script Date: 04/14/2014 15:18:07 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Company_RHOT]') AND parent_object_id = OBJECT_ID(N'[dbo].[Company]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Company_RHOT]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Company] ADD  CONSTRAINT [DF_Company_RHOT]  DEFAULT ((0)) FOR [RHOT]
End

End
GO
/****** Object:  Default [DF_Company_HistoryPurgeThreshold]    Script Date: 04/14/2014 15:18:07 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Company_HistoryPurgeThreshold]') AND parent_object_id = OBJECT_ID(N'[dbo].[Company]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Company_HistoryPurgeThreshold]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Company] ADD  CONSTRAINT [DF_Company_HistoryPurgeThreshold]  DEFAULT ((0)) FOR [HistoryPurgeThreshold]
End

End
GO
/****** Object:  Default [DF_Company_RadioMissingDaysThreshold]    Script Date: 04/14/2014 15:18:07 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Company_RadioMissingDaysThreshold]') AND parent_object_id = OBJECT_ID(N'[dbo].[Company]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Company_RadioMissingDaysThreshold]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Company] ADD  CONSTRAINT [DF_Company_RadioMissingDaysThreshold]  DEFAULT ((0)) FOR [RadioMissingDaysThreshold]
End

End
GO
/****** Object:  Default [DF_Device_IsConnected]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Device_IsConnected]') AND parent_object_id = OBJECT_ID(N'[dbo].[Device]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Device_IsConnected]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Device] ADD  CONSTRAINT [DF_Device_IsConnected]  DEFAULT ((0)) FOR [IsConnected]
END


End
GO
/****** Object:  Default [DF_Device_NumberOfPockets]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Device_NumberOfPockets]') AND parent_object_id = OBJECT_ID(N'[dbo].[Device]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Device_NumberOfPockets]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Device] ADD  CONSTRAINT [DF_Device_NumberOfPockets]  DEFAULT ((1)) FOR [NumberOfPockets]
END


End
GO
/****** Object:  Default [DF_Location_IsConnected]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_Location_IsConnected]') AND parent_object_id = OBJECT_ID(N'[dbo].[Location]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_Location_IsConnected]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[Location] ADD  CONSTRAINT [DF_Location_IsConnected]  DEFAULT ((0)) FOR [IsConnected]
END


End
GO
/****** Object:  Default [DF_View_IsShowParaDialog]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_View_IsShowParaDialog]') AND parent_object_id = OBJECT_ID(N'[dbo].[View]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_View_IsShowParaDialog]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[View] ADD  CONSTRAINT [DF_View_IsShowParaDialog]  DEFAULT ((0)) FOR [IsShowParaDialog]
END


End
GO
/****** Object:  Default [DF_View_IsUseRowfilter]    Script Date: 08/03/2012 15:12:53 ******/
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[dbo].[DF_View_IsUseRowfilter]') AND parent_object_id = OBJECT_ID(N'[dbo].[View]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_View_IsUseRowfilter]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[View] ADD  CONSTRAINT [DF_View_IsUseRowfilter]  DEFAULT ((1)) FOR [IsUseRowfilter]
END


End
GO
/****** Object:  ForeignKey [Company_Battery]    Script Date: 08/03/2012 15:12:53 ******/
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[Company_Battery]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
ALTER TABLE [dbo].[Battery]  WITH CHECK ADD  CONSTRAINT [Company_Battery] FOREIGN KEY([CompanyId])
REFERENCES [dbo].[Company] ([CompanyId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[Company_Battery]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
ALTER TABLE [dbo].[Battery] CHECK CONSTRAINT [Company_Battery]
GO
/****** Object:  ForeignKey [FK_Battery_AlertInfo]    Script Date: 08/03/2012 15:12:53 ******/
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Battery_AlertInfo]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
ALTER TABLE [dbo].[Battery]  WITH CHECK ADD  CONSTRAINT [FK_Battery_AlertInfo] FOREIGN KEY([ALERTID])
REFERENCES [dbo].[AlertInfo] ([AlertId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Battery_AlertInfo]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
ALTER TABLE [dbo].[Battery] CHECK CONSTRAINT [FK_Battery_AlertInfo]
GO
/****** Object:  ForeignKey [FK_Battery_Battery]    Script Date: 08/03/2012 15:12:53 ******/
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Battery_Battery]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
ALTER TABLE [dbo].[Battery]  WITH CHECK ADD  CONSTRAINT [FK_Battery_Battery] FOREIGN KEY([SerialNumber])
REFERENCES [dbo].[Battery] ([SerialNumber])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Battery_Battery]') AND parent_object_id = OBJECT_ID(N'[dbo].[Battery]'))
ALTER TABLE [dbo].[Battery] CHECK CONSTRAINT [FK_Battery_Battery]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ComputerInserted]') AND type in (N'TR'))
DROP TRIGGER [dbo].[ComputerInserted]
GO

/****** Object:  Trigger [dbo].[ComputerInserted]    Script Date: 07/10/2013 14:10:18 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ComputerInserted]') AND type in (N'TR'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<QKJ486>
-- Create date: <10 July 2013>
-- Description:	<To prevent duplicate record of computer insterted>
-- =============================================
CREATE TRIGGER [dbo].[ComputerInserted]
   ON  [dbo].[Computer]
   FOR INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	IF EXISTS	(SELECT 1
				FROM INSERTED, Computer
				WHERE INSERTED.ComputerName = Computer.ComputerName
				GROUP BY Computer.ComputerName
				HAVING COUNT(Computer.ComputerName)>1)
	BEGIN
		rollback transaction
	END

END
' 
END
GO

IF OBJECT_ID('tempdb..#TEMP') IS NOT NULL
    DROP TABLE #TEMP

SELECT ComputerName, COUNT(ComputerName) AS NoOfRecords INTO #TEMP FROM Computer GROUP BY ComputerName HAVING COUNT(ComputerName) > 1

IF EXISTS (SELECT 1 FROM #TEMP)
BEGIN
	DELETE Computer WHERE ComputerName in (SELECT ComputerName FROM #TEMP)
	INSERT Computer SELECT ComputerName, '', 1, GETDATE() FROM #TEMP 
END
GO

USE FleetManagement 
DECLARE @nt_authority_system NVARCHAR(MAX)
SET @nt_authority_system = SUSER_SNAME(0x010100000000000512000000)
IF NOT EXISTS
(
    SELECT name
    FROM sys.server_principals 
    WHERE IS_SRVROLEMEMBER ('sysadmin', name) = 1 
    AND name LIKE @nt_authority_system 
)
EXEC sp_addsrvrolemember @loginame = @nt_authority_system, @rolename = N'sysadmin'
